/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.options;

import java.util.StringTokenizer;
import org.netbeans.modules.cnd.gizmo.options.GizmoOptionsImpl;

public class GizmoStringConfiguration {
    private GizmoOptionsImpl gizmoOptionsImpl;
    private GizmoStringConfiguration master = null;
    private String def = null;
    private String value;
    private boolean modified;

    public GizmoStringConfiguration(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptionsImpl = gizmoOptionsImpl;
        this.reset();
    }

    public void setMaster(GizmoStringConfiguration master) {
        this.master = master;
    }

    public void setValue(String b) {
        if (b == null) {
            b = "";
        }
        this.value = b;
        if (this.master != null) {
            this.setModified(true);
        } else {
            this.setModified(!b.equals(this.getDefault()));
        }
    }

    public String getValue() {
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        return this.value;
    }

    public String getValueDef(String def) {
        if (this.master != null && !this.getModified() && !this.master.getModified() && def != null) {
            return def;
        }
        if (this.master != null && !this.getModified()) {
            return this.master.getValue();
        }
        if (!this.getModified() && def != null) {
            return def;
        }
        return this.value;
    }

    public String getValue(String delim) {
        StringBuilder ret = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(this.getValue());
        while (tokenizer.hasMoreTokens()) {
            ret.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            ret.append(delim);
        }
        return ret.toString();
    }

    public void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public String getDefault() {
        return this.def;
    }

    public void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public void setDefaultValue(String def) {
        this.def = def;
    }

    public void assign(GizmoStringConfiguration conf) {
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public GizmoStringConfiguration clone() {
        GizmoStringConfiguration clone = new GizmoStringConfiguration(this.gizmoOptionsImpl);
        clone.setValue(this.getValue());
        clone.setModified(this.getModified());
        return clone;
    }

    public GizmoOptionsImpl getGizmoOptionsImpl() {
        return this.gizmoOptionsImpl;
    }

    public void setGizmoOptionsImpl(GizmoOptionsImpl gizmoOptionsImpl) {
        this.gizmoOptionsImpl = gizmoOptionsImpl;
    }
}

