/*
 * Decompiled with CFR 0.152.
 */
package jdbc_adapter;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import jdbc_adapter.JdbcConnectionFactory;
import jdbc_adapter.SQLBlock;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class RubyJdbcConnection
extends RubyObject {
    private static final String[] TABLE_TYPE = new String[]{"TABLE"};
    private static RubyObjectAdapter rubyApi;
    private static ObjectAllocator JDBCCONNECTION_ALLOCATOR;
    private static final int INDEX_TABLE_NAME = 3;
    private static final int INDEX_NON_UNIQUE = 4;
    private static final int INDEX_NAME = 6;
    private static final int INDEX_COLUMN_NAME = 9;
    private static final DateFormat FORMAT;
    private static final int TABLE_NAME = 3;
    private static final int COLUMN_NAME = 4;
    private static final int DATA_TYPE = 5;
    private static final int TYPE_NAME = 6;
    private static final int COLUMN_SIZE = 7;
    private static final int DECIMAL_DIGITS = 9;
    private static final int COLUMN_DEF = 13;
    private static final int IS_NULLABLE = 18;
    private static byte[] CALL;
    private static byte[] INSERT;
    private static byte[] SELECT;
    private static byte[] SHOW;

    protected RubyJdbcConnection(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createJdbcConnectionClass(Ruby ruby) {
        RubyClass rubyClass = RubyJdbcConnection.getConnectionAdapters(ruby).defineClassUnder("JdbcConnection", ruby.getObject(), JDBCCONNECTION_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(RubyJdbcConnection.class);
        rubyApi = JavaEmbedUtils.newObjectAdapter();
        return rubyClass;
    }

    protected static RubyModule getConnectionAdapters(Ruby ruby) {
        return (RubyModule)ruby.getModule("ActiveRecord").getConstant("ConnectionAdapters");
    }

    @JRubyMethod(name={"begin"})
    public IRubyObject begin(ThreadContext threadContext) throws SQLException {
        final Ruby ruby = threadContext.getRuntime();
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            public Object call(Connection connection) throws SQLException {
                RubyJdbcConnection.this.getConnection(true).setAutoCommit(false);
                return ruby.getNil();
            }
        });
    }

    @JRubyMethod(name={"columns", "columns_internal"}, required=1, optional=2)
    public IRubyObject columns_internal(final ThreadContext threadContext, final IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                IRubyObject iRubyObject;
                ResultSet resultSet = null;
                ResultSet resultSet2 = null;
                try {
                    String string = rubyApi.convertToRubyString(iRubyObjectArray[0]).getUnicodeValue();
                    String string2 = null;
                    int n = string.indexOf(".");
                    if (n != -1) {
                        string2 = string.substring(0, n);
                        string = string.substring(n + 1);
                    }
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    if (iRubyObjectArray.length > 2 && string2 == null) {
                        string2 = RubyJdbcConnection.toStringOrNull(iRubyObjectArray[2]);
                    }
                    if (string2 != null) {
                        string2 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string2);
                    }
                    string = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string);
                    String[] stringArray = new String[]{"TABLE", "VIEW", "SYNONYM"};
                    RubyArray rubyArray = (RubyArray)RubyJdbcConnection.this.tableLookupBlock(threadContext.getRuntime(), connection.getCatalog(), string2, string, stringArray, false).call(connection);
                    if (rubyArray.isEmpty()) {
                        throw new SQLException("Table " + string + " does not exist");
                    }
                    resultSet = databaseMetaData.getColumns(connection.getCatalog(), string2, string, null);
                    resultSet2 = databaseMetaData.getPrimaryKeys(connection.getCatalog(), string2, string);
                    iRubyObject = RubyJdbcConnection.this.unmarshal_columns(threadContext, databaseMetaData, resultSet, resultSet2);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    this.close(resultSet2);
                    throw throwable;
                }
                this.close(resultSet);
                this.close(resultSet2);
                return iRubyObject;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"commit"})
    public IRubyObject commit(ThreadContext threadContext) throws SQLException {
        Connection connection = this.getConnection(true);
        if (!connection.getAutoCommit()) {
            try {
                connection.commit();
            }
            finally {
                connection.setAutoCommit(true);
            }
        }
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"connection"}, frame=false)
    public IRubyObject connection() {
        if (this.getConnection() == null) {
            this.reconnect();
        }
        return this.getInstanceVariable("@connection");
    }

    @JRubyMethod(name={"database_name"}, frame=false)
    public IRubyObject database_name(ThreadContext threadContext) throws SQLException {
        Connection connection = this.getConnection(true);
        String string = connection.getCatalog();
        if (null == string && null == (string = connection.getMetaData().getUserName())) {
            string = "db1";
        }
        return threadContext.getRuntime().newString(string);
    }

    @JRubyMethod(name={"disconnect!"}, frame=false)
    public IRubyObject disconnect() {
        return this.setConnection(null);
    }

    @JRubyMethod(name={"execute_id_insert"}, required=2)
    public IRubyObject execute_id_insert(ThreadContext threadContext, final IRubyObject iRubyObject, final IRubyObject iRubyObject2) throws SQLException {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObject).getUnicodeValue());
                try {
                    preparedStatement.setLong(1, RubyNumeric.fix2long((IRubyObject)iRubyObject2));
                    preparedStatement.executeUpdate();
                }
                finally {
                    this.close(preparedStatement);
                }
                return iRubyObject2;
            }
        });
    }

    @JRubyMethod(name={"execute_insert"}, required=1)
    public IRubyObject execute_insert(final ThreadContext threadContext, final IRubyObject iRubyObject) throws SQLException {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    statement.executeUpdate(rubyApi.convertToRubyString(iRubyObject).getUnicodeValue(), 1);
                    IRubyObject iRubyObject2 = RubyJdbcConnection.unmarshal_id_result(threadContext.getRuntime(), statement.getGeneratedKeys());
                    return iRubyObject2;
                }
                finally {
                    this.close(statement);
                }
            }
        });
    }

    @JRubyMethod(name={"execute_query"}, required=1)
    public IRubyObject execute_query(ThreadContext threadContext, IRubyObject iRubyObject) throws SQLException, IOException {
        String string = rubyApi.convertToRubyString(iRubyObject).getUnicodeValue();
        return this.executeQuery(threadContext, string, 0);
    }

    @JRubyMethod(name={"execute_query"}, required=2)
    public IRubyObject execute_query(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws SQLException, IOException {
        String string = rubyApi.convertToRubyString(iRubyObject).getUnicodeValue();
        int n = RubyNumeric.fix2int((IRubyObject)iRubyObject2);
        return this.executeQuery(threadContext, string, n);
    }

    protected IRubyObject executeQuery(final ThreadContext threadContext, final String string, final int n) {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                IRubyObject iRubyObject;
                Statement statement = null;
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    statement = connection.createStatement();
                    statement.setMaxRows(n);
                    iRubyObject = RubyJdbcConnection.this.unmarshalResult(threadContext, databaseMetaData, statement.executeQuery(string), false);
                }
                catch (Throwable throwable) {
                    this.close(statement);
                    throw throwable;
                }
                this.close(statement);
                return iRubyObject;
            }
        });
    }

    @JRubyMethod(name={"execute_update"}, required=1)
    public IRubyObject execute_update(final ThreadContext threadContext, final IRubyObject iRubyObject) throws SQLException {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    RubyFixnum rubyFixnum = threadContext.getRuntime().newFixnum((long)statement.executeUpdate(rubyApi.convertToRubyString(iRubyObject).getUnicodeValue()));
                    return rubyFixnum;
                }
                finally {
                    this.close(statement);
                }
            }
        });
    }

    @JRubyMethod(name={"indexes"})
    public IRubyObject indexes(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.indexes(threadContext, RubyJdbcConnection.toStringOrNull(iRubyObject), RubyJdbcConnection.toStringOrNull(iRubyObject2), RubyJdbcConnection.toStringOrNull(iRubyObject3));
    }

    protected IRubyObject indexes(final ThreadContext threadContext, final String string, String string2, final String string3) {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                String string5;
                Ruby ruby = threadContext.getRuntime();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string2 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string);
                String string32 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string3);
                ResultSet resultSet = null;
                ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
                try {
                    resultSet = databaseMetaData.getIndexInfo(null, string32, string2, false, false);
                    List list = RubyJdbcConnection.this.primaryKeys(threadContext, string2);
                    String string4 = null;
                    RubyClass rubyClass = RubyJdbcConnection.getConnectionAdapters(ruby).getClass("IndexDefinition");
                    while (resultSet.next()) {
                        IRubyObject iRubyObject;
                        string5 = resultSet.getString(6);
                        if (string5 == null) continue;
                        string5 = RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, string5);
                        RubyString rubyString = RubyString.newUnicodeString((Ruby)ruby, (String)RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, resultSet.getString(9)));
                        if (list.contains(rubyString)) continue;
                        if (!string5.equals(string4)) {
                            string4 = string5;
                            string2 = RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, resultSet.getString(3));
                            boolean bl = resultSet.getBoolean(4);
                            IRubyObject iRubyObject2 = rubyClass.callMethod(threadContext, "new", new IRubyObject[]{RubyString.newUnicodeString((Ruby)ruby, (String)string2), RubyString.newUnicodeString((Ruby)ruby, (String)string5), ruby.newBoolean(!bl), ruby.newArray()});
                            arrayList.add(iRubyObject2);
                        }
                        if ((iRubyObject = (IRubyObject)arrayList.get(arrayList.size() - 1)) == null) continue;
                        iRubyObject.callMethod(threadContext, "columns").callMethod(threadContext, "<<", (IRubyObject)rubyString);
                    }
                    string5 = ruby.newArray(arrayList);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return string5;
            }
        });
    }

    @JRubyMethod(name={"insert?"}, required=1, meta=true, frame=false)
    public static IRubyObject insert_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = rubyApi.convertToRubyString(iRubyObject2).getByteList();
        return threadContext.getRuntime().newBoolean(RubyJdbcConnection.startsWithNoCaseCmp(byteList, INSERT));
    }

    @JRubyMethod(name={"insert_bind"}, required=3, rest=true)
    public IRubyObject insert_bind(final ThreadContext threadContext, final IRubyObject[] iRubyObjectArray) throws SQLException {
        final Ruby ruby = threadContext.getRuntime();
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                IRubyObject iRubyObject;
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObjectArray[0]).toString(), 1);
                    RubyJdbcConnection.setValuesOnPS(preparedStatement, threadContext, iRubyObjectArray[1], iRubyObjectArray[2]);
                    preparedStatement.executeUpdate();
                    iRubyObject = RubyJdbcConnection.unmarshal_id_result(ruby, preparedStatement.getGeneratedKeys());
                }
                catch (Throwable throwable) {
                    this.close(preparedStatement);
                    throw throwable;
                }
                this.close(preparedStatement);
                return iRubyObject;
            }
        });
    }

    @JRubyMethod(name={"native_database_types"}, frame=false)
    public IRubyObject native_database_types() {
        return this.getInstanceVariable("@native_database_types");
    }

    @JRubyMethod(name={"primary_keys"}, required=1)
    public IRubyObject primary_keys(ThreadContext threadContext, IRubyObject iRubyObject) throws SQLException {
        return threadContext.getRuntime().newArray(this.primaryKeys(threadContext, iRubyObject.toString()));
    }

    protected List primaryKeys(final ThreadContext threadContext, final String string) {
        return (List)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                Ruby ruby = threadContext.getRuntime();
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                String string2 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string);
                ResultSet resultSet = null;
                ArrayList<RubyString> arrayList = new ArrayList<RubyString>();
                try {
                    resultSet = databaseMetaData.getPrimaryKeys(null, null, string2);
                    while (resultSet.next()) {
                        arrayList.add(RubyString.newUnicodeString((Ruby)ruby, (String)RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, resultSet.getString(4))));
                    }
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return arrayList;
            }
        });
    }

    @JRubyMethod(name={"reconnect!"})
    public IRubyObject reconnect() {
        return this.setConnection(this.getConnectionFactory().newConnection());
    }

    @JRubyMethod(name={"rollback"})
    public IRubyObject rollback(ThreadContext threadContext) throws SQLException {
        final Ruby ruby = threadContext.getRuntime();
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                Connection connection2 = RubyJdbcConnection.this.getConnection(true);
                if (!connection2.getAutoCommit()) {
                    try {
                        connection2.rollback();
                    }
                    finally {
                        connection2.setAutoCommit(true);
                    }
                }
                return ruby.getNil();
            }
        });
    }

    @JRubyMethod(name={"select?"}, required=1, meta=true, frame=false)
    public static IRubyObject select_p(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        ByteList byteList = rubyApi.convertToRubyString(iRubyObject2).getByteList();
        return threadContext.getRuntime().newBoolean(RubyJdbcConnection.startsWithNoCaseCmp(byteList, SELECT) || RubyJdbcConnection.startsWithNoCaseCmp(byteList, SHOW) || RubyJdbcConnection.startsWithNoCaseCmp(byteList, CALL));
    }

    @JRubyMethod(name={"set_native_database_types"})
    public IRubyObject set_native_database_types(ThreadContext threadContext) throws SQLException, IOException {
        Ruby ruby = threadContext.getRuntime();
        DatabaseMetaData databaseMetaData = this.getConnection(true).getMetaData();
        IRubyObject iRubyObject = this.unmarshalResult(threadContext, databaseMetaData, databaseMetaData.getTypeInfo(), true);
        IRubyObject iRubyObject2 = RubyJdbcConnection.getConnectionAdapters(ruby).getConstant("JdbcTypeConverter");
        IRubyObject iRubyObject3 = rubyApi.callMethod(rubyApi.callMethod(iRubyObject2, "new", iRubyObject), "choose_best_types");
        this.setInstanceVariable("@native_types", iRubyObject3);
        return ruby.getNil();
    }

    @JRubyMethod(name={"tables"})
    public IRubyObject tables(ThreadContext threadContext) {
        return this.tables(threadContext, null, null, null, TABLE_TYPE);
    }

    @JRubyMethod(name={"tables"})
    public IRubyObject tables(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.tables(threadContext, RubyJdbcConnection.toStringOrNull(iRubyObject), null, null, TABLE_TYPE);
    }

    @JRubyMethod(name={"tables"})
    public IRubyObject tables(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) {
        return this.tables(threadContext, RubyJdbcConnection.toStringOrNull(iRubyObject), RubyJdbcConnection.toStringOrNull(iRubyObject2), null, TABLE_TYPE);
    }

    @JRubyMethod(name={"tables"})
    public IRubyObject tables(ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
        return this.tables(threadContext, RubyJdbcConnection.toStringOrNull(iRubyObject), RubyJdbcConnection.toStringOrNull(iRubyObject2), RubyJdbcConnection.toStringOrNull(iRubyObject3), TABLE_TYPE);
    }

    @JRubyMethod(name={"tables"}, required=4, rest=true)
    public IRubyObject tables(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.tables(threadContext, RubyJdbcConnection.toStringOrNull(iRubyObjectArray[0]), RubyJdbcConnection.toStringOrNull(iRubyObjectArray[1]), RubyJdbcConnection.toStringOrNull(iRubyObjectArray[2]), RubyJdbcConnection.getTypes(iRubyObjectArray[3]));
    }

    protected IRubyObject tables(ThreadContext threadContext, String string, String string2, String string3, String[] stringArray) {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, this.tableLookupBlock(threadContext.getRuntime(), string, string2, string3, stringArray, false));
    }

    @JRubyMethod(name={"update_bind"}, required=3, rest=true)
    public IRubyObject update_bind(final ThreadContext threadContext, final IRubyObject[] iRubyObjectArray) throws SQLException {
        final Ruby ruby = threadContext.getRuntime();
        Arity.checkArgumentCount((Ruby)ruby, (IRubyObject[])iRubyObjectArray, (int)3, (int)4);
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(rubyApi.convertToRubyString(iRubyObjectArray[0]).toString());
                    RubyJdbcConnection.setValuesOnPS(preparedStatement, threadContext, iRubyObjectArray[1], iRubyObjectArray[2]);
                    preparedStatement.executeUpdate();
                }
                catch (Throwable throwable) {
                    this.close(preparedStatement);
                    throw throwable;
                }
                this.close(preparedStatement);
                return ruby.getNil();
            }
        });
    }

    @JRubyMethod(name={"with_connection_retry_guard"}, frame=true)
    public IRubyObject with_connection_retry_guard(final ThreadContext threadContext, final Block block) {
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            public Object call(Connection connection) throws SQLException {
                return block.call(threadContext, new IRubyObject[]{RubyJdbcConnection.this.wrappedConnection(connection)});
            }
        });
    }

    @JRubyMethod(name={"write_large_object"}, required=6)
    public IRubyObject write_large_object(ThreadContext threadContext, final IRubyObject[] iRubyObjectArray) throws SQLException, IOException {
        final Ruby ruby = threadContext.getRuntime();
        return (IRubyObject)this.withConnectionAndRetry(threadContext, new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                String string = "UPDATE " + rubyApi.convertToRubyString(iRubyObjectArray[2]) + " SET " + rubyApi.convertToRubyString(iRubyObjectArray[1]) + " = ? WHERE " + rubyApi.convertToRubyString(iRubyObjectArray[3]) + "=" + rubyApi.convertToRubyString(iRubyObjectArray[4]);
                PreparedStatement preparedStatement = null;
                try {
                    preparedStatement = connection.prepareStatement(string);
                    if (iRubyObjectArray[0].isTrue()) {
                        ByteList byteList = rubyApi.convertToRubyString(iRubyObjectArray[5]).getByteList();
                        preparedStatement.setBinaryStream(1, (InputStream)new ByteArrayInputStream(byteList.bytes, byteList.begin, byteList.realSize), byteList.realSize);
                    } else {
                        String string2 = rubyApi.convertToRubyString(iRubyObjectArray[5]).getUnicodeValue();
                        preparedStatement.setCharacterStream(1, (Reader)new StringReader(string2), string2.length());
                    }
                    preparedStatement.executeUpdate();
                }
                finally {
                    this.close(preparedStatement);
                }
                return ruby.getNil();
            }
        });
    }

    public static String caseConvertIdentifierForRails(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        return databaseMetaData.storesUpperCaseIdentifiers() ? string.toLowerCase() : string;
    }

    public static String caseConvertIdentifierForJdbc(DatabaseMetaData databaseMetaData, String string) throws SQLException {
        if (string == null) {
            return null;
        }
        if (databaseMetaData.storesUpperCaseIdentifiers()) {
            return string.toUpperCase();
        }
        if (databaseMetaData.storesLowerCaseIdentifiers()) {
            return string.toLowerCase();
        }
        return string;
    }

    protected static void close(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected IRubyObject config_value(ThreadContext threadContext, String string) {
        IRubyObject iRubyObject = this.getInstanceVariable("@config");
        return iRubyObject.callMethod(threadContext, "[]", (IRubyObject)threadContext.getRuntime().newSymbol(string));
    }

    private static String toStringOrNull(IRubyObject iRubyObject) {
        return iRubyObject.isNil() ? null : iRubyObject.toString();
    }

    protected IRubyObject doubleToRuby(Ruby ruby, ResultSet resultSet, double d) throws SQLException, IOException {
        if (d == 0.0 && resultSet.wasNull()) {
            return ruby.getNil();
        }
        return ruby.newFloat(d);
    }

    protected Connection getConnection() {
        return this.getConnection(false);
    }

    protected Connection getConnection(boolean bl) {
        Connection connection = (Connection)this.dataGetStruct();
        if (bl && connection == null) {
            RubyClass rubyClass = this.getRuntime().getModule("ActiveRecord").getClass("ConnectionNotEstablished");
            throw new RaiseException(this.getRuntime(), rubyClass, "no connection available", false);
        }
        return connection;
    }

    protected JdbcConnectionFactory getConnectionFactory() throws RaiseException {
        IRubyObject iRubyObject = this.getInstanceVariable("@connection_factory");
        JdbcConnectionFactory jdbcConnectionFactory = null;
        try {
            jdbcConnectionFactory = (JdbcConnectionFactory)JavaEmbedUtils.rubyToJava((Ruby)iRubyObject.getRuntime(), (IRubyObject)iRubyObject, JdbcConnectionFactory.class);
        }
        catch (Exception exception) {
            jdbcConnectionFactory = null;
        }
        if (jdbcConnectionFactory == null) {
            throw this.getRuntime().newRuntimeError("@connection_factory not set properly");
        }
        return jdbcConnectionFactory;
    }

    private static String[] getTypes(IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyArray)) {
            return new String[]{iRubyObject.toString()};
        }
        IRubyObject[] iRubyObjectArray = rubyApi.convertToJavaArray(iRubyObject);
        String[] stringArray = new String[iRubyObjectArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = iRubyObjectArray[i].toString();
        }
        return stringArray;
    }

    private static int getTypeValueFor(Ruby ruby, IRubyObject iRubyObject) throws SQLException {
        String string;
        if (!(iRubyObject instanceof RubySymbol)) {
            iRubyObject = rubyApi.callMethod(iRubyObject, "class");
        }
        if ((string = iRubyObject.asJavaString()) == "string") {
            return 12;
        }
        if (string == "text") {
            return 2005;
        }
        if (string == "integer") {
            return 4;
        }
        if (string == "decimal") {
            return 3;
        }
        if (string == "float") {
            return 6;
        }
        if (string == "datetime") {
            return 93;
        }
        if (string == "timestamp") {
            return 93;
        }
        if (string == "time") {
            return 92;
        }
        if (string == "date") {
            return 91;
        }
        if (string == "binary") {
            return 2004;
        }
        if (string == "boolean") {
            return 16;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionBroken(ThreadContext threadContext, Connection connection) {
        try {
            IRubyObject iRubyObject = this.config_value(threadContext, "connection_alive_sql");
            if (RubyJdbcConnection.select_p(threadContext, (IRubyObject)this, iRubyObject).isTrue()) {
                String string = rubyApi.convertToRubyString(iRubyObject).toString();
                Statement statement = connection.createStatement();
                try {
                    statement.execute(string);
                }
                finally {
                    RubyJdbcConnection.close(statement);
                }
                return false;
            }
            return !connection.isClosed();
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected IRubyObject integerToRuby(Ruby ruby, ResultSet resultSet, long l) throws SQLException, IOException {
        if (l == 0L && resultSet.wasNull()) {
            return ruby.getNil();
        }
        return ruby.newFixnum(l);
    }

    protected IRubyObject jdbcToRuby(Ruby ruby, int n, int n2, ResultSet resultSet) throws SQLException {
        try {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 2004: {
                    return this.streamToRuby(ruby, resultSet, resultSet.getBinaryStream(n));
                }
                case 2005: {
                    return this.readerToRuby(ruby, resultSet, resultSet.getCharacterStream(n));
                }
                case 93: {
                    return this.timestampToRuby(ruby, resultSet, resultSet.getTimestamp(n));
                }
                case -6: 
                case 4: 
                case 5: {
                    return this.integerToRuby(ruby, resultSet, resultSet.getLong(n));
                }
                case 7: {
                    return this.doubleToRuby(ruby, resultSet, resultSet.getDouble(n));
                }
            }
            return this.stringToRuby(ruby, resultSet, resultSet.getString(n));
        }
        catch (IOException iOException) {
            throw (SQLException)new SQLException(iOException.getMessage()).initCause(iOException);
        }
    }

    protected void populateFromResultSet(ThreadContext threadContext, Ruby ruby, List list, ResultSet resultSet, ColumnData[] columnDataArray) throws SQLException {
        int n = columnDataArray.length;
        while (resultSet.next()) {
            RubyHash rubyHash = RubyHash.newHash((Ruby)ruby);
            for (int i = 0; i < n; ++i) {
                rubyHash.op_aset(threadContext, columnDataArray[i].name, this.jdbcToRuby(ruby, i + 1, columnDataArray[i].type, resultSet));
            }
            list.add(rubyHash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject readerToRuby(Ruby ruby, ResultSet resultSet, Reader reader) throws SQLException, IOException {
        if (reader == null && resultSet.wasNull()) {
            return ruby.getNil();
        }
        StringBuffer stringBuffer = new StringBuffer(2048);
        try {
            char[] cArray = new char[2048];
            int n = reader.read(cArray);
            while (n != -1) {
                stringBuffer.append(cArray, 0, n);
                n = reader.read(cArray);
            }
        }
        finally {
            reader.close();
        }
        return RubyString.newUnicodeString((Ruby)ruby, (String)stringBuffer.toString());
    }

    private IRubyObject setConnection(Connection connection) {
        RubyJdbcConnection.close(this.getConnection());
        IRubyObject iRubyObject = connection != null ? this.wrappedConnection(connection) : this.getRuntime().getNil();
        this.setInstanceVariable("@connection", iRubyObject);
        this.dataWrapStruct(connection);
        return this;
    }

    private static void setValue(PreparedStatement preparedStatement, int n, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws SQLException {
        int n2 = RubyJdbcConnection.getTypeValueFor(threadContext.getRuntime(), iRubyObject2);
        if (iRubyObject.isNil()) {
            preparedStatement.setNull(n, n2);
            return;
        }
        switch (n2) {
            case 12: 
            case 2005: {
                preparedStatement.setString(n, RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                break;
            }
            case 4: {
                preparedStatement.setLong(n, RubyNumeric.fix2long((IRubyObject)iRubyObject));
                break;
            }
            case 6: {
                preparedStatement.setDouble(n, ((RubyNumeric)iRubyObject).getDoubleValue());
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (!(iRubyObject instanceof RubyTime)) {
                    try {
                        Date date = FORMAT.parse(RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                        preparedStatement.setTimestamp(n, new Timestamp(date.getTime()), Calendar.getInstance());
                    }
                    catch (Exception exception) {
                        preparedStatement.setString(n, RubyString.objAsString((ThreadContext)threadContext, (IRubyObject)iRubyObject).toString());
                    }
                    break;
                }
                RubyTime rubyTime = (RubyTime)iRubyObject;
                Date date = rubyTime.getJavaDate();
                long l = date.getTime();
                long l2 = rubyTime.microseconds() - l / 1000L;
                Timestamp timestamp = new Timestamp(l);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                timestamp.setNanos((int)(l2 * 1000L));
                preparedStatement.setTimestamp(n, timestamp, calendar);
                break;
            }
            case 16: {
                preparedStatement.setBoolean(n, iRubyObject.isTrue());
                break;
            }
            default: {
                throw new RuntimeException("type " + iRubyObject2 + " not supported in _bind yet");
            }
        }
    }

    private static void setValuesOnPS(PreparedStatement preparedStatement, ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2) throws SQLException {
        RubyArray rubyArray = (RubyArray)iRubyObject;
        RubyArray rubyArray2 = (RubyArray)iRubyObject2;
        int n = rubyArray.getLength();
        for (int i = 0; i < n; ++i) {
            RubyJdbcConnection.setValue(preparedStatement, i + 1, threadContext, rubyArray.eltInternal(i), rubyArray2.eltInternal(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject streamToRuby(Ruby ruby, ResultSet resultSet, InputStream inputStream) throws SQLException, IOException {
        if (inputStream == null && resultSet.wasNull()) {
            return ruby.getNil();
        }
        ByteList byteList = new ByteList(2048);
        try {
            byte[] byArray = new byte[2048];
            int n = inputStream.read(byArray);
            while (n != -1) {
                byteList.append(byArray, 0, n);
                n = inputStream.read(byArray);
            }
        }
        finally {
            inputStream.close();
        }
        return ruby.newString(byteList);
    }

    protected IRubyObject stringToRuby(Ruby ruby, ResultSet resultSet, String string) throws SQLException, IOException {
        if (string == null && resultSet.wasNull()) {
            return ruby.getNil();
        }
        return RubyString.newUnicodeString((Ruby)ruby, (String)string);
    }

    protected SQLBlock tableLookupBlock(final Ruby ruby, final String string, final String string2, final String string3, final String[] stringArray, final boolean bl) {
        return new SQLBlock(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object call(Connection connection) throws SQLException {
                Object object;
                ResultSet resultSet = null;
                try {
                    DatabaseMetaData databaseMetaData = connection.getMetaData();
                    String string4 = databaseMetaData.getClass().getName().toLowerCase();
                    boolean bl2 = string4.indexOf("oracle") != -1 || string4.indexOf("oci") != -1;
                    String string22 = string2;
                    String string32 = string3;
                    if (string32 != null) {
                        string32 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string32);
                    }
                    if (string22 != null) {
                        string22 = RubyJdbcConnection.caseConvertIdentifierForJdbc(databaseMetaData, string22);
                    }
                    resultSet = databaseMetaData.getTables(string, string22, string32, stringArray);
                    ArrayList<RubyString> arrayList = new ArrayList<RubyString>();
                    while (resultSet.next()) {
                        object = bl ? resultSet.getString(3).toLowerCase() : RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, resultSet.getString(3));
                        if (bl2 && ((String)object).startsWith("bin$")) continue;
                        arrayList.add(RubyString.newUnicodeString((Ruby)ruby, (String)object));
                    }
                    object = ruby.newArray(arrayList);
                }
                catch (Throwable throwable) {
                    this.close(resultSet);
                    throw throwable;
                }
                this.close(resultSet);
                return object;
            }
        };
    }

    protected IRubyObject timestampToRuby(Ruby ruby, ResultSet resultSet, Timestamp timestamp) throws SQLException, IOException {
        if (timestamp == null && resultSet.wasNull()) {
            return ruby.getNil();
        }
        String string = timestamp.toString();
        if (string.endsWith(" 00:00:00.0")) {
            string = string.substring(0, string.length() - " 00:00:00.0".length());
        }
        return RubyString.newUnicodeString((Ruby)ruby, (String)string);
    }

    private int intFromResultSet(ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        return n2 == 0 && resultSet.wasNull() ? -1 : n2;
    }

    private String typeFromResultSet(ResultSet resultSet, boolean bl) throws SQLException {
        int n = this.intFromResultSet(resultSet, 7);
        int n2 = this.intFromResultSet(resultSet, 9);
        if (bl && n != 1 && resultSet.getInt(5) == 3) {
            n = -1;
        }
        String string = resultSet.getString(6);
        if (n > 0) {
            string = string + "(" + n;
            if (n2 > 0) {
                string = string + "," + n2;
            }
            string = string + ")";
        }
        return string;
    }

    private IRubyObject defaultValueFromResultSet(Ruby ruby, ResultSet resultSet) throws SQLException {
        String string = resultSet.getString(13);
        return string == null ? ruby.getNil() : RubyString.newUnicodeString((Ruby)ruby, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IRubyObject unmarshal_columns(ThreadContext threadContext, DatabaseMetaData databaseMetaData, ResultSet resultSet, ResultSet resultSet2) throws SQLException {
        try {
            String string;
            Ruby ruby = threadContext.getRuntime();
            ArrayList<IRubyObject> arrayList = new ArrayList<IRubyObject>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string2 = databaseMetaData.getClass().getName().toLowerCase();
            boolean bl = string2.indexOf("oracle") != -1 || string2.indexOf("oci") != -1;
            RubyHash rubyHash = (RubyHash)this.native_database_types();
            IRubyObject iRubyObject = RubyJdbcConnection.getConnectionAdapters(ruby).getConstant("JdbcColumn");
            while (resultSet2.next()) {
                arrayList2.add(resultSet2.getString(4));
            }
            while (resultSet.next()) {
                string = resultSet.getString(4);
                IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "new", new IRubyObject[]{this.getInstanceVariable("@config"), RubyString.newUnicodeString((Ruby)ruby, (String)RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, string)), this.defaultValueFromResultSet(ruby, resultSet), RubyString.newUnicodeString((Ruby)ruby, (String)this.typeFromResultSet(resultSet, bl)), ruby.newBoolean(!resultSet.getString(18).trim().equals("NO"))});
                arrayList.add(iRubyObject2);
                IRubyObject iRubyObject3 = rubyHash.fastARef(iRubyObject2.callMethod(threadContext, "type"));
                if (iRubyObject3 != null && !iRubyObject3.isNil() && iRubyObject3.callMethod(threadContext, "[]", (IRubyObject)ruby.newSymbol("limit")).isNil()) {
                    iRubyObject2.callMethod(threadContext, "limit=", ruby.getNil());
                    if (!iRubyObject2.callMethod(threadContext, "type").equals(ruby.newSymbol("decimal"))) {
                        iRubyObject2.callMethod(threadContext, "precision=", ruby.getNil());
                    }
                }
                if (!arrayList2.contains(string)) continue;
                iRubyObject2.callMethod(threadContext, "primary=", (IRubyObject)ruby.getTrue());
            }
            string = ruby.newArray(arrayList);
            return string;
        }
        finally {
            RubyJdbcConnection.close(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject unmarshal_id_result(Ruby ruby, ResultSet resultSet) throws SQLException {
        try {
            if (resultSet.next() && resultSet.getMetaData().getColumnCount() > 0) {
                RubyFixnum rubyFixnum = ruby.newFixnum(resultSet.getLong(1));
                return rubyFixnum;
            }
            IRubyObject iRubyObject = ruby.getNil();
            return iRubyObject;
        }
        finally {
            RubyJdbcConnection.close(resultSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRubyObject unmarshalResult(ThreadContext threadContext, DatabaseMetaData databaseMetaData, ResultSet resultSet, boolean bl) throws SQLException {
        Ruby ruby = threadContext.getRuntime();
        ArrayList arrayList = new ArrayList();
        try {
            ColumnData[] columnDataArray = ColumnData.setup(ruby, databaseMetaData, resultSet.getMetaData(), bl);
            this.populateFromResultSet(threadContext, ruby, arrayList, resultSet, columnDataArray);
        }
        finally {
            RubyJdbcConnection.close(resultSet);
        }
        return ruby.newArray(arrayList);
    }

    protected Object withConnectionAndRetry(ThreadContext threadContext, SQLBlock sQLBlock) {
        int n = 1;
        int n2 = 0;
        Throwable throwable = null;
        boolean bl = false;
        while (n2 < n) {
            Connection connection = this.getConnection(true);
            try {
                bl = connection.getAutoCommit();
                return sQLBlock.call(connection);
            }
            catch (Exception exception) {
                for (throwable = exception; throwable.getCause() != null && throwable.getCause() != throwable; throwable = throwable.getCause()) {
                }
                ++n2;
                if (!bl) continue;
                if (n2 == 1 && (n = (int)rubyApi.convertToRubyInteger(this.config_value(threadContext, "retry_count")).getLongValue()) <= 0) {
                    n = 1;
                }
                if (this.isConnectionBroken(threadContext, connection)) {
                    this.reconnect();
                    continue;
                }
                throw RubyJdbcConnection.wrap(threadContext, throwable);
            }
        }
        throw RubyJdbcConnection.wrap(threadContext, throwable);
    }

    private static RuntimeException wrap(ThreadContext threadContext, Throwable throwable) {
        RubyClass rubyClass = threadContext.getRuntime().getModule("ActiveRecord").getClass("ActiveRecordError");
        return (RuntimeException)new RaiseException(threadContext.getRuntime(), rubyClass, throwable.getMessage(), false).initCause(throwable);
    }

    private IRubyObject wrappedConnection(Connection connection) {
        return Java.java_to_ruby((IRubyObject)this, (IRubyObject)JavaObject.wrap((Ruby)this.getRuntime(), (Object)connection), (Block)Block.NULL_BLOCK);
    }

    private static int whitespace(int n, ByteList byteList) {
        int n2 = byteList.begin + byteList.realSize;
        for (int i = n; i < n2; ++i) {
            if (Character.isWhitespace(byteList.bytes[i])) continue;
            return i;
        }
        return n2;
    }

    private static boolean startsWithNoCaseCmp(ByteList byteList, byte[] byArray) {
        int n = RubyJdbcConnection.whitespace(byteList.begin, byteList);
        if (byteList.bytes[n] == 40) {
            n = RubyJdbcConnection.whitespace(n, byteList);
        }
        for (int i = 0; i < byteList.realSize && i < byArray.length; ++i) {
            if (Character.toLowerCase(byteList.bytes[n + i]) == byArray[i]) continue;
            return false;
        }
        return true;
    }

    static {
        JDBCCONNECTION_ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
                return new RubyJdbcConnection(ruby, rubyClass);
            }
        };
        FORMAT = new SimpleDateFormat("%y-%M-%d %H:%m:%s");
        CALL = new byte[]{99, 97, 108, 108};
        INSERT = new byte[]{105, 110, 115, 101, 114, 116};
        SELECT = new byte[]{115, 101, 108, 101, 99, 116};
        SHOW = new byte[]{115, 104, 111, 119};
    }

    public static class ColumnData {
        public IRubyObject name;
        public int type;

        public ColumnData(IRubyObject iRubyObject, int n) {
            this.name = iRubyObject;
            this.type = n;
        }

        public static ColumnData[] setup(Ruby ruby, DatabaseMetaData databaseMetaData, ResultSetMetaData resultSetMetaData, boolean bl) throws SQLException {
            int n = resultSetMetaData.getColumnCount();
            ColumnData[] columnDataArray = new ColumnData[n];
            for (int i = 1; i <= n; ++i) {
                String string = bl ? resultSetMetaData.getColumnLabel(i).toLowerCase() : RubyJdbcConnection.caseConvertIdentifierForRails(databaseMetaData, resultSetMetaData.getColumnLabel(i));
                columnDataArray[i - 1] = new ColumnData((IRubyObject)RubyString.newUnicodeString((Ruby)ruby, (String)string), resultSetMetaData.getColumnType(i));
            }
            return columnDataArray;
        }
    }
}

