/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.EventQueue;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadMapVisualizer;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class ThreadMapTopComponent
extends TopComponent
implements VisualizerContainer {
    private static ThreadMapTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/dlight/visualizers/resources/threadsWindow.png";
    private static final String PREFERRED_ID = "ThreadMapTopComponent";
    private String currentToolName;
    private JComponent viewComponent;

    public ThreadMapTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"CTL_ThreadMapTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"HINT_ThreadMapTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ThreadMapTopComponent getDefault() {
        if (instance == null) {
            instance = new ThreadMapTopComponent();
        }
        return instance;
    }

    public static synchronized ThreadMapTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(ThreadMapTopComponent.class.getName()).warning("Cannot find ThreadMapTopComponent component. It will not be located properly in the window system.");
            return ThreadMapTopComponent.getDefault();
        }
        if (win instanceof ThreadMapTopComponent) {
            return (ThreadMapTopComponent)win;
        }
        Logger.getLogger(ThreadMapTopComponent.class.getName()).warning("There seem to be multiple components with the 'ThreadMapTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ThreadMapTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)this.viewComponent).shutdown();
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            this.viewComponent.requestFocus();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    Object readProperties(Properties p) {
        ThreadMapTopComponent singleton = ThreadMapTopComponent.getDefault();
        singleton.readPropertiesImpl(p);
        return singleton;
    }

    private void readPropertiesImpl(Properties p) {
        String version = p.getProperty("version");
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void addVisualizer(String toolID, String toolName, Visualizer<?> view) {
        if (view instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)view).setToolID(toolID);
        }
        this.setContent(toolName, view.getComponent());
        view.refresh();
    }

    public void setContent(String toolName, JComponent component) {
        if (this.currentToolName != null && this.currentToolName.equals(toolName) && this.viewComponent == component) {
            return;
        }
        this.currentToolName = toolName;
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.viewComponent = component;
        this.add(this.viewComponent, "Center");
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
        this.repaint();
    }

    public void addContent(String toolName, JComponent component) {
        if (this.currentToolName == null || !this.currentToolName.equals(toolName) || this.viewComponent != component) {
            this.currentToolName = toolName;
            this.removeAll();
            this.setLayout(new BorderLayout());
        }
        this.viewComponent = component;
        this.add(this.viewComponent);
        this.setName(toolName);
        this.setToolTipText(toolName);
        this.validate();
        this.repaint();
    }

    public void removeVisualizer(final Visualizer<?> view) {
        if (EventQueue.isDispatchThread()) {
            this.closePerformanceMonitor(view);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ThreadMapTopComponent.this.closePerformanceMonitor(view);
                }
            });
        }
    }

    public void showup() {
        this.open();
        this.requestActive();
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ThreadMapVisualizer view = (ThreadMapVisualizer)this.viewComponent;
            view.startup();
        }
    }

    private void closePerformanceMonitor(Visualizer<?> view) {
        if (this.viewComponent != view.getComponent()) {
            return;
        }
        if (this.viewComponent instanceof ThreadMapVisualizer) {
            ((ThreadMapVisualizer)view).shutdown();
        }
        this.remove(view.getComponent());
        this.setName(NbBundle.getMessage(ThreadMapTopComponent.class, (String)"ThreadMapDetailes"));
        this.repaint();
    }
}

