/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javawebstart.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.javawebstart.CustomizerRunComponent;
import org.netbeans.modules.javawebstart.ui.customizer.AppletParametersPanel;
import org.netbeans.modules.javawebstart.ui.customizer.ExtensionResourcesPanel;
import org.netbeans.modules.javawebstart.ui.customizer.JWSProjectProperties;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JWSCustomizerPanel
extends JPanel
implements HelpCtx.Provider {
    private JWSProjectProperties jwsProps;
    private File lastImageFolder = null;
    private static String[] extResColumnNames;
    private static String[] appletParamsColumnNames;
    public static CustomizerRunComponent runComponent;
    private JComboBox appletClassComboBox;
    private JLabel appletClassLabel;
    private JRadioButton appletDescRadioButton;
    private JButton appletParamsButton;
    private JRadioButton applicationDescRadioButton;
    private JButton browseButton;
    private JComboBox codebaseComboBox;
    private JLabel codebaseLabel;
    private JTextField codebaseTextField;
    private JLabel codebaseValueLabel;
    private JRadioButton compDescRadioButton;
    private ButtonGroup descButtonGroup;
    private JCheckBox enableCheckBox;
    private JButton extResButton;
    private JLabel iconLabel;
    private JTextField iconTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator1;
    private JComboBox mixedCodeCombo;
    private JLabel mixedCodeLabel;
    private JCheckBox offlineCheckBox;
    private JLabel panelDescLabel;
    private JCheckBox signedCheckBox;
    private JTextArea warningArea;

    public JWSCustomizerPanel(JWSProjectProperties jWSProjectProperties) {
        this.jwsProps = jWSProjectProperties;
        this.initComponents();
        this.enableCheckBox.setModel(this.jwsProps.enabledModel);
        this.enableCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.mnemonic").toCharArray()[0]);
        this.offlineCheckBox.setModel(this.jwsProps.allowOfflineModel);
        this.offlineCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.mnemonic").toCharArray()[0]);
        this.signedCheckBox.setModel(this.jwsProps.signedModel);
        this.signedCheckBox.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signedCheckBox.mnemonic").toCharArray()[0]);
        this.iconTextField.setDocument(this.jwsProps.iconDocument);
        this.codebaseComboBox.setModel(this.jwsProps.codebaseModel);
        this.codebaseTextField.setDocument(this.jwsProps.codebaseURLDocument);
        this.appletClassComboBox.setModel(this.jwsProps.appletClassModel);
        this.applicationDescRadioButton.setModel(this.jwsProps.applicationDescButtonModel);
        this.applicationDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.mnemonic").toCharArray()[0]);
        this.appletDescRadioButton.setModel(this.jwsProps.appletDescButtonModel);
        this.appletDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.mnemonic").toCharArray()[0]);
        this.compDescRadioButton.setModel(this.jwsProps.compDescButtonModel);
        this.compDescRadioButton.setMnemonic(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.mnemonic").toCharArray()[0]);
        this.setCodebaseComponents();
        boolean bl = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(bl);
        JWSCustomizerPanel.setEnabledRunComponent(bl);
        this.setEnabledAppletControls(this.appletDescRadioButton.isSelected());
        if (this.jwsProps.isJnlpImplPreviousVersion) {
            this.warningArea.setVisible(true);
            this.extResButton.setEnabled(false);
            this.appletDescRadioButton.setEnabled(false);
            this.appletClassLabel.setEnabled(false);
            this.appletClassComboBox.setEnabled(false);
            this.appletParamsButton.setEnabled(false);
            this.compDescRadioButton.setEnabled(false);
        } else {
            this.warningArea.setVisible(false);
        }
        extResColumnNames = new String[]{NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.href"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.name"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResources.version")};
        appletParamsColumnNames = new String[]{NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParams.name"), NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParams.value")};
        this.signedChanged(null);
    }

    private static void setEnabledRunComponent(boolean bl) {
        runComponent.setCheckboxEnabled(bl);
        runComponent.setHintVisible(!bl);
    }

    private void initComponents() {
        this.descButtonGroup = new ButtonGroup();
        this.enableCheckBox = new JCheckBox();
        this.iconLabel = new JLabel();
        this.codebaseLabel = new JLabel();
        this.iconTextField = new JTextField();
        this.browseButton = new JButton();
        this.codebaseComboBox = new JComboBox();
        this.codebaseValueLabel = new JLabel();
        this.codebaseTextField = new JTextField();
        this.offlineCheckBox = new JCheckBox();
        this.panelDescLabel = new JLabel();
        this.signedCheckBox = new JCheckBox();
        this.extResButton = new JButton();
        this.jPanel1 = new JPanel();
        this.applicationDescRadioButton = new JRadioButton();
        this.appletClassLabel = new JLabel();
        this.compDescRadioButton = new JRadioButton();
        this.appletDescRadioButton = new JRadioButton();
        this.appletClassComboBox = new JComboBox();
        this.appletParamsButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.warningArea = new JTextArea();
        this.jPanel2 = new JPanel();
        this.mixedCodeLabel = new JLabel();
        this.mixedCodeCombo = new JComboBox();
        this.jPanel3 = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.enableCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.enableCheckBox.text"));
        this.enableCheckBox.setMargin(new Insets(0, 0, 0, 2));
        this.enableCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.enableCheckBoxActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.add((Component)this.enableCheckBox, gridBagConstraints);
        this.enableCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_EnableWebStart_CheckBox"));
        this.enableCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_EnableWebStart_Label"));
        this.iconLabel.setLabelFor(this.iconTextField);
        Mnemonics.setLocalizedText((JLabel)this.iconLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.iconLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.iconLabel, gridBagConstraints);
        this.iconLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_Label"));
        this.iconLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_Label"));
        this.codebaseLabel.setLabelFor(this.codebaseComboBox);
        Mnemonics.setLocalizedText((JLabel)this.codebaseLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codebaseLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.codebaseLabel, gridBagConstraints);
        this.codebaseLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Label"));
        this.codebaseLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.iconTextField, gridBagConstraints);
        this.iconTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Icon_TextField"));
        this.iconTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Icon_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.browseButton.text"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 0);
        this.add((Component)this.browseButton, gridBagConstraints);
        this.browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Browse_Button"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Browse_Button"));
        this.codebaseComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.codebaseComboBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.codebaseComboBox, gridBagConstraints);
        this.codebaseComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Combobox"));
        this.codebaseComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Combobox"));
        this.codebaseValueLabel.setLabelFor(this.codebaseTextField);
        Mnemonics.setLocalizedText((JLabel)this.codebaseValueLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.codebaseValueLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.codebaseValueLabel, gridBagConstraints);
        this.codebaseValueLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_Result_Label"));
        this.codebaseValueLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_Result_Label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.add((Component)this.codebaseTextField, gridBagConstraints);
        this.codebaseTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_Codebase_TextField"));
        this.codebaseTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_Codebase_TextField"));
        Mnemonics.setLocalizedText((AbstractButton)this.offlineCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.offlineCheckBox.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.offlineCheckBox, gridBagConstraints);
        this.offlineCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_AllowOffline_Checkbox"));
        this.offlineCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_AllowOffline_Checkbox"));
        Mnemonics.setLocalizedText((JLabel)this.panelDescLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.panelDescLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.panelDescLabel, gridBagConstraints);
        this.panelDescLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_WebStartTitle_Label"));
        this.panelDescLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_WebStartTitle_Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.signedCheckBox, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.signedCheckBox.text"));
        this.signedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.signedChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.signedCheckBox, gridBagConstraints);
        this.signedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSN_SelfSigned_Checkbox"));
        this.signedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"ACSD_SelfSigned_Checkbox"));
        Mnemonics.setLocalizedText((AbstractButton)this.extResButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResButton.text"));
        this.extResButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.extResButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.extResButton, gridBagConstraints);
        this.extResButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.extResButton.AccessibleContext.accessibleDescription"));
        this.jPanel1.setLayout(new GridBagLayout());
        this.descButtonGroup.add(this.applicationDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.applicationDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.text"));
        this.applicationDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.applicationDescRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.applicationDescRadioButton, gridBagConstraints);
        this.applicationDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.applicationDescRadioButton.AccessibleContext.accessibleDescription"));
        this.appletClassLabel.setLabelFor(this.appletClassComboBox);
        Mnemonics.setLocalizedText((JLabel)this.appletClassLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 34, 0, 4);
        this.jPanel1.add((Component)this.appletClassLabel, gridBagConstraints);
        this.appletClassLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassLabel.AccessibleContext.accessibleDescription"));
        this.descButtonGroup.add(this.compDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.compDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.text"));
        this.compDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.compDescRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.compDescRadioButton, gridBagConstraints);
        this.compDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.compDescRadioButton.AccessibleContext.accessibleDescription"));
        this.descButtonGroup.add(this.appletDescRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.appletDescRadioButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.text"));
        this.appletDescRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.appletDescRadioButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel1.add((Component)this.appletDescRadioButton, gridBagConstraints);
        this.appletDescRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletDescRadioButton.AccessibleContext.accessibleDescription"));
        this.appletClassComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"org.testapplication.TestApplet", "Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.appletClassComboBox, gridBagConstraints);
        this.appletClassComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassComboBox.AccessibleContext.accessibleName"));
        this.appletClassComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletClassComboBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.appletParamsButton, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParamsButton.text"));
        this.appletParamsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JWSCustomizerPanel.this.appletParamsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanel1.add((Component)this.appletParamsButton, gridBagConstraints);
        this.appletParamsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.appletParamsButton.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.jSeparator1, gridBagConstraints);
        this.warningArea.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        this.warningArea.setColumns(20);
        this.warningArea.setEditable(false);
        this.warningArea.setLineWrap(true);
        this.warningArea.setRows(2);
        this.warningArea.setText(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"Previous_Version_Script_Warning"));
        this.warningArea.setWrapStyleWord(true);
        this.warningArea.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(4, 4, 4, 0);
        this.add((Component)this.warningArea, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.mixedCodeLabel.setLabelFor(this.mixedCodeCombo);
        Mnemonics.setLocalizedText((JLabel)this.mixedCodeLabel, (String)NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TXT_MixedCodeLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.mixedCodeLabel, gridBagConstraints);
        this.mixedCodeCombo.setModel(this.jwsProps.mixedCodeModel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.mixedCodeCombo, gridBagConstraints);
        this.mixedCodeCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"AN_MixedCodeLabel"));
        this.mixedCodeCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"AD_MixedCodeLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel2.add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"JWSCustomizerPanel.AccessibleContext.accessibleDescription"));
    }

    private void codebaseComboBoxActionPerformed(ActionEvent actionEvent) {
        this.setCodebaseComponents();
    }

    private void enableCheckBoxActionPerformed(ActionEvent actionEvent) {
        boolean bl = this.enableCheckBox.getModel().isSelected();
        this.setEnabledAllComponents(bl);
        JWSCustomizerPanel.setEnabledRunComponent(bl);
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileFilter(new IconFileFilter());
        if (this.lastImageFolder != null) {
            jFileChooser.setSelectedFile(this.lastImageFolder);
        }
        jFileChooser.setDialogTitle(NbBundle.getMessage(JWSCustomizerPanel.class, (String)"LBL_Select_Icon_Image"));
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            this.iconTextField.setText(file.getAbsolutePath());
            this.lastImageFolder = file.getParentFile();
        }
    }

    private void applicationDescRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setEnabledAppletControls(false);
        this.jwsProps.updateDescType();
    }

    private void extResButtonActionPerformed(ActionEvent actionEvent) {
        List<Map<String, String>> list = this.jwsProps.getExtResProperties();
        List<Map<String, String>> list2 = this.copyList(list);
        ExtensionResourcesPanel extensionResourcesPanel = new ExtensionResourcesPanel(new JWSProjectProperties.PropertiesTableModel(list2, JWSProjectProperties.extResSuffixes, extResColumnNames));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)extensionResourcesPanel, NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TITLE_ExtensionResources"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.jwsProps.setExtResProperties(list2);
        }
        dialog.dispose();
    }

    private void appletDescRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setEnabledAppletControls(true);
        this.jwsProps.updateDescType();
    }

    private void compDescRadioButtonActionPerformed(ActionEvent actionEvent) {
        this.setEnabledAppletControls(false);
        this.jwsProps.updateDescType();
    }

    private void appletParamsButtonActionPerformed(ActionEvent actionEvent) {
        List<Map<String, String>> list = this.jwsProps.getAppletParamsProperties();
        List<Map<String, String>> list2 = this.copyList(list);
        JWSProjectProperties.PropertiesTableModel propertiesTableModel = new JWSProjectProperties.PropertiesTableModel(list2, JWSProjectProperties.appletParamsSuffixes, appletParamsColumnNames);
        AppletParametersPanel appletParametersPanel = new AppletParametersPanel(propertiesTableModel, this.jwsProps.appletWidthDocument, this.jwsProps.appletHeightDocument);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)appletParametersPanel, NbBundle.getMessage(JWSCustomizerPanel.class, (String)"TITLE_AppletParameters"), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            this.jwsProps.setAppletParamsProperties(list2);
        }
        dialog.dispose();
    }

    private void signedChanged(ActionEvent actionEvent) {
        boolean bl = this.signedCheckBox.isSelected();
        this.mixedCodeLabel.setEnabled(bl);
        this.mixedCodeCombo.setEnabled(bl);
    }

    private void setEnabledAppletControls(boolean bl) {
        this.appletClassLabel.setEnabled(bl);
        this.appletClassComboBox.setEnabled(bl);
        this.appletParamsButton.setEnabled(bl);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JWSCustomizerPanel.class);
    }

    private JWSProjectProperties.CodebaseComboBoxModel getCBModel() {
        return (JWSProjectProperties.CodebaseComboBoxModel)this.codebaseComboBox.getModel();
    }

    private void setCodebaseComponents() {
        String string = this.getCBModel().getSelectedCodebaseItem();
        if ("local".equals(string)) {
            this.codebaseTextField.setText(this.jwsProps.getProjectDistDir());
            this.codebaseTextField.setEditable(false);
        } else if ("web".equals(string)) {
            this.codebaseTextField.setText("$$codebase");
            this.codebaseTextField.setEditable(false);
        } else if ("user".equals(string)) {
            this.codebaseTextField.setText(this.jwsProps.getCodebaseLocation());
            this.codebaseTextField.setEditable(true);
        } else if ("no.codebase".equals(string)) {
            this.codebaseTextField.setText("");
            this.codebaseTextField.setEditable(false);
        }
    }

    private void setEnabledAllComponents(boolean bl) {
        this.iconLabel.setEnabled(bl);
        this.iconTextField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
        this.codebaseLabel.setEnabled(bl);
        this.codebaseComboBox.setEnabled(bl);
        this.codebaseValueLabel.setEnabled(bl);
        this.codebaseTextField.setEnabled(bl);
        this.offlineCheckBox.setEnabled(bl);
        this.signedCheckBox.setEnabled(bl);
        this.extResButton.setEnabled(bl);
        this.applicationDescRadioButton.setEnabled(bl);
        this.appletDescRadioButton.setEnabled(bl);
        this.compDescRadioButton.setEnabled(bl);
        if (!bl || bl && this.appletDescRadioButton.isSelected()) {
            this.setEnabledAppletControls(bl);
        }
    }

    private List<Map<String, String>> copyList(List<Map<String, String>> list) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        for (Map<String, String> map : list) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : map.keySet()) {
                String string2 = map.get(string);
                hashMap.put(string, string2);
            }
            arrayList.add(hashMap);
        }
        return arrayList;
    }

    static {
        runComponent = new CustomizerRunComponent();
    }

    private static class IconFileFilter
    extends FileFilter {
        private IconFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            String string;
            if (file.isDirectory()) {
                return true;
            }
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            return n > 0 && n < string2.length() - 1 && ("gif".equals(string = string2.substring(n + 1).toLowerCase()) || "png".equals(string) || "jpg".equals(string));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(JWSCustomizerPanel.class, (String)"MSG_IconFileFilter_Description");
        }
    }
}

