/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.api.ui;

import org.netbeans.modules.cnd.callgraph.api.CallModel;
import org.netbeans.modules.cnd.callgraph.api.ui.CallGraphUI;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public abstract class CallGraphModelFactory {
    private static final CallGraphModelFactory DEFAULT = new Default();

    protected CallGraphModelFactory() {
    }

    public abstract CallModel getModel(Node[] var1);

    public abstract CallGraphUI getUI(CallModel var1);

    public abstract boolean isCallGraphAvailiable(Node[] var1);

    public static CallGraphModelFactory getDefault() {
        return DEFAULT;
    }

    private static final class Default
    extends CallGraphModelFactory {
        private final Lookup.Result<CallGraphModelFactory> res = Lookup.getDefault().lookupResult(CallGraphModelFactory.class);

        private Default() {
        }

        @Override
        public CallModel getModel(Node[] activatedNodes) {
            for (CallGraphModelFactory resolver : this.res.allInstances()) {
                CallModel out = resolver.getModel(activatedNodes);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public CallGraphUI getUI(CallModel model) {
            for (CallGraphModelFactory resolver : this.res.allInstances()) {
                CallGraphUI out = resolver.getUI(model);
                if (out == null) continue;
                return out;
            }
            return null;
        }

        @Override
        public boolean isCallGraphAvailiable(Node[] activatedNodes) {
            for (CallGraphModelFactory resolver : this.res.allInstances()) {
                if (!resolver.isCallGraphAvailiable(activatedNodes)) continue;
                return true;
            }
            return false;
        }
    }
}

