/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Comparator;
import org.h2.command.Parser;
import org.h2.command.dml.ScriptBase;
import org.h2.command.dml.SetTypes;
import org.h2.constant.SysProperties;
import org.h2.constraint.Constraint;
import org.h2.engine.Comment;
import org.h2.engine.Database;
import org.h2.engine.DbObjectBase;
import org.h2.engine.FunctionAlias;
import org.h2.engine.Right;
import org.h2.engine.Role;
import org.h2.engine.Session;
import org.h2.engine.Setting;
import org.h2.engine.User;
import org.h2.engine.UserAggregate;
import org.h2.engine.UserDataType;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionColumn;
import org.h2.index.Index;
import org.h2.message.Message;
import org.h2.result.LocalResult;
import org.h2.result.Row;
import org.h2.schema.Constant;
import org.h2.schema.Schema;
import org.h2.schema.SchemaObjectBase;
import org.h2.schema.Sequence;
import org.h2.schema.TriggerObject;
import org.h2.table.Column;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.AutoCloseInputStream;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.ObjectArray;
import org.h2.util.StringUtils;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueString;

public class ScriptCommand
extends ScriptBase {
    private static final String TEMP_LOB_FILENAME = "system_temp_lob.db";
    private boolean passwords;
    private boolean data;
    private boolean settings;
    private boolean drop;
    private boolean simple;
    private LocalResult result;
    private byte[] lineSeparator;
    private byte[] buffer;
    private boolean tempLobTableCreated;
    private int nextLobId;
    private int lobBlockSize = 4096;

    public ScriptCommand(Session session) {
        super(session);
    }

    public boolean isQuery() {
        return true;
    }

    public void setData(boolean bl) {
        this.data = bl;
    }

    public void setPasswords(boolean bl) {
        this.passwords = bl;
    }

    public void setSettings(boolean bl) {
        this.settings = bl;
    }

    public void setLobBlockSize(long l) {
        this.lobBlockSize = MathUtils.convertLongToInt(l);
    }

    public void setDrop(boolean bl) {
        this.drop = bl;
    }

    public LocalResult queryMeta() throws SQLException {
        LocalResult localResult = this.createResult();
        localResult.done();
        return localResult;
    }

    private LocalResult createResult() {
        Expression[] expressionArray = new Expression[]{new ExpressionColumn(this.session.getDatabase(), new Column("SCRIPT", 13))};
        return new LocalResult(this.session, expressionArray, 1);
    }

    public LocalResult query(int n) throws SQLException {
        Object object;
        this.session.getUser().checkAdmin();
        this.reset();
        try {
            Object object2;
            Object object3;
            Object object4;
            int n2;
            Object object5;
            DbObjectBase dbObjectBase;
            int n3;
            ObjectArray objectArray;
            this.result = this.createResult();
            this.deleteStore();
            this.openOutput();
            if (this.out != null) {
                this.buffer = new byte[4096];
            }
            object = this.session.getDatabase();
            if (this.settings) {
                objectArray = ((Database)object).getAllSettings();
                for (n3 = 0; n3 < objectArray.size(); ++n3) {
                    dbObjectBase = (Setting)objectArray.get(n3);
                    if (dbObjectBase.getName().equals(SetTypes.getTypeName(34))) continue;
                    this.add(((Setting)dbObjectBase).getCreateSQL(), false);
                }
            }
            if (this.out != null) {
                this.add("", true);
            }
            objectArray = ((Database)object).getAllUsers();
            for (n3 = 0; n3 < objectArray.size(); ++n3) {
                dbObjectBase = (User)objectArray.get(n3);
                this.add(((User)dbObjectBase).getCreateSQL(this.passwords, true), false);
            }
            ObjectArray objectArray2 = ((Database)object).getAllRoles();
            for (int i = 0; i < objectArray2.size(); ++i) {
                Role role = (Role)objectArray2.get(i);
                this.add(role.getCreateSQL(true), false);
            }
            ObjectArray objectArray3 = ((Database)object).getAllSchemas();
            for (int i = 0; i < objectArray3.size(); ++i) {
                Schema schema = (Schema)objectArray3.get(i);
                this.add(schema.getCreateSQL(), false);
            }
            ObjectArray objectArray4 = ((Database)object).getAllUserDataTypes();
            for (int i = 0; i < objectArray4.size(); ++i) {
                UserDataType userDataType = (UserDataType)objectArray4.get(i);
                if (this.drop) {
                    this.add(userDataType.getDropSQL(), false);
                }
                this.add(userDataType.getCreateSQL(), false);
            }
            ObjectArray objectArray5 = ((Database)object).getAllSchemaObjects(11);
            for (int i = 0; i < objectArray5.size(); ++i) {
                Constant constant = (Constant)objectArray5.get(i);
                this.add(constant.getCreateSQL(), false);
            }
            ObjectArray objectArray6 = ((Database)object).getAllFunctionAliases();
            for (int i = 0; i < objectArray6.size(); ++i) {
                FunctionAlias functionAlias = (FunctionAlias)objectArray6.get(i);
                if (this.drop) {
                    this.add(functionAlias.getDropSQL(), false);
                }
                this.add(functionAlias.getCreateSQL(), false);
            }
            ObjectArray objectArray7 = ((Database)object).getAllAggregates();
            for (int i = 0; i < objectArray7.size(); ++i) {
                UserAggregate userAggregate = (UserAggregate)objectArray7.get(i);
                if (this.drop) {
                    this.add(userAggregate.getDropSQL(), false);
                }
                this.add(userAggregate.getCreateSQL(), false);
            }
            ObjectArray objectArray8 = ((Database)object).getAllSchemaObjects(0);
            objectArray8.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    Table table = (Table)object;
                    Table table2 = (Table)object2;
                    return table.getId() - table2.getId();
                }
            });
            for (int i = 0; i < objectArray8.size(); ++i) {
                Table table = (Table)objectArray8.get(i);
                table.lock(this.session, false, false);
                object5 = table.getCreateSQL();
                if (object5 == null || !this.drop) continue;
                this.add(table.getDropSQL(), false);
            }
            ObjectArray objectArray9 = ((Database)object).getAllSchemaObjects(3);
            for (n2 = 0; n2 < objectArray9.size(); ++n2) {
                object5 = (Sequence)objectArray9.get(n2);
                if (this.drop) {
                    this.add(((Sequence)object5).getDropSQL(), false);
                }
                this.add(((Sequence)object5).getCreateSQL(), false);
            }
            for (n2 = 0; n2 < objectArray8.size(); ++n2) {
                Object object6;
                object5 = (Table)objectArray8.get(n2);
                ((Table)object5).lock(this.session, false, false);
                object4 = ((DbObjectBase)object5).getCreateSQL();
                if (object4 == null) continue;
                object3 = ((Table)object5).getTableType();
                this.add((String)object4, false);
                if ("TABLE".equals(object3)) {
                    if (((Table)object5).canGetRowCount()) {
                        object2 = "-- " + ((Table)object5).getRowCount(this.session) + " = SELECT COUNT(*) FROM " + ((SchemaObjectBase)object5).getSQL();
                        this.add((String)object2, false);
                    }
                    if (this.data) {
                        object2 = ((Table)object5).getBestPlanItem(this.session, null);
                        Index index = ((PlanItem)object2).getIndex();
                        object6 = index.find(this.session, null, null);
                        Column[] columnArray = ((Table)object5).getColumns();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("INSERT INTO ");
                        stringBuffer.append(((SchemaObjectBase)object5).getSQL());
                        stringBuffer.append('(');
                        for (int i = 0; i < columnArray.length; ++i) {
                            if (i > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(Parser.quoteIdentifier(columnArray[i].getName()));
                        }
                        stringBuffer.append(") VALUES");
                        if (!this.simple) {
                            stringBuffer.append('\n');
                        }
                        stringBuffer.append('(');
                        String string = stringBuffer.toString();
                        stringBuffer = null;
                        while (object6.next()) {
                            Row row = object6.get();
                            if (stringBuffer == null) {
                                stringBuffer = new StringBuffer(string);
                            } else {
                                stringBuffer.append(",\n(");
                            }
                            for (int i = 0; i < row.getColumnCount(); ++i) {
                                Value value;
                                if (i > 0) {
                                    stringBuffer.append(", ");
                                }
                                if ((value = row.getValue(i)).getPrecision() > (long)this.lobBlockSize) {
                                    int n4;
                                    if (value.getType() == 16) {
                                        n4 = this.writeLobStream((ValueLob)value);
                                        stringBuffer.append("SYSTEM_COMBINE_CLOB(" + n4 + ")");
                                        continue;
                                    }
                                    if (value.getType() == 15) {
                                        n4 = this.writeLobStream((ValueLob)value);
                                        stringBuffer.append("SYSTEM_COMBINE_BLOB(" + n4 + ")");
                                        continue;
                                    }
                                    stringBuffer.append(value.getSQL());
                                    continue;
                                }
                                stringBuffer.append(value.getSQL());
                            }
                            stringBuffer.append(")");
                            if (!this.simple && stringBuffer.length() <= 4096) continue;
                            this.add(stringBuffer.toString(), true);
                            stringBuffer = null;
                        }
                        if (stringBuffer != null) {
                            this.add(stringBuffer.toString(), true);
                        }
                    }
                }
                object2 = ((Table)object5).getIndexes();
                for (int i = 0; object2 != null && i < ((ObjectArray)object2).size(); ++i) {
                    object6 = (Index)((ObjectArray)object2).get(i);
                    if (object6.getIndexType().getBelongsToConstraint()) continue;
                    this.add(object6.getCreateSQL(), false);
                }
            }
            if (this.tempLobTableCreated) {
                this.add("DROP TABLE IF EXISTS SYSTEM_LOB_STREAM", true);
                this.add("CALL SYSTEM_COMBINE_BLOB(-1)", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_CLOB", true);
                this.add("DROP ALIAS IF EXISTS SYSTEM_COMBINE_BLOB", true);
                this.tempLobTableCreated = false;
            }
            ObjectArray objectArray10 = ((Database)object).getAllSchemaObjects(5);
            objectArray10.sort(new Comparator(){

                public int compare(Object object, Object object2) {
                    Constraint constraint = (Constraint)object;
                    Constraint constraint2 = (Constraint)object2;
                    return constraint.compareTo(constraint2);
                }
            });
            for (int i = 0; i < objectArray10.size(); ++i) {
                object4 = (Constraint)objectArray10.get(i);
                this.add(((Constraint)object4).getCreateSQLWithoutIndexes(), false);
            }
            ObjectArray objectArray11 = ((Database)object).getAllSchemaObjects(4);
            for (int i = 0; i < objectArray11.size(); ++i) {
                object3 = (TriggerObject)objectArray11.get(i);
                this.add(((TriggerObject)object3).getCreateSQL(), false);
            }
            ObjectArray objectArray12 = ((Database)object).getAllRights();
            for (int i = 0; i < objectArray12.size(); ++i) {
                object2 = (Right)objectArray12.get(i);
                this.add(((Right)object2).getCreateSQL(), false);
            }
            ObjectArray objectArray13 = ((Database)object).getAllComments();
            for (int i = 0; i < objectArray13.size(); ++i) {
                Comment comment = (Comment)objectArray13.get(i);
                this.add(comment.getCreateSQL(), false);
            }
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.getFileName());
        }
        finally {
            this.closeIO();
        }
        this.result.done();
        object = this.result;
        this.reset();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeLobStream(ValueLob valueLob) throws IOException, SQLException {
        if (!this.tempLobTableCreated) {
            this.add("CREATE TABLE IF NOT EXISTS SYSTEM_LOB_STREAM(ID INT, PART INT, CDATA VARCHAR, BDATA BINARY, PRIMARY KEY(ID, PART))", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_CLOB FOR \"" + this.getClass().getName() + ".combineClob\"", true);
            this.add("CREATE ALIAS IF NOT EXISTS SYSTEM_COMBINE_BLOB FOR \"" + this.getClass().getName() + ".combineBlob\"", true);
            this.tempLobTableCreated = true;
        }
        int n = this.nextLobId++;
        block2 : switch (valueLob.getType()) {
            case 15: {
                byte[] byArray = new byte[this.lobBlockSize];
                InputStream inputStream = valueLob.getInputStream();
                try {
                    int n2 = 0;
                    while (true) {
                        StringBuffer stringBuffer = new StringBuffer(this.lobBlockSize * 2);
                        stringBuffer.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n2 + ", NULL, '");
                        int n3 = IOUtils.readFully(inputStream, byArray, 0, this.lobBlockSize);
                        if (n3 <= 0) {
                            break block2;
                        }
                        stringBuffer.append(ByteUtils.convertBytesToString(byArray, n3));
                        stringBuffer.append("')");
                        String string = stringBuffer.toString();
                        this.add(string, true);
                        ++n2;
                    }
                }
                finally {
                    IOUtils.closeSilently(inputStream);
                }
            }
            case 16: {
                char[] cArray = new char[this.lobBlockSize];
                Reader reader = valueLob.getReader();
                try {
                    int n4 = 0;
                    while (true) {
                        StringBuffer stringBuffer = new StringBuffer(this.lobBlockSize * 2);
                        stringBuffer.append("INSERT INTO SYSTEM_LOB_STREAM VALUES(" + n + ", " + n4 + ", ");
                        int n5 = IOUtils.readFully(reader, cArray, this.lobBlockSize);
                        if (n5 < 0) {
                            break block2;
                        }
                        stringBuffer.append(StringUtils.quoteStringSQL(new String(cArray, 0, n5)));
                        stringBuffer.append(", NULL)");
                        String string = stringBuffer.toString();
                        this.add(string, true);
                        ++n4;
                    }
                }
                finally {
                    IOUtils.closeSilently(reader);
                }
            }
            default: {
                throw Message.getInternalError("type:" + valueLob.getType());
            }
        }
        return n;
    }

    public static InputStream combineBlob(Connection connection, int n) throws SQLException, IOException {
        if (n < 0) {
            FileUtils.delete(TEMP_LOB_FILENAME);
            return null;
        }
        ResultSet resultSet = ScriptCommand.getLobStream(connection, "BDATA", n);
        OutputStream outputStream = FileUtils.openFileOutputStream(TEMP_LOB_FILENAME, false);
        while (resultSet.next()) {
            InputStream inputStream = resultSet.getBinaryStream(1);
            IOUtils.copyAndCloseInput(inputStream, outputStream);
        }
        outputStream.close();
        ScriptCommand.deleteLobStream(connection, n);
        return ScriptCommand.openAutoCloseInput();
    }

    public static Reader combineClob(Connection connection, int n) throws SQLException, IOException {
        ResultSet resultSet = ScriptCommand.getLobStream(connection, "CDATA", n);
        Writer writer = IOUtils.getWriter(FileUtils.openFileOutputStream(TEMP_LOB_FILENAME, false));
        while (resultSet.next()) {
            BufferedReader bufferedReader = new BufferedReader(resultSet.getCharacterStream(1));
            IOUtils.copyAndCloseInput(bufferedReader, writer);
        }
        writer.close();
        ScriptCommand.deleteLobStream(connection, n);
        return IOUtils.getReader(ScriptCommand.openAutoCloseInput());
    }

    private static ResultSet getLobStream(Connection connection, String string, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT " + string + " FROM SYSTEM_LOB_STREAM WHERE ID=? ORDER BY PART");
        preparedStatement.setInt(1, n);
        return preparedStatement.executeQuery();
    }

    private static void deleteLobStream(Connection connection, int n) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM SYSTEM_LOB_STREAM WHERE ID=?");
        preparedStatement.setInt(1, n);
        preparedStatement.execute();
    }

    private static InputStream openAutoCloseInput() throws IOException {
        InputStream inputStream = FileUtils.openFileInputStream(TEMP_LOB_FILENAME);
        inputStream = new BufferedInputStream(inputStream);
        return new AutoCloseInputStream(inputStream);
    }

    private void reset() throws SQLException {
        this.result = null;
        this.buffer = null;
        this.lineSeparator = StringUtils.utf8Encode(SysProperties.LINE_SEPARATOR);
    }

    private void add(String string, boolean bl) throws SQLException, IOException {
        if (string == null) {
            return;
        }
        string = string + ";";
        if (this.out != null) {
            int n;
            byte[] byArray = StringUtils.utf8Encode(string);
            int n2 = MathUtils.roundUp(byArray.length + this.lineSeparator.length, 16);
            this.buffer = ByteUtils.copy(byArray, this.buffer);
            if (n2 > this.buffer.length) {
                this.buffer = new byte[n2];
            }
            System.arraycopy(byArray, 0, this.buffer, 0, byArray.length);
            for (n = byArray.length; n < n2 - this.lineSeparator.length; ++n) {
                this.buffer[n] = 32;
            }
            n = 0;
            int n3 = n2 - this.lineSeparator.length;
            while (n3 < n2) {
                this.buffer[n3] = this.lineSeparator[n];
                ++n3;
                ++n;
            }
            this.out.write(this.buffer, 0, n2);
            if (!bl) {
                Value[] valueArray = new Value[]{ValueString.get(string)};
                this.result.addRow(valueArray);
            }
        } else {
            Value[] valueArray = new Value[]{ValueString.get(string)};
            this.result.addRow(valueArray);
        }
    }

    public void setSimple(boolean bl) {
        this.simple = bl;
    }
}

