/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.wizards.AddDomainLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationPanel;
import org.netbeans.modules.glassfish.common.wizards.Retriever;
import org.netbeans.modules.glassfish.spi.RegisteredDerbyServer;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public class ServerWizardIterator
implements WizardDescriptor.InstantiatingIterator,
ChangeListener {
    private transient AddServerLocationPanel locationPanel = null;
    private transient AddDomainLocationPanel locationPanel2 = null;
    private WizardDescriptor wizard;
    private transient int index = 0;
    private transient WizardDescriptor.Panel[] panels = null;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private String domainsDir;
    private String domainName;
    private GlassfishInstanceProvider gip;
    private transient String[] steps = null;
    private int httpPort = -1;
    private int httpsPort = 8181;
    private int adminPort = 4848;
    private String installRoot;
    private String glassfishRoot;
    private String hostName;

    public ServerWizardIterator(GlassfishInstanceProvider gip) {
        assert (null != gip);
        this.gip = gip;
        this.setHostName("localhost");
    }

    private ServerWizardIterator() {
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void uninitialize(WizardDescriptor wizard) {
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void previousPanel() {
        --this.index;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public String name() {
        return this.gip.getDisplayName() + " AddInstanceIterator";
    }

    public static void showInformation(final String msg, final String title) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)msg, 1);
                d.setTitle(title);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }

    public Set instantiate() throws IOException {
        File f;
        HashSet<ServerInstance> result = new HashSet<ServerInstance>();
        File ir = new File(this.installRoot);
        this.ensureExecutable(ir);
        if (null != this.domainsDir) {
            this.handleLocalDomains(result, ir);
        } else {
            this.handleRemoteDomains(result, ir);
        }
        RegisteredDerbyServer db = (RegisteredDerbyServer)Lookup.getDefault().lookup(RegisteredDerbyServer.class);
        if (null != db && (f = new File(ir, "javadb")).exists() && f.isDirectory() && f.canRead()) {
            db.initialize(f.getAbsolutePath());
        }
        NbPreferences.forModule(this.getClass()).put(this.gip.getInstallRootKey(), this.installRoot);
        return result;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_ServerLocation"), NbBundle.getMessage(ServerWizardIterator.class, (String)"STEP_Domain")};
    }

    protected final String[] getSteps() {
        if (this.steps == null) {
            this.steps = this.createSteps();
        }
        return this.steps;
    }

    protected final WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            this.panels = this.createPanels();
        }
        return this.panels;
    }

    protected WizardDescriptor.Panel[] createPanels() {
        if (this.locationPanel == null) {
            this.locationPanel = new AddServerLocationPanel(this);
            this.locationPanel.addChangeListener(this);
        }
        if (this.locationPanel2 == null) {
            this.locationPanel2 = new AddDomainLocationPanel(this);
            this.locationPanel2.addChangeListener(this);
        }
        return new WizardDescriptor.Panel[]{this.locationPanel, this.locationPanel2};
    }

    protected final int getIndex() {
        return this.index;
    }

    public WizardDescriptor.Panel current() {
        WizardDescriptor.Panel result = this.getPanels()[this.index];
        JComponent component = (JComponent)result.getComponent();
        component.putClientProperty("WizardPanel_contentData", this.getSteps());
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.getIndex()));
        return result;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    protected final void fireChangeEvent() {
        ChangeEvent ev = new ChangeEvent(this);
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public String formatUri(String glassfishRoot, String host, int port) {
        return this.gip.formatUri(glassfishRoot, host, port);
    }

    String getDefaultInstallDirectoryName() {
        return this.gip.getDefaultInstallName();
    }

    int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    int getAdminPort() {
        return this.adminPort;
    }

    public void setAdminPort(int adminPort) {
        this.adminPort = adminPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void setInstallRoot(String installRoot) {
        this.installRoot = installRoot;
    }

    String getGlassfishRoot() {
        return this.glassfishRoot;
    }

    public void setGlassfishRoot(String glassfishRoot) {
        this.glassfishRoot = glassfishRoot;
    }

    String getInstallRootProperty() {
        return this.gip.getInstallRootProperty();
    }

    String getNameOfBits() {
        return this.gip.getDisplayName();
    }

    boolean hasServer(String uri) {
        return this.gip.hasServer(uri);
    }

    boolean isValidInstall(File installDir, File glassfishDir, WizardDescriptor wizard) {
        String errMsg = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallationInvalid", (Object)FileUtil.normalizeFile((File)installDir).getPath());
        if (this.gip.getDefaultInstallName().equals(GlassfishInstanceProvider.PRELUDE_DEFAULT_NAME)) {
            errMsg = NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_PreludeInstallationInvalid", (Object)FileUtil.normalizeFile((File)installDir).getPath());
        }
        wizard.putProperty("WizardPanel_errorMessage", (Object)errMsg);
        File jar = ServerUtilities.getJarName(glassfishDir.getAbsolutePath(), "glassfish(?:-[0-9]+(?:\\.[0-9]+(?:_[0-9]+|)|).*|).jar");
        if (jar == null || !jar.exists()) {
            return false;
        }
        File containerRef = new File(glassfishDir, "config" + File.separator + "glassfish.container");
        if (!containerRef.exists()) {
            return false;
        }
        for (String s : this.gip.getRequiredFiles()) {
            containerRef = new File(glassfishDir, s);
            if (containerRef.exists()) continue;
            return false;
        }
        for (String s : this.gip.getExcludedFiles()) {
            containerRef = new File(glassfishDir, s);
            if (!containerRef.exists()) continue;
            return false;
        }
        wizard.putProperty("WizardPanel_errorMessage", (Object)"   ");
        return true;
    }

    public void setDomainLocation(String absolutePath) {
        if (null == absolutePath) {
            this.domainsDir = null;
            this.domainName = null;
        } else {
            int dex = absolutePath.lastIndexOf(File.separator);
            this.domainsDir = absolutePath.substring(0, dex);
            this.domainName = absolutePath.substring(dex + 1);
        }
    }

    private void ensureExecutable(File installDir) {
        if (Utilities.isWindows()) {
            return;
        }
        if (!Utils.canWrite(installDir)) {
            return;
        }
        ArrayList<File> binList = new ArrayList<File>();
        for (String binPath : new String[]{"bin", "glassfish/bin", "javadb/bin", "javadb/frameworks/NetworkServer/bin", "javadb/frameworks/embedded/bin"}) {
            File dir = new File(installDir, binPath);
            if (!dir.exists()) continue;
            binList.add(dir);
        }
        if (binList.size() == 0) {
            return;
        }
        File chmod = new File("/bin/chmod");
        if (!chmod.isFile()) {
            chmod = new File("/usr/bin/chmod");
        }
        if (chmod.isFile()) {
            try {
                for (File binDir : binList) {
                    String[] files;
                    ArrayList<String> argv = new ArrayList<String>();
                    argv.add(chmod.getAbsolutePath());
                    argv.add("u+rx");
                    for (String file : files = binDir.list()) {
                        if (file.indexOf(46) != -1 && !file.endsWith(".ksh")) continue;
                        argv.add(file);
                    }
                    ProcessBuilder pb = new ProcessBuilder(argv);
                    pb.directory(binDir);
                    Process process = pb.start();
                    int chmoded = process.waitFor();
                    if (chmoded == 0) continue;
                    throw new IOException(NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodFailed", argv, (Object)chmoded));
                }
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        } else {
            String message = NbBundle.getMessage(Retriever.class, (String)"ERR_ChmodNotFound");
            StringBuilder builder = new StringBuilder(message.length() + 50 * binList.size());
            builder.append(message);
            for (File binDir : binList) {
                builder.append('\n');
                builder.append(binDir);
            }
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)builder.toString(), 2));
        }
    }

    String getIndirect() {
        return this.gip.getIndirectDownloadUrl();
    }

    String getDirect() {
        return this.gip.getDirectDownloadUrl();
    }

    String getInstallRootKey() {
        return this.gip.getInstallRootKey();
    }

    private void handleLocalDomains(Set<ServerInstance> result, File ir) {
        File domainDir = new File(this.domainsDir, this.domainName);
        String canonicalPath = null;
        try {
            canonicalPath = domainDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            Logger.getLogger("glassfish").log(Level.INFO, domainDir.getAbsolutePath(), ioe);
        }
        if (null != canonicalPath && !canonicalPath.equals(domainDir.getAbsolutePath())) {
            this.setDomainLocation(canonicalPath);
            domainDir = new File(this.domainsDir, this.domainName);
        }
        if (!domainDir.exists() && AddServerLocationPanel.canCreate(domainDir)) {
            HashMap<String, String> ip = new HashMap<String, String>();
            ip.put("installfolder", this.installRoot);
            ip.put("homefolder", this.glassfishRoot);
            ip.put("displayName", (String)this.wizard.getProperty("ServInstWizard_displayName"));
            ip.put("domainsfolder", this.domainsDir);
            ip.put("domainname", this.domainName);
            CreateDomain cd = new CreateDomain("anonymous", "", new File(this.glassfishRoot), ip, this.gip, false);
            int newHttpPort = cd.getHttpPort();
            int newAdminPort = cd.getAdminPort();
            cd.start();
            GlassfishInstance instance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, this.domainsDir, this.domainName, newHttpPort, newAdminPort, this.formatUri(this.glassfishRoot, "localhost", newAdminPort), this.gip.getUriFragment(), this.gip);
            result.add(instance.getCommonInstance());
        } else {
            GlassfishInstance instance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, this.domainsDir, this.domainName, this.httpPort, this.adminPort, this.formatUri(this.glassfishRoot, "localhost", this.adminPort), this.gip.getUriFragment(), this.gip);
            result.add(instance.getCommonInstance());
        }
    }

    private void handleRemoteDomains(Set<ServerInstance> result, File ir) {
        this.httpPort = 8080;
        String hn = this.getHostName();
        if ("localhost".equals(hn)) {
            hn = "127.0.0.1";
        }
        GlassfishInstance instance = GlassfishInstance.create((String)this.wizard.getProperty("ServInstWizard_displayName"), this.installRoot, this.glassfishRoot, null, null, this.httpPort, this.adminPort, this.formatUri(this.glassfishRoot, hn, this.adminPort), this.gip.getUriFragment(), this.gip);
        result.add(instance.getCommonInstance());
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }
}

