/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.lib.lexer.token.TokenLength;

public class DefaultToken<T extends TokenId>
extends AbstractToken<T>
implements CharSequence {
    private static final int INPUT_SOURCE_SUBSEQUENCE_THRESHOLD = 30;
    CharSequence tokenLengthOrCachedText;

    public DefaultToken(T id, int length) {
        super(id);
        assert (length > 0) : "Token length=" + length + " <= 0";
        this.tokenLengthOrCachedText = TokenLength.get(length);
    }

    public DefaultToken(T id) {
        super(id);
        this.tokenLengthOrCachedText = TokenLength.get(0);
    }

    @Override
    public int length() {
        return this.tokenLengthOrCachedText.length();
    }

    @Override
    protected String dumpInfoTokenType() {
        return "DefT";
    }

    @Override
    public synchronized CharSequence text() {
        CharSequence text;
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                int len = this.tokenLengthOrCachedText.length();
                if (len >= 30) {
                    CharSequence inputSourceText = this.tokenList.inputSourceText();
                    int tokenOffset = this.tokenList.tokenOffset(this);
                    text = new InputSourceSubsequence(this, inputSourceText, tokenOffset, tokenOffset + len, tokenOffset, tokenOffset + len);
                } else {
                    text = this;
                }
            } else {
                text = null;
            }
        } else {
            text = this.tokenLengthOrCachedText;
        }
        return text;
    }

    @Override
    public final char charAt(int index) {
        if (index < 0 || index >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length());
        }
        if (this.tokenList == null) {
            throw new IndexOutOfBoundsException("index=" + index + ", length=" + this.length() + " but tokenList==null for token " + this.dumpInfo(null, null, false, true, 0));
        }
        int tokenOffset = this.tokenList.tokenOffset(this);
        return this.tokenList.inputSourceText().charAt(tokenOffset + index);
    }

    @Override
    public final synchronized CharSequence subSequence(int start, int end) {
        CharSequence text;
        int textLength = this.tokenLengthOrCachedText.length();
        CharSequenceUtilities.checkIndexesValid((int)start, (int)end, (int)textLength);
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            CharSequence inputSourceText = this.tokenList.inputSourceText();
            int tokenOffset = this.tokenList.tokenOffset(this);
            text = new InputSourceSubsequence(this, inputSourceText, tokenOffset + start, tokenOffset + end, tokenOffset, tokenOffset + textLength);
        } else {
            text = this.tokenLengthOrCachedText.subSequence(start, end);
        }
        return text;
    }

    @Override
    public synchronized String toString() {
        String textStr;
        if (this.tokenLengthOrCachedText.getClass() == TokenLength.class) {
            if (!this.isRemoved()) {
                TokenLength tokenLength = (TokenLength)this.tokenLengthOrCachedText;
                CharSequence inputSourceText = this.tokenList.inputSourceText();
                int nextCacheFactor = tokenLength.nextCacheFactor();
                int threshold = inputSourceText.getClass() == String.class ? 300 : 900;
                int tokenOffset = this.tokenList.tokenOffset(this);
                textStr = ((Object)inputSourceText.subSequence(tokenOffset, tokenOffset + tokenLength.length())).toString();
                this.tokenLengthOrCachedText = nextCacheFactor < threshold ? tokenLength.next(nextCacheFactor) : textStr;
            } else {
                textStr = "<null>";
            }
        } else {
            textStr = ((Object)this.tokenLengthOrCachedText).toString();
        }
        return textStr;
    }

    private static final class InputSourceSubsequence
    implements CharSequence {
        private final DefaultToken token;
        private final CharSequence inputSourceText;
        private final int start;
        private final int end;
        private final int tokenStart;
        private final int tokenEnd;

        public InputSourceSubsequence(DefaultToken token, CharSequence text, int start, int end, int tokenStart, int tokenEnd) {
            this.token = token;
            this.inputSourceText = text;
            this.start = start;
            this.end = end;
            this.tokenStart = tokenStart;
            this.tokenEnd = tokenEnd;
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            CharSequenceUtilities.checkIndexValid((int)index, (int)this.length());
            return this.inputSourceText.charAt(this.start + index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            CharSequenceUtilities.checkIndexesValid((CharSequence)this, (int)start, (int)end);
            return new InputSourceSubsequence(this.token, this.inputSourceText, this.start + start, this.start + end, this.tokenStart, this.tokenEnd);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String toString() {
            DefaultToken defaultToken = this.token;
            synchronized (defaultToken) {
                String textStr;
                if (this.token.tokenLengthOrCachedText.getClass() == TokenLength.class) {
                    int threshold;
                    TokenLength tokenLength = (TokenLength)this.token.tokenLengthOrCachedText;
                    int nextCacheFactor = tokenLength.nextCacheFactor();
                    int n = threshold = this.inputSourceText.getClass() == String.class ? 300 : 900;
                    if (nextCacheFactor < threshold) {
                        textStr = ((Object)this.inputSourceText.subSequence(this.start, this.end)).toString();
                        this.token.tokenLengthOrCachedText = tokenLength.next(nextCacheFactor);
                    } else {
                        String tokenTextString = ((Object)this.inputSourceText.subSequence(this.tokenStart, this.tokenEnd)).toString();
                        this.token.tokenLengthOrCachedText = tokenTextString;
                        textStr = tokenTextString.substring(this.start - this.tokenStart, this.end - this.tokenStart);
                    }
                } else {
                    textStr = ((Object)this.token.tokenLengthOrCachedText.subSequence(this.start - this.tokenStart, this.end - this.tokenStart)).toString();
                }
                return textStr;
            }
        }
    }
}

