/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.analyzer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class QualIdent
implements Comparable<QualIdent> {
    private final List<String> parts;

    public QualIdent(String ... parts) {
        this.parts = Arrays.asList(parts);
    }

    public QualIdent(List<String> parts) {
        this.parts = new ArrayList<String>(parts);
    }

    public QualIdent(QualIdent prefix, String name) {
        this.parts = new ArrayList<String>(prefix.parts.size() + 1);
        this.parts.addAll(prefix.parts);
        this.parts.add(name);
    }

    public QualIdent(String prefix, QualIdent name) {
        this.parts = new ArrayList<String>(name.parts.size() + 1);
        this.parts.add(prefix);
        this.parts.addAll(name.parts);
    }

    private QualIdent(List<String> parts, int start, int end) {
        this.parts = parts.subList(start, end);
    }

    public String getFirstQualifier() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty.");
        }
        return this.parts.get(0);
    }

    public String getSecondQualifier() {
        if (this.parts.size() < 2) {
            throw new IllegalArgumentException("The identifier is empty or simple.");
        }
        return this.parts.get(1);
    }

    public String getSimpleName() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty.");
        }
        return this.parts.get(this.parts.size() - 1);
    }

    public QualIdent getPrefix() {
        if (this.parts.size() == 0) {
            throw new IllegalArgumentException("The identifier is empty");
        }
        return new QualIdent(this.parts, 0, this.parts.size() - 1);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isSimple() {
        return this.size() == 1;
    }

    public boolean isSingleQualified() {
        return this.size() == 2;
    }

    public int size() {
        return this.parts.size();
    }

    public boolean isPrefixedBy(QualIdent prefix) {
        if (this.size() < prefix.size()) {
            return false;
        }
        for (int i = 0; i < prefix.size(); ++i) {
            if (this.parts.get(i).equals(prefix.parts.get(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(QualIdent that) {
        int i = 0;
        while (true) {
            if (i < this.parts.size()) {
                if (i >= that.parts.size()) return 1;
                int compare = this.parts.get(i).compareToIgnoreCase(that.parts.get(i));
                if (compare != 0) {
                    return compare;
                }
            } else {
                if (i >= that.parts.size()) return 0;
                return -1;
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QualIdent)) {
            return false;
        }
        QualIdent that = (QualIdent)obj;
        return ((Object)that.parts).equals(this.parts);
    }

    public int hashCode() {
        return ((Object)this.parts).hashCode();
    }

    public String toString() {
        if (this.parts.size() == 0) {
            return "<empty>";
        }
        StringBuilder result = new StringBuilder(this.parts.size() * 10);
        Iterator<String> i = this.parts.iterator();
        while (i.hasNext()) {
            result.append(i.next());
            if (!i.hasNext()) continue;
            result.append('.');
        }
        return result.toString();
    }
}

