/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.jsp.lexer.JspTokenId;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.web.core.syntax.spi.ErrorAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class JspParserErrorAnnotation
extends ErrorAnnotation.LineSetAnnotation {
    private Line docline;
    private final int line;
    private final int column;
    private final String error;
    private NbEditorDocument document;

    public JspParserErrorAnnotation(int line, int column, String error, NbEditorDocument document) {
        this.line = line;
        this.column = column;
        this.error = error;
        this.document = document;
    }

    public String getShortDescription() {
        return this.error;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getError() {
        return this.error;
    }

    public String getAnnotationType() {
        return "org-netbeans-modules-web-core-syntax-JspParserErrorAnnotation";
    }

    @Override
    public void attachToLineSet(Line.Set lines) {
        try {
            this.docline = lines.getCurrent(this.line - 1);
        }
        catch (IndexOutOfBoundsException ex) {
            return;
        }
        String annTxt = this.docline.getText();
        if (annTxt == null) {
            return;
        }
        int offset = NbDocument.findLineOffset((StyledDocument)this.document, (int)this.docline.getLineNumber()) + this.column + 1;
        int start = 0;
        char[] string = annTxt.toCharArray();
        int end = string.length - 1;
        if (offset < 1) {
            this.textOnLine(this.docline);
            return;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        tokenSequence.move(offset - 1);
        if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
            this.textOnLine(this.docline);
            return;
        }
        start = NbDocument.findLineColumn((StyledDocument)this.document, (int)tokenSequence.token().offset(tokenHierarchy));
        offset = tokenSequence.token().offset(tokenHierarchy);
        if (tokenSequence.token().id() != JspTokenId.EL) {
            while ((tokenSequence.token().id() != JspTokenId.SYMBOL || ((Object)tokenSequence.token().text()).toString().charAt(0) != '<') && tokenSequence.token().id() != JspTokenId.TAG && tokenSequence.movePrevious()) {
                start = NbDocument.findLineColumn((StyledDocument)this.document, (int)tokenSequence.token().offset(tokenHierarchy));
                offset = tokenSequence.token().offset(tokenHierarchy);
            }
            while ((tokenSequence.token().id() != JspTokenId.SYMBOL || ((Object)tokenSequence.token().text()).toString().trim().length() > 0 && ((Object)tokenSequence.token().text()).toString().charAt(((Object)tokenSequence.token().text()).toString().trim().length() - 1) != '>') && tokenSequence.moveNext()) {
            }
        }
        end = tokenSequence.token().offset(tokenHierarchy) + tokenSequence.token().length() - offset;
        Line.Part part = this.docline.createPart(start, end);
        this.attach((Annotatable)part);
    }

    private void textOnLine(Line docline) {
        int start;
        char[] string = docline.getText().toCharArray();
        int end = string.length - 1;
        for (start = 0; start <= end && string[start] <= ' '; ++start) {
        }
        while (start <= end && string[end] <= ' ') {
            --end;
        }
        Line.Part part = start <= end ? docline.createPart(start, end - start + 1) : docline.createPart(0, string.length);
        this.attach((Annotatable)part);
    }

    public boolean equals(Object obj) {
        if (obj instanceof JspParserErrorAnnotation) {
            JspParserErrorAnnotation ann = (JspParserErrorAnnotation)((Object)obj);
            if (this == obj) {
                return true;
            }
            if (this.line != ann.getLine()) {
                return false;
            }
            if (this.column != ann.getColumn()) {
                return false;
            }
            return this.error.equals(ann.getError());
        }
        return false;
    }
}

