/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.customizer.AppletProjectProperties;
import org.netbeans.modules.javacard.project.customizer.ClassicAppletProjectProperties;
import org.netbeans.modules.javacard.project.customizer.WebProjectProperties;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.CustomizerProvider;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JCCustomizerProvider
implements CustomizerProvider {
    private final JCProject project;
    private JCProjectProperties uiProperties;
    private final PropertyEvaluator evaluator;
    private final AntProjectHelper antHelper;
    private Reference<Dialog> dialog;

    public JCCustomizerProvider(JCProject project, PropertyEvaluator evaluator, GeneratedFilesHelper genFileHelper, AntProjectHelper antHelper) {
        this.project = project;
        this.evaluator = evaluator;
        this.antHelper = antHelper;
    }

    private Dialog getDialog() {
        return this.dialog == null ? null : this.dialog.get();
    }

    public void showCustomizer() {
        Dialog dlg = this.getDialog();
        if (dlg == null) {
            JCProject realProject = (JCProject)this.project.getLookup().lookup(JCProject.class);
            assert (realProject != null);
            ProjectKind kind = realProject.kind();
            assert (kind != null);
            this.uiProperties = JCCustomizerProvider.createProjectProperties(kind, realProject, this.evaluator, this.antHelper);
            Lookup context = Lookups.fixed((Object[])new Object[]{this.project, this.uiProperties});
            OptionsListener listener = new OptionsListener();
            dlg = ProjectCustomizer.createCustomizerDialog((String)this.project.kind().customizerPath(), (Lookup)context, null, (ActionListener)listener, (HelpCtx)new HelpCtx("org.netbeans.modules.javacard.JavaCard3ProjectPropertiesDialogBox"));
            dlg.addWindowListener(listener);
            this.dialog = new SoftReference<Dialog>(dlg);
        }
        dlg.setVisible(true);
    }

    public static JCProjectProperties createProjectProperties(ProjectKind kind, JCProject project, PropertyEvaluator evaluator, AntProjectHelper antHelper) {
        switch (kind) {
            case WEB: {
                return new WebProjectProperties(project, evaluator, antHelper);
            }
            case EXTENDED_APPLET: {
                return new AppletProjectProperties(project);
            }
            case CLASSIC_APPLET: 
            case CLASSIC_LIBRARY: {
                return new ClassicAppletProjectProperties(project);
            }
            case EXTENSION_LIBRARY: {
                return new JCProjectProperties(project);
            }
        }
        throw new AssertionError();
    }

    private class OptionsListener
    extends WindowAdapter
    implements ActionListener {
        private OptionsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCCustomizerProvider.this.uiProperties.storeProperties();
            Dialog dlg = JCCustomizerProvider.this.getDialog();
            if (dlg != null) {
                dlg.setVisible(false);
                dlg.dispose();
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            JCCustomizerProvider.this.dialog = null;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            Dialog dlg = JCCustomizerProvider.this.getDialog();
            if (dlg != null) {
                dlg.setVisible(false);
                dlg.dispose();
            }
        }
    }
}

