/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.ricoh.dalp;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.j2me.cdc.project.ricoh.dalp.DalpParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class DalpParser
implements ContentHandler {
    private StringBuffer buffer;
    private DalpParserHandler handler;
    private Stack context;
    private EntityResolver resolver;

    public DalpParser(DalpParserHandler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("jar".equals(qname)) {
            this.handler.handle_jar(attrs);
        } else if ("dsdk".equals(qname)) {
            this.handler.handle_dsdk(attrs);
        } else if ("install".equals(qname)) {
            this.handler.handle_install(attrs);
        } else if ("dalp".equals(qname)) {
            this.handler.start_dalp(attrs);
        } else if ("resources".equals(qname)) {
            this.handler.start_resources(attrs);
        } else if ("offline-allowed".equals(qname)) {
            this.handler.handle_offline_allowed(attrs);
        } else if ("application-desc".equals(qname)) {
            this.handler.handle_application_desc(attrs);
        } else if ("all-permissions".equals(qname)) {
            this.handler.handle_all_permissions(attrs);
        } else if ("information".equals(qname)) {
            this.handler.start_information(attrs);
        } else if ("security".equals(qname)) {
            this.handler.start_security(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("dalp".equals(qname)) {
            this.handler.end_dalp();
        } else if ("resources".equals(qname)) {
            this.handler.end_resources();
        } else if ("information".equals(qname)) {
            this.handler.end_information();
        } else if ("security".equals(qname)) {
            this.handler.end_security();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("application-ver".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_application_ver(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("vendor".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_vendor(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("encode-file".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_encode_file(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("title".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_title(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("telephone".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_telephone(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("fax".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_fax(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("e-mail".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_e_mail(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("product-id".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_product_id(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("icon".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_icon(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("description".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("argument".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_argument(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, DalpParserHandler handler) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(input, new DalpParser(handler, null));
    }

    public static void parse(URL url, DalpParserHandler handler) throws SAXException, ParserConfigurationException, IOException {
        DalpParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, DalpParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (DalpParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

