/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.freeform.Classpaths;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation,
AntProjectListener {
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private AuxiliaryConfiguration aux;
    private Map<URL, FileObject[]> roots = null;

    public SourceForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.evaluator = evaluator;
        this.aux = aux;
        helper.addAntProjectListener((AntProjectListener)this);
    }

    private void refresh() {
        this.roots = null;
    }

    public SourceForBinaryQuery.Result findSourceRoots(final URL binaryRoot) {
        return (SourceForBinaryQuery.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceForBinaryQuery.Result>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public SourceForBinaryQuery.Result run() {
                SourceForBinaryQueryImpl sourceForBinaryQueryImpl = SourceForBinaryQueryImpl.this;
                synchronized (sourceForBinaryQueryImpl) {
                    if (SourceForBinaryQueryImpl.this.roots == null) {
                        SourceForBinaryQueryImpl.this.roots = new HashMap();
                        Element java = SourceForBinaryQueryImpl.this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/3", true);
                        if (java == null) {
                            return null;
                        }
                        for (Element compilationUnit : XMLUtil.findSubElements((Element)java)) {
                            assert (compilationUnit.getLocalName().equals("compilation-unit")) : compilationUnit;
                            List binaries = SourceForBinaryQueryImpl.this.findBinaries(compilationUnit);
                            if (binaries.isEmpty()) continue;
                            List<FileObject> packageRoots = Classpaths.findPackageRoots(SourceForBinaryQueryImpl.this.helper, SourceForBinaryQueryImpl.this.evaluator, compilationUnit);
                            FileObject[] sources = packageRoots.toArray(new FileObject[packageRoots.size()]);
                            for (URL u : binaries) {
                                FileObject[] orig = (FileObject[])SourceForBinaryQueryImpl.this.roots.get(u);
                                if (orig != null) {
                                    FileObject[] merged = new FileObject[orig.length + sources.length];
                                    System.arraycopy(orig, 0, merged, 0, orig.length);
                                    System.arraycopy(sources, 0, merged, orig.length, sources.length);
                                    sources = merged;
                                }
                                SourceForBinaryQueryImpl.this.roots.put(u, sources);
                            }
                        }
                    }
                    assert (SourceForBinaryQueryImpl.this.roots != null);
                    FileObject[] sources = (FileObject[])SourceForBinaryQueryImpl.this.roots.get(binaryRoot);
                    Result result = sources == null ? null : new Result(sources);
                    return result;
                }
            }
        });
    }

    private List<URL> findBinaries(Element compilationUnitEl) {
        ArrayList<URL> binaries = new ArrayList<URL>();
        for (Element builtToEl : XMLUtil.findSubElements((Element)compilationUnitEl)) {
            String text;
            String textEval;
            if (!builtToEl.getLocalName().equals("built-to") || (textEval = this.evaluator.evaluate(text = XMLUtil.findText((Node)builtToEl))) == null) continue;
            File buildProduct = this.helper.resolveFile(textEval);
            URL buildProductURL = FileUtil.urlForArchiveOrDir((File)buildProduct);
            binaries.add(buildProductURL);
        }
        return binaries;
    }

    public void configurationXmlChanged(AntProjectEvent ev) {
        this.refresh();
    }

    public void propertiesChanged(AntProjectEvent ev) {
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject[] ret;

        public Result(FileObject[] ret) {
            this.ret = ret;
        }

        public FileObject[] getRoots() {
            return this.ret;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

