/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

public abstract class SingleThread
extends ThreadPoolExecutor
implements Runnable,
Cancellable {
    final Object sync = new Object();
    FutureTask task;

    public SingleThread() {
        super(1, 1, 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.setThreadFactory(SingleThread.getDaemonThreadFactory());
        this.setRejectedExecutionHandler(new ThreadPoolExecutor.DiscardPolicy(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                super.rejectedExecution(r, e);
                Logger.getLogger(this.getClass().getName()).info("rejectedExecution");
            }
        });
    }

    public static ThreadFactory getDaemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();
                Thread newThread = defaultThreadFactory.newThread(r);
                newThread.setDaemon(true);
                return newThread;
            }
        };
    }

    public Object getSync() {
        return this.sync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FutureTask invokeLater() {
        Object object = this.sync;
        synchronized (object) {
            this.task = new FutureTask<Object>(this, null);
            this.execute(this.task);
            return this.task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invokeAndWait() throws InterruptedException, ExecutionException {
        Object object = this.sync;
        synchronized (object) {
            this.task = new FutureTask<Object>(this, null);
            this.execute(this.task);
            this.task.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void waitFinished() {
        Object object = this.sync;
        synchronized (object) {
            if (this.task != null) {
                try {
                    this.task.get(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (TimeoutException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
    }

    public abstract boolean cancel();
}

