/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.io.IOException;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.completion.impl.xref.ReferenceImpl;
import org.netbeans.modules.cnd.completion.impl.xref.ReferencesSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.UserQuestionException;

public class ReferenceResolverImpl
extends CsmReferenceResolver {
    public boolean isKindOf(CsmReference ref, Set<CsmReferenceKind> kinds) {
        return ((Object)kinds).equals(CsmReferenceKind.ALL) || kinds.contains(ref.getKind());
    }

    public CsmReference findReference(CsmFile file, int offset) {
        assert (file != null);
        BaseDocument doc = ReferencesSupport.getDocument(file);
        if (doc == null) {
            return null;
        }
        ReferenceImpl ref = ReferencesSupport.createReferenceImpl(file, doc, offset);
        return ref;
    }

    public CsmReference findReference(CsmFile file, int line, int column) {
        assert (file != null);
        BaseDocument doc = ReferencesSupport.getDocument(file);
        if (doc == null) {
            return null;
        }
        int offset = ReferencesSupport.getDocumentOffset(doc, line, column);
        ReferenceImpl ref = ReferencesSupport.createReferenceImpl(file, doc, offset);
        return ref;
    }

    public CsmReference findReference(Node activatedNode) {
        JEditorPane pane;
        assert (activatedNode != null) : "activatedNode must be not null";
        EditorCookie cookie = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (cookie != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)cookie)) != null) {
            int offset = pane.getSelectionStart();
            StyledDocument doc = null;
            try {
                try {
                    doc = cookie.openDocument();
                }
                catch (UserQuestionException ex) {
                    ex.confirmed();
                    doc = cookie.openDocument();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(System.err);
            }
            return this.findReferenceInDoc(doc, offset);
        }
        return null;
    }

    public CsmReference findReference(Document doc, int offset) {
        return this.findReferenceInDoc(doc, offset);
    }

    private CsmReference findReferenceInDoc(Document doc, int offset) {
        CsmFile file;
        if (doc instanceof BaseDocument && (file = CsmUtilities.getCsmFile((Document)doc, (boolean)false, (boolean)false)) != null) {
            return ReferencesSupport.createReferenceImpl(file, (BaseDocument)doc, offset);
        }
        return null;
    }

    public CsmReferenceResolver.Scope fastCheckScope(CsmReference ref) {
        return ReferencesSupport.fastCheckScope(ref);
    }
}

