/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.netbeans.modules.reglib.StatusData;
import org.netbeans.modules.reglib.Util;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class StatusDocument {
    private static final String STATUS_DATA_SCHEMA = "/org/netbeans/modules/reglib/resources/status.xsd";
    private static final String STATUS_DATA_VERSION = "1.0";
    static final String ST_NODE_REGISTRATION_STATUS = "registration_status";
    static final String ST_ATTR_REGISTRATION_STATUS_VERSION = "version";
    static final String ST_NODE_STATUS = "status";
    static final String ST_NODE_TIMESTAMP = "timestamp";
    static final String ST_NODE_DELAY = "delay";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.reglib.StatusDocument");

    StatusDocument() {
    }

    static StatusData load(InputStream in) throws IOException {
        Document doc = StatusDocument.initializeDocument(in);
        Element root = doc.getDocumentElement();
        if (!root.getNodeName().equals(ST_NODE_REGISTRATION_STATUS)) {
            throw new IllegalArgumentException("Not a registration_status node \"" + root.getNodeName() + "\"");
        }
        String val = StatusDocument.getTextValue(root, ST_NODE_STATUS);
        String stValue = "later".equals(val) ? "later" : ("never".equals(val) ? "never" : ("registered".equals(val) ? "registered" : "unknown"));
        int delay = 7;
        val = StatusDocument.getTextValue(root, ST_NODE_DELAY);
        try {
            delay = Integer.parseInt(val);
        }
        catch (NumberFormatException exc) {
            LOG.log(Level.INFO, "Error: Cannot parse delay value:" + val, exc);
        }
        StatusData sd = new StatusData(stValue, delay);
        Date tsValue = Util.parseTimestamp(StatusDocument.getTextValue(root, ST_NODE_TIMESTAMP));
        sd.setTimestamp(tsValue);
        return sd;
    }

    static void store(OutputStream os, StatusData status) throws IOException {
        Document document = StatusDocument.initializeDocument();
        StatusDocument.addStatusNode(document, status);
        StatusDocument.transform(document, os);
    }

    private static String getTextValue(Element e, String tagName) {
        Element el;
        Node node;
        String value = "";
        NodeList nl = e.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0 && (node = (el = (Element)nl.item(0)).getFirstChild()) != null) {
            value = node.getNodeValue();
        }
        return value;
    }

    private static void addStatusNode(Document document, StatusData status) {
        Element r = document.getDocumentElement();
        Element s = document.createElement(ST_NODE_STATUS);
        s.appendChild(document.createTextNode(status.getStatus()));
        r.appendChild(s);
        Element t = document.createElement(ST_NODE_TIMESTAMP);
        t.appendChild(document.createTextNode(Util.formatTimestamp(status.getTimestamp())));
        r.appendChild(t);
        t = document.createElement(ST_NODE_DELAY);
        t.appendChild(document.createTextNode(Integer.toString(status.getDelay())));
        r.appendChild(t);
    }

    private static Document initializeDocument(InputStream in) throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL xsdUrl = StatusDocument.class.getResource(STATUS_DATA_SCHEMA);
            Schema schema = sf.newSchema(xsdUrl);
            Validator validator = schema.newValidator();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(in));
            validator.validate(new DOMSource(doc));
            return doc;
        }
        catch (SAXException sxe) {
            IllegalArgumentException e = new IllegalArgumentException("Error generated in parsing");
            e.initCause(sxe);
            throw e;
        }
        catch (ParserConfigurationException pce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(pce);
            throw x;
        }
    }

    private static Document initializeDocument() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.newDocument();
            Element root = doc.createElement(ST_NODE_REGISTRATION_STATUS);
            doc.appendChild(root);
            root.setAttribute(ST_ATTR_REGISTRATION_STATUS_VERSION, STATUS_DATA_VERSION);
            return doc;
        }
        catch (ParserConfigurationException pce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(pce);
            throw x;
        }
    }

    private static void transform(Document document, OutputStream os) {
        try {
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                tFactory.setAttribute("indent-number", new Integer(3));
            }
            catch (IllegalArgumentException iae) {
                LOG.log(Level.INFO, "Warning: Attribute \"indent-number\" unsupported.", iae);
            }
            Transformer transformer = tFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("standalone", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(new BufferedWriter(new OutputStreamWriter(os, "UTF-8"))));
        }
        catch (UnsupportedEncodingException ue) {
            InternalError x = new InternalError("Error generated during transformation");
            x.initCause(ue);
            throw x;
        }
        catch (TransformerConfigurationException tce) {
            InternalError x = new InternalError("Error in creating the new document");
            x.initCause(tce);
            throw x;
        }
        catch (TransformerException te) {
            InternalError x = new InternalError("Error generated during transformation");
            x.initCause(te);
            throw x;
        }
    }
}

