/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import org.jdesktop.layout.Baseline;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.query.QueryLinksPanel;
import org.netbeans.modules.bugtracking.ui.query.ViewportWidthAwarePanel;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class QueriesPanel
extends ViewportWidthAwarePanel {
    private static final JLabel fakeLabel = new JLabel("fake");
    private final JLabel queriesLabel = new JLabel();
    private final QueryLinksPanel queryLinksPanel = new QueryLinksPanel();
    private int baseline;
    private boolean baselineValid;
    private int labelBaseline;
    private boolean labelBaselineValid;
    private int linksPanelOffset;
    private boolean linksPanelOffsetValid;
    private Dimension prefSize;
    private Insets cachedInsets;

    public QueriesPanel() {
        super(null);
        this.queriesLabel.setLabelFor(this.queryLinksPanel);
        Mnemonics.setLocalizedText((JLabel)this.queriesLabel, (String)NbBundle.getMessage(this.getClass(), (String)"QueryTopComponent.jLabel1.text_1"));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(this.queriesLabel);
        this.add(this.queryLinksPanel);
    }

    void setQueries(Query[] queries) {
        this.invalidatePrefSize();
        this.queryLinksPanel.setQueries(queries);
    }

    boolean hasQueries() {
        return !this.queryLinksPanel.isEmpty();
    }

    boolean isWrapped() {
        return this.queryLinksPanel.isWrapped();
    }

    @Override
    protected void visibleWidthChanged(int newWidth) {
        this.invalidatePrefSize();
        super.visibleWidthChanged(newWidth);
    }

    @Override
    protected void notifyChildrenOfVisibleWidth() {
        this.queryLinksPanel.setAvailableWidth(this.getAvailableWidth() - this.getLinksPanelOffset() - this.getCachedInsets().left - this.getCachedInsets().right);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Dimension labelPrefSize = this.queriesLabel.getPreferredSize();
            Dimension panelPrefSize = this.queryLinksPanel.getPreferredSize();
            int aboveBaseline = this.getBaseline();
            int belowBaseline1 = labelPrefSize.height - this.getLabelBaseline();
            int belowBaseline2 = panelPrefSize.height - this.queryLinksPanel.getBaseline();
            int belowBaseline = Math.max(belowBaseline1, belowBaseline2);
            int width = this.getLinksPanelOffset() + panelPrefSize.width;
            int height = aboveBaseline + belowBaseline;
            Insets insets = this.getCachedInsets();
            this.prefSize = new Dimension(width += insets.left + insets.right, height += insets.bottom);
        }
        return this.prefSize;
    }

    @Override
    public void invalidate() {
        this.invalidatePrefSize();
        super.invalidate();
    }

    @Override
    public void doLayout() {
        if (this.queryLinksPanel.isEmpty()) {
            Insets insets = this.getCachedInsets();
            Dimension tmpPrefSize = this.queriesLabel.getPreferredSize();
            this.queriesLabel.setBounds(insets.left, insets.top, tmpPrefSize.width, tmpPrefSize.height);
            return;
        }
        this.validateBaseline();
        Dimension tmpPrefSize = this.queriesLabel.getPreferredSize();
        this.queriesLabel.setBounds(this.getCachedInsets().left, this.baseline - this.getLabelBaseline(), tmpPrefSize.width, tmpPrefSize.height);
        tmpPrefSize = this.queryLinksPanel.getPreferredSize();
        this.queryLinksPanel.setBounds(this.getCachedInsets().left + this.getLinksPanelOffset(), this.baseline - this.queryLinksPanel.getBaseline(), tmpPrefSize.width, tmpPrefSize.height);
    }

    private int getLinksPanelOffset() {
        if (!this.linksPanelOffsetValid) {
            this.linksPanelOffset = this.queriesLabel.getPreferredSize().width + LayoutStyle.getSharedInstance().getPreferredGap((JComponent)this.queriesLabel, (JComponent)fakeLabel, 0, 3, (Container)this);
            this.linksPanelOffsetValid = true;
        }
        return this.linksPanelOffset;
    }

    private Insets getCachedInsets() {
        if (this.cachedInsets == null) {
            this.cachedInsets = super.getInsets();
        }
        return this.cachedInsets;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.getBaseline();
    }

    public int getBaseline() {
        this.validateBaseline();
        return this.baseline;
    }

    private void validateBaseline() {
        if (!this.baselineValid) {
            this.queryLinksPanel.validateVerticalMetrics();
            this.baseline = Math.max(this.getLabelBaseline(), this.queryLinksPanel.getBaseline()) + this.getCachedInsets().top;
            this.baselineValid = true;
        }
    }

    private int getLabelBaseline() {
        if (!this.labelBaselineValid) {
            this.labelBaseline = Baseline.getBaseline((JComponent)this.queriesLabel);
            this.labelBaselineValid = true;
        }
        return this.labelBaseline;
    }

    public int getBaselineResizeBehaviorInt() {
        return 1;
    }

    @Override
    public void setUI(PanelUI ui) {
        this.invalidateUiDependentValues();
        super.setUI(ui);
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        this.invalidateUiDependentValues();
        super.setUI(newUI);
    }

    private void invalidateUiDependentValues() {
        this.baselineValid = false;
        this.labelBaselineValid = false;
        this.linksPanelOffsetValid = false;
        this.cachedInsets = null;
        this.invalidatePrefSize();
    }

    private void invalidatePrefSize() {
        this.prefSize = null;
    }
}

