/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.inspector.InspectorBeanTreeView;
import org.netbeans.modules.vmd.inspector.InspectorFolderNode;
import org.netbeans.modules.vmd.inspector.InspectorFolderWrapper;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

final class InspectorUI
extends TopComponent
implements ExplorerManager.Provider,
PropertyChangeListener,
Presenter.Popup {
    static final String INSPECTOR_UI_ID = "InspectorUI";
    private transient ExplorerManager explorerManager = new ExplorerManager();
    private volatile transient boolean lockSelectionSetting = false;
    private transient BeanTreeView inspectorBeanTreeView;
    private transient WeakReference<DesignDocument> document;

    InspectorUI(DesignDocument document) {
        this.explorerManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.initComponents();
        this.lockSelectionSetting = false;
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)this.getActionMap()));
        this.document = new WeakReference<DesignDocument>(document);
    }

    private void initComponents() {
        this.inspectorBeanTreeView = new InspectorBeanTreeView(this.explorerManager);
        this.inspectorBeanTreeView.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.inspectorBeanTreeView, "Center");
        this.setBackground(Color.WHITE);
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public synchronized void propertyChange(PropertyChangeEvent evt) {
        if (!"selectedNodes".equals(evt.getPropertyName())) {
            return;
        }
        if (this.explorerManager.getSelectedNodes().length < 1) {
            return;
        }
        if (this.document == null || this.document.get() == null) {
            return;
        }
        final DesignDocument d = (DesignDocument)this.document.get();
        if (d.getTransactionManager().isAccess()) {
            return;
        }
        d.getTransactionManager().writeAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (InspectorUI.this.lockSelectionSetting) {
                    return;
                }
                try {
                    InspectorUI.this.lockSelectionSetting = true;
                    Node[] selectedNodes = InspectorUI.this.explorerManager.getSelectedNodes();
                    WeakSet selectedComponents = new WeakSet();
                    for (Node node : selectedNodes) {
                        DesignComponent component;
                        if (!(node instanceof InspectorFolderNode)) continue;
                        Long componentID = ((InspectorFolderNode)node).getComponentID();
                        DesignComponent designComponent = component = componentID == null ? null : d.getComponentByUID(componentID.longValue());
                        if (component == null) continue;
                        selectedComponents.add(component);
                    }
                    d.setSelectedComponents(InspectorUI.INSPECTOR_UI_ID, (Collection)selectedComponents);
                }
                finally {
                    InspectorUI.this.lockSelectionSetting = false;
                }
            }
        });
    }

    void expandNodes(Collection<InspectorFolderWrapper> foldersToUpdate) {
        if (foldersToUpdate == null) {
            return;
        }
        for (InspectorFolderWrapper wrapper : foldersToUpdate) {
            InspectorFolderNode node = wrapper.getNode();
            if (node == null) continue;
            this.inspectorBeanTreeView.expandNode((Node)node);
        }
    }

    synchronized void setRootNode(Node rootNode) {
        this.getExplorerManager().setRootContext(rootNode);
        this.revalidate();
        this.repaint();
    }

    public Action[] getActions() {
        return new Action[0];
    }

    public JMenuItem getPopupPresenter() {
        return new JMenu("menu");
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentActivated() {
        super.componentActivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
    }
}

