/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.inspector;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.modules.vmd.api.inspector.InspectorFolder;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.inspector.FolderRegistry;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Mutex;

final class GlobalFolderRegistry {
    private static final String FILE_SYSTEM_FOLDER_NAME = "/inspectorfolders";
    private static final Map<String, WeakReference<GlobalFolderRegistry>> registries = new HashMap<String, WeakReference<GlobalFolderRegistry>>();
    private final DataFolder registryFolders;
    private final Mutex mutex = new Mutex();
    private HashMap<TypeID, InspectorFolder> descriptors = new HashMap();
    private FolderRegistry.Listener listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static GlobalFolderRegistry getGlobalFolderRegistry(String projectType) {
        assert (Debug.isFriend(FolderRegistry.class));
        Map<String, WeakReference<GlobalFolderRegistry>> map = registries;
        synchronized (map) {
            GlobalFolderRegistry registry;
            WeakReference<GlobalFolderRegistry> ref = registries.get(projectType);
            GlobalFolderRegistry globalFolderRegistry = registry = ref != null ? (GlobalFolderRegistry)ref.get() : null;
            if (registry == null) {
                registry = new GlobalFolderRegistry(projectType);
                registries.put(projectType, new WeakReference<GlobalFolderRegistry>(registry));
            }
            return registry;
        }
    }

    private GlobalFolderRegistry(String projectType) {
        assert (projectType != null && projectType.length() > 0);
        FileObject resource = FileUtil.getConfigFile((String)(projectType + FILE_SYSTEM_FOLDER_NAME));
        if (resource != null) {
            this.registryFolders = DataFolder.findFolder((FileObject)resource);
            this.registryFolders.getPrimaryFile().addFileChangeListener(new FileChangeListener(){

                public void fileFolderCreated(FileEvent fileEvent) {
                }

                public void fileDataCreated(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileChanged(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileDeleted(FileEvent fileEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileRenamed(FileRenameEvent fileRenameEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }

                public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                    GlobalFolderRegistry.this.reloadAll();
                }
            });
        } else {
            this.registryFolders = null;
        }
        this.reload();
    }

    private void reloadAll() {
        this.reload();
        this.listener.notifyRegistryContentChange();
    }

    void readAccess(Runnable runnable) {
        assert (Debug.isFriend(FolderRegistry.class));
        this.mutex.readAccess(runnable);
    }

    private void reload() {
        this.mutex.writeAccess(new Runnable(){

            @Override
            public void run() {
                GlobalFolderRegistry.this.reloadCore();
            }
        });
    }

    private void reloadCore() {
        HashMap<TypeID, InspectorFolder> tempDescriptors = new HashMap<TypeID, InspectorFolder>();
        if (this.registryFolders != null) {
            Enumeration enumeration = this.registryFolders.children();
            while (enumeration.hasMoreElements()) {
                DataObject dataObject = (DataObject)enumeration.nextElement();
                InspectorFolder descriptor = GlobalFolderRegistry.dao2descriptor(dataObject);
                if (descriptor == null) {
                    Debug.warning((Object[])new Object[]{"No descriptor", dataObject.getPrimaryFile().getNameExt()});
                    continue;
                }
                TypeID type = descriptor.getTypeID();
                if (type == null) {
                    Debug.warning((Object[])new Object[]{"Null type descriptor", descriptor});
                    continue;
                }
                TypeID thisType = descriptor.getTypeID();
                if (tempDescriptors.containsKey(thisType)) {
                    Debug.warning((Object[])new Object[]{"Duplicate descriptor", thisType});
                    continue;
                }
                tempDescriptors.put(thisType, descriptor);
            }
        }
        for (InspectorFolder descriptor : tempDescriptors.values()) {
            GlobalFolderRegistry.resolveDescriptor(descriptor);
        }
        this.descriptors = tempDescriptors;
    }

    private static void resolveDescriptor(InspectorFolder descriptor) {
        GlobalFolderRegistry.resolveDescriptor(new HashSet<TypeID>(), descriptor);
    }

    private static void resolveDescriptor(HashSet<TypeID> resolvingDescriptors, InspectorFolder descriptor) {
        assert (Debug.isFriend(GlobalFolderRegistry.class) || Debug.isFriend(FolderRegistry.class));
        TypeID thisType = descriptor.getTypeID();
        if (thisType == null) {
            Debug.warning((Object[])new Object[]{"Null Type", descriptor});
            return;
        }
        resolvingDescriptors.add(thisType);
    }

    private static InspectorFolder dao2descriptor(DataObject dataObject) {
        InstanceCookie.Of instanceCookie = (InstanceCookie.Of)dataObject.getCookie(InstanceCookie.Of.class);
        if (instanceCookie != null) {
            try {
                Object instance = instanceCookie.instanceCreate();
                if (instance instanceof InspectorFolder) {
                    return (InspectorFolder)instance;
                }
            }
            catch (IOException e) {
                Debug.warning((Object[])new Object[]{e});
            }
            catch (ClassNotFoundException e) {
                Debug.warning((Object[])new Object[]{e});
            }
            Debug.warning((Object[])new Object[]{"Instance is not InspectorFolder class"});
            return null;
        }
        return null;
    }

    Collection<InspectorFolder> getInspectorFolder() {
        assert (Debug.isFriend(FolderRegistry.class));
        return Collections.unmodifiableCollection(this.descriptors.values());
    }

    void addListener(FolderRegistry.Listener listener) {
        this.listener = listener;
    }

    void removeListener(FolderRegistry.Listener listener) {
        if (this.listener != listener) {
            Debug.warning((Object[])new Object[]{"Listener to remove != registred listener"});
        }
        listener = null;
    }
}

