/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.callhierarchy;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.callhierarchy.Call;
import org.netbeans.modules.refactoring.java.callhierarchy.CallHierarchyTasks;
import org.openide.util.Lookup;

final class CallHierarchyModel {
    public static final String PROP_ROOT = "root";
    private Call root;
    private HierarchyType type = HierarchyType.CALLER;
    private Set<Scope> scopes = EnumSet.of(Scope.ALL, Scope.TESTS);
    private PropertyChangeSupport support = new PropertyChangeSupport(this);

    private CallHierarchyModel(Call call, HierarchyType hierarchyType, Set<Scope> set) {
        this.root = call;
        call.model = this;
        if (hierarchyType != null) {
            this.type = hierarchyType;
        }
        if (set != null) {
            this.scopes = set;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public Call getRoot() {
        return this.root;
    }

    public synchronized Set<Scope> getScopes() {
        return this.scopes;
    }

    public synchronized void setScopes(Set<Scope> set) {
        this.scopes = set;
    }

    public synchronized HierarchyType getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setType(HierarchyType hierarchyType) {
        CallHierarchyModel callHierarchyModel = this;
        synchronized (callHierarchyModel) {
            this.type = hierarchyType;
        }
        this.replaceRoot();
    }

    public void computeCalls(Call call, Runnable runnable) {
        if (this.type == HierarchyType.CALLER) {
            CallHierarchyTasks.findCallers(call, this.scopes.contains((Object)Scope.TESTS), this.scopes.contains((Object)Scope.ALL), runnable);
        } else {
            CallHierarchyTasks.findCallees(call, runnable);
        }
    }

    void replaceRoot() {
        if (this.root == null) {
            return;
        }
        Call call = this.root;
        this.root = CallHierarchyTasks.resolveRoot(this.root.selection, this.type == HierarchyType.CALLER);
        if (this.root != null) {
            this.root.model = this;
        }
        this.support.firePropertyChange(PROP_ROOT, call, this.root);
    }

    static CallHierarchyModel create(Lookup lookup, Set<Scope> set, HierarchyType hierarchyType) {
        boolean bl = hierarchyType == null || hierarchyType == HierarchyType.CALLER;
        Call call = CallHierarchyTasks.resolveRoot(lookup, bl);
        if (call == null) {
            return null;
        }
        return new CallHierarchyModel(call, hierarchyType, set);
    }

    static CallHierarchyModel create(TreePathHandle treePathHandle, Set<Scope> set, HierarchyType hierarchyType) {
        boolean bl = hierarchyType == null || hierarchyType == HierarchyType.CALLER;
        Call call = CallHierarchyTasks.resolveRoot(treePathHandle, bl);
        if (call == null) {
            return null;
        }
        return new CallHierarchyModel(call, hierarchyType, set);
    }

    static enum Scope {
        ALL,
        PROJECT,
        TESTS;

    }

    static enum HierarchyType {
        CALLER,
        CALLEE;

    }
}

