/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.Util;
import org.netbeans.modules.ant.freeform.spi.ProjectNature;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

public final class View
implements LogicalViewProvider {
    private final FreeformProject project;

    public View(FreeformProject project) {
        this.project = project;
    }

    public Node createLogicalView() {
        return new RootNode(this.project);
    }

    public Node findPath(Node root, Object target) {
        Node[] kids;
        for (Node kid : kids = root.getChildren().getNodes(true)) {
            FileObject targetFO;
            DataObject d;
            for (ProjectNature nature : Lookup.getDefault().lookupAll(ProjectNature.class)) {
                Node n = nature.findSourceFolderViewPath(this.project, kid, target);
                if (n == null) continue;
                return n;
            }
            if (!(target instanceof DataObject) && !(target instanceof FileObject) || (d = (DataObject)kid.getLookup().lookup(DataObject.class)) == null) continue;
            FileObject kidFO = d.getPrimaryFile();
            FileObject fileObject = targetFO = target instanceof DataObject ? ((DataObject)target).getPrimaryFile() : (FileObject)target;
            if (kidFO == targetFO) {
                return kid;
            }
            if (!FileUtil.isParentOf((FileObject)kidFO, (FileObject)targetFO)) continue;
            String relPath = FileUtil.getRelativePath((FileObject)kidFO, (FileObject)targetFO);
            ArrayList path = Collections.list(NbCollections.checkedEnumerationByFilter((Enumeration)new StringTokenizer(relPath, "/"), String.class, (boolean)true));
            path.set(path.size() - 1, targetFO.getName());
            try {
                return NodeOp.findPath((Node)kid, Collections.enumeration(path));
            }
            catch (NodeNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private static final class RootNode
    extends AbstractNode
    implements PropertyChangeListener {
        private final FreeformProject p;
        private final ProjectInformation info;
        private static final RequestProcessor RP = new RequestProcessor(RootNode.class);

        public RootNode(FreeformProject p) {
            super(NodeFactorySupport.createCompositeChildren((Project)p, (String)"Projects/org-netbeans-modules-ant-freeform/Nodes"), Lookups.singleton((Object)p));
            this.p = p;
            this.info = ProjectUtils.getInformation((Project)p);
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public String getShortDescription() {
            return NbBundle.getMessage(View.class, (String)"View.RootNode.shortDescription", (Object)FileUtil.getFileDisplayName((FileObject)this.p.getProjectDirectory()));
        }

        public Image getIcon(int type) {
            return ImageUtilities.icon2Image((Icon)this.info.getIcon());
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type);
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-ant-freeform");
        }

        public boolean canRename() {
            return true;
        }

        public boolean canDestroy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public void setName(String name) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.p, (String)name);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("freeform.node." + Util.getMergedHelpIDFragments(this.p));
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    RootNode.this.fireNameChange(null, null);
                    RootNode.this.fireDisplayNameChange(null, null);
                    RootNode.this.fireIconChange();
                    RootNode.this.fireOpenedIconChange();
                }
            });
        }
    }
}

