/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import org.netbeans.lib.profiler.instrumentation.JavaClassConstants;

public class ConstantPoolExtension
implements JavaClassConstants {
    protected byte[] addedCPContents;
    protected int nAddedEntries;

    protected ConstantPoolExtension(PackedCPFragment pcp, int baseCPCount, int secondaryBaseCPCount) {
        this.addedCPContents = pcp.getRelocatedCPBytes(baseCPCount, secondaryBaseCPCount);
        this.nAddedEntries = pcp.nEntries;
    }

    protected ConstantPoolExtension() {
    }

    public byte[] getConcatenatedContents(ConstantPoolExtension other) {
        if (this.addedCPContents == null) {
            return other.getContents();
        }
        if (other.addedCPContents == null) {
            return this.getContents();
        }
        byte[] ret = new byte[this.addedCPContents.length + other.addedCPContents.length];
        System.arraycopy(this.addedCPContents, 0, ret, 0, this.addedCPContents.length);
        System.arraycopy(other.addedCPContents, 0, ret, this.addedCPContents.length, other.addedCPContents.length);
        return ret;
    }

    public byte[] getContents() {
        return this.addedCPContents;
    }

    public int getNEntries() {
        return this.nAddedEntries;
    }

    public static class PackedCPFragment {
        private static byte[] tmpBytes = new byte[64];
        int nEntries;
        private byte[] cpoolBytes;
        private char[] externalIndices;
        private char[] internalIndices;

        public PackedCPFragment(CPEntry[] entries) {
            this.nEntries = entries.length;
            int packedSize = 0;
            int nIntIdx = 0;
            int nExtIdx = 0;
            block10: for (int i = 0; i < this.nEntries; ++i) {
                switch (entries[i].tag) {
                    case 7: {
                        packedSize += 3;
                        if (entries[i].index1 <= 65535) {
                            ++nIntIdx;
                            continue block10;
                        }
                        ++nExtIdx;
                        continue block10;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        packedSize += 5;
                        if (entries[i].index1 <= 65535) {
                            ++nIntIdx;
                        } else {
                            ++nExtIdx;
                        }
                        if (entries[i].index2 <= 65535) {
                            ++nIntIdx;
                            continue block10;
                        }
                        ++nExtIdx;
                        continue block10;
                    }
                    case 1: {
                        packedSize += 3 + entries[i].utf8.length();
                        continue block10;
                    }
                    default: {
                        System.err.println("*** PackedAddedCPool : unsupported constant!");
                    }
                }
            }
            this.cpoolBytes = new byte[packedSize];
            this.internalIndices = new char[nIntIdx];
            this.externalIndices = new char[nExtIdx];
            int curPos = 0;
            nIntIdx = 0;
            nExtIdx = 0;
            block11: for (int i = 0; i < this.nEntries; ++i) {
                switch (entries[i].tag) {
                    case 7: {
                        this.cpoolBytes[curPos++] = entries[i].tag;
                        if (entries[i].index1 <= 65535) {
                            this.internalIndices[nIntIdx++] = (char)curPos;
                        } else {
                            this.externalIndices[nExtIdx++] = (char)curPos;
                        }
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index1 >> 8 & 0xFF);
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index1 & 0xFF);
                        continue block11;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        this.cpoolBytes[curPos++] = entries[i].tag;
                        if (entries[i].index1 <= 65535) {
                            this.internalIndices[nIntIdx++] = (char)curPos;
                        } else {
                            this.externalIndices[nExtIdx++] = (char)curPos;
                        }
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index1 >> 8 & 0xFF);
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index1 & 0xFF);
                        if (entries[i].index2 <= 65535) {
                            this.internalIndices[nIntIdx++] = (char)curPos;
                        } else {
                            this.externalIndices[nExtIdx++] = (char)curPos;
                        }
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index2 >> 8 & 0xFF);
                        this.cpoolBytes[curPos++] = (byte)(entries[i].index2 & 0xFF);
                        continue block11;
                    }
                    case 1: {
                        this.cpoolBytes[curPos++] = entries[i].tag;
                        String utf8 = entries[i].utf8;
                        int len = utf8.length();
                        this.cpoolBytes[curPos++] = (byte)(len >> 8 & 0xFF);
                        this.cpoolBytes[curPos++] = (byte)(len & 0xFF);
                        for (int j = 0; j < len; ++j) {
                            PackedCPFragment.tmpBytes[j] = (byte)utf8.charAt(j);
                        }
                        System.arraycopy(tmpBytes, 0, this.cpoolBytes, curPos, len);
                        curPos += len;
                        continue block11;
                    }
                    default: {
                        System.err.println("*** PackedAddedCPool : unsupported constant!");
                    }
                }
            }
        }

        public byte[] getRelocatedCPBytes(int intBaseIndex, int extBaseIndex) {
            int value;
            char pos;
            int i;
            byte[] ret = new byte[this.cpoolBytes.length];
            System.arraycopy(this.cpoolBytes, 0, ret, 0, this.cpoolBytes.length);
            for (i = 0; i < this.internalIndices.length; ++i) {
                pos = this.internalIndices[i];
                value = (ret[pos] << 8) + ret[pos + '\u0001'];
                ret[pos] = (byte)((value += intBaseIndex) >> 8 & 0xFF);
                ret[pos + '\u0001'] = (byte)(value & 0xFF);
            }
            for (i = 0; i < this.externalIndices.length; ++i) {
                pos = this.externalIndices[i];
                value = (ret[pos] << 8) + ret[pos + '\u0001'];
                ret[pos] = (byte)((value += extBaseIndex) >> 8 & 0xFF);
                ret[pos + '\u0001'] = (byte)(value & 0xFF);
            }
            return ret;
        }
    }

    public static class CPEntry {
        String utf8;
        byte tag;
        int index1;
        int index2;

        public CPEntry(int tag) {
            this.tag = (byte)tag;
        }

        public CPEntry(String utf8) {
            this.tag = 1;
            this.utf8 = utf8;
        }

        public void setIndex1(int idx) {
            this.index1 = idx;
        }

        public void setIndex2(int idx) {
            this.index2 = idx;
        }
    }
}

