/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.java;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.util.Exceptions;

public class ComputeOffAWT {
    public static <T> T computeOffAWT(Worker<T> worker, String string, JavaSource javaSource, JavaSource.Phase phase) {
        AtomicBoolean atomicBoolean = new AtomicBoolean();
        Compute<T> compute = new Compute<T>(atomicBoolean, javaSource, phase, worker);
        ProgressUtils.runOffEventDispatchThread(compute, (String)string, (AtomicBoolean)atomicBoolean, (boolean)false);
        return (T)((Compute)compute).result;
    }

    private ComputeOffAWT() {
    }

    public static interface Worker<T> {
        public T process(CompilationInfo var1);
    }

    private static final class Compute<T>
    implements Runnable,
    Task<CompilationController> {
        private final AtomicBoolean cancel;
        private final JavaSource source;
        private final JavaSource.Phase phase;
        private final Worker<T> worker;
        private T result;

        public Compute(AtomicBoolean atomicBoolean, JavaSource javaSource, JavaSource.Phase phase, Worker<T> worker) {
            this.cancel = atomicBoolean;
            this.source = javaSource;
            this.phase = phase;
            this.worker = worker;
        }

        @Override
        public void run() {
            try {
                this.source.runUserActionTask((Task)this, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
                this.result = null;
            }
        }

        public void run(CompilationController compilationController) throws Exception {
            if (this.cancel.get()) {
                return;
            }
            compilationController.toPhase(this.phase);
            if (this.cancel.get()) {
                return;
            }
            T t = this.worker.process((CompilationInfo)compilationController);
            if (this.cancel.get()) {
                return;
            }
            this.result = t;
        }
    }
}

