/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.diff;

import java.io.File;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.editor.errorstripe.privatespi.MarkProvider;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningConfig;
import org.netbeans.modules.versioning.diff.DiffSidebar;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.util.RequestProcessor;

public class DiffSidebarManager
implements PreferenceChangeListener {
    static final String SIDEBAR_ENABLED = "diff.sidebarEnabled";
    private static DiffSidebarManager instance;
    private boolean sidebarEnabled;
    private final Map<DiffSidebar, Object> sideBars = new WeakHashMap<DiffSidebar, Object>();

    public static synchronized DiffSidebarManager getInstance() {
        if (instance == null) {
            instance = new DiffSidebarManager();
        }
        return instance;
    }

    private DiffSidebarManager() {
        this.sidebarEnabled = VersioningConfig.getDefault().getPreferences().getBoolean(SIDEBAR_ENABLED, true);
        VersioningConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
    }

    public void refreshSidebars(Set<File> files) {
        HashSet<FileObject> fileObjects = null;
        if (files != null) {
            fileObjects = new HashSet<FileObject>(files.size());
            for (File file : files) {
                fileObjects.add(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file)));
            }
            fileObjects.remove(null);
        }
        final HashSet<FileObject> fileObjectsToRefresh = fileObjects;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = DiffSidebarManager.this.sideBars;
                synchronized (map) {
                    for (DiffSidebar bar : DiffSidebarManager.this.sideBars.keySet()) {
                        if (!DiffSidebarManager.this.matches(bar, fileObjectsToRefresh)) continue;
                        bar.refresh();
                    }
                }
            }
        });
    }

    private boolean matches(DiffSidebar sidebar, Set<FileObject> fileObjects) {
        if (fileObjects == null) {
            return true;
        }
        for (FileObject fileObject : fileObjects) {
            if (!fileObject.equals(sidebar.getFileObject())) continue;
            return true;
        }
        return false;
    }

    RequestProcessor.Task createDiffSidebarTask(Runnable runnable) {
        return Utils.createTask(runnable);
    }

    JComponent createSideBar(JTextComponent target) {
        return this.getSideBar(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DiffSidebar getSideBar(JTextComponent target) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            DiffSidebar sideBar = null;
            for (DiffSidebar bar : this.sideBars.keySet()) {
                if (bar.getTextComponent() != target) continue;
                sideBar = bar;
                break;
            }
            if (sideBar == null) {
                Document doc = target.getDocument();
                FileObject file = this.fileForDocument(doc);
                if (file == null || !file.isValid()) {
                    return null;
                }
                sideBar = new DiffSidebar(target, file);
                this.sideBars.put(sideBar, null);
                sideBar.setSidebarVisible(this.sidebarEnabled);
            }
            return sideBar;
        }
    }

    private FileObject fileForDocument(Document doc) {
        DataObject dobj = (DataObject)doc.getProperty("stream");
        if (dobj == null) {
            return null;
        }
        if (dobj instanceof MultiDataObject) {
            return this.fileForDataobject(doc, (MultiDataObject)dobj);
        }
        if (dobj != null) {
            return dobj.getPrimaryFile();
        }
        return null;
    }

    private FileObject fileForDataobject(Document doc, MultiDataObject dobj) {
        for (MultiDataObject.Entry entry : dobj.secondaryEntries()) {
            CookieSet.Factory factory;
            EditorCookie ec;
            StyledDocument entryDocument;
            if (!(entry instanceof CookieSet.Factory) || (entryDocument = (ec = (EditorCookie)(factory = (CookieSet.Factory)entry).createCookie(EditorCookie.class)).getDocument()) != doc) continue;
            return entry.getFile();
        }
        return dobj.getPrimaryFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSidebarEnabled(boolean enable) {
        Map<DiffSidebar, Object> map = this.sideBars;
        synchronized (map) {
            for (DiffSidebar sideBar : this.sideBars.keySet()) {
                sideBar.setSidebarVisible(enable);
            }
            this.sidebarEnabled = enable;
        }
    }

    MarkProvider createMarkProvider(JTextComponent target) {
        DiffSidebar sideBar = this.getSideBar(target);
        return sideBar != null ? sideBar.getMarkProvider() : null;
    }

    DiffSidebar t9y_getSidebar() {
        return this.sideBars.keySet().iterator().next();
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals(SIDEBAR_ENABLED)) {
            this.setSidebarEnabled(Boolean.valueOf(evt.getNewValue()));
        }
    }
}

