/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.CombinedPanel;
import org.netbeans.lib.profiler.ui.cpu.ReverseCallGraphPanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.ui.Utils;
import org.netbeans.modules.profiler.ui.stp.ProfilingSettingsManager;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public final class CPUSnapshotPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final String METHODS_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_MethodsString");
    private static final String CLASSES_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ClassesString");
    private static final String PACKAGES_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_PackagesString");
    private static final String CALLTREE_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CallTreeString");
    private static final String HOTSPOTS_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_HotSpotsString");
    private static final String COMBINED_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CombinedString");
    private static final String INFO_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_InfoString");
    private static final String CALLTREE_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CallTreeTabDescr");
    private static final String HOTSPOT_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_HotSpotTabDescr");
    private static final String COMBINED_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_CombinedTabDescr");
    private static final String INFO_TAB_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_InfoTabDescr");
    private static final String ALL_THREADS_ITEM = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AllThreadsItem");
    private static final String VIEW_LABEL_STRING = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ViewLabelString");
    private static final String TOGGLE_DOWN_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ToggleDownToolTip");
    private static final String TOGGLE_UP_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ToggleUpToolTip");
    private static final String PANEL_TITLE = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_PanelTitle");
    private static final String FIND_IN_STATEMENT = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_FindInStatement");
    private static final String AGGREGATION_COMBO_ACCESS_NAME = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AggregationComboAccessName");
    private static final String AGGREGATION_COMBO_ACCESS_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_AggregationComboAccessDescr");
    private static final String THREADS_COMBO_ACCESS_NAME = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ThreadsComboAccessName");
    private static final String THREADS_COMBO_ACCESS_DESCR = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_ThreadsComboAccessDescr");
    private static final String STRING_NOT_FOUND_MSG = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_StringNotFoundMsg");
    private static final String FIND_ACTION_TOOLTIP = NbBundle.getMessage(CPUSnapshotPanel.class, (String)"CPUSnapshotPanel_FindActionTooltip");
    private static final String FIND_IN_HOTSPOTS_STRING = MessageFormat.format(FIND_IN_STATEMENT, HOTSPOTS_STRING);
    private static final String FIND_IN_CALLTREE_STRING = MessageFormat.format(FIND_IN_STATEMENT, CALLTREE_STRING);
    private static final ImageIcon CLASSES_ICON = Utils.CLASS_ICON;
    private static final ImageIcon METHODS_ICON = Utils.METHODS_ICON;
    private static final ImageIcon PACKAGES_ICON = Utils.PACKAGE_ICON;
    private static final ImageIcon CALL_TREE_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/callTreeTab.png", (boolean)false);
    private static final ImageIcon HOTSPOTS_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/hotspotsTab.png", (boolean)false);
    private static final ImageIcon COMBINED_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/combinedTab.png", (boolean)false);
    private static final ImageIcon INFO_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/infoTab.png", (boolean)false);
    private static final ImageIcon BACK_TRACES_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/backTracesTab.png", (boolean)false);
    private static final ImageIcon SUBTREE_TAB_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/subtree.png", (boolean)false);
    private static final ImageIcon SLAVE_DOWN_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/slaveDown.png", (boolean)false);
    private static final ImageIcon SLAVE_UP_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/slaveUp.png", (boolean)false);
    private static final double SPLIT_HALF = 0.5;
    private CCTDisplay cctPanel;
    private CCTDisplay combinedCCT;
    private CPUResultsSnapshot snapshot;
    private CombinedPanel combined;
    private CombinedViewTracker combinedViewTracker;
    private JButton findActionPresenter;
    private JButton findNextPresenter;
    private JButton findPreviousPresenter;
    private JComboBox aggregationCombo;
    private JComboBox threadsCombo;
    private JTabbedPane tabs = new JTabbedPane(3);
    private JToggleButton slaveToggleButtonDown;
    private JToggleButton slaveToggleButtonUp;
    private LoadedSnapshot loadedSnapshot;
    private ReverseCallGraphPanel backtraceView;
    private SaveSnapshotAction saveAction;
    private SaveViewAction saveViewAction;
    private SnapshotFlatProfilePanel combinedFlat;
    private SnapshotFlatProfilePanel flatPanel;
    private SnapshotInfoPanel infoPanel;
    private SubtreeCallGraphPanel subtreeView;
    private int[] threadIds;
    private boolean internalChange = false;
    private boolean internalFilterChange = false;
    private boolean internalSelChange = false;
    private boolean slaveModeDown = true;
    private boolean slaveModeUp = true;
    private int currentAggregationMode;

    public CPUSnapshotPanel(LoadedSnapshot ls, int sortingColumn, boolean sortingOrder) {
        this.loadedSnapshot = ls;
        this.snapshot = (CPUResultsSnapshot)ls.getSnapshot();
        CPUActionsHandler actionsHandler = new CPUActionsHandler();
        CPUSnapshotSelectionHandler combinedActionsHandlerCCT = new CPUSnapshotSelectionHandler(true);
        CPUSnapshotSelectionHandler combinedActionsHandlerFlat = new CPUSnapshotSelectionHandler(false);
        this.setLayout(new BorderLayout());
        this.flatPanel = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)actionsHandler);
        this.cctPanel = new CCTDisplay((CPUResUserActionsHandler)actionsHandler);
        this.infoPanel = new SnapshotInfoPanel(ls);
        this.combinedFlat = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)actionsHandler, (CPUSelectionHandler)combinedActionsHandlerFlat);
        this.combinedCCT = new CCTDisplay((CPUResUserActionsHandler)actionsHandler, (CPUSelectionHandler)combinedActionsHandlerCCT);
        this.flatPanel.setSorting(sortingColumn, sortingOrder);
        this.cctPanel.setSorting(sortingColumn, sortingOrder);
        this.combinedFlat.setSorting(sortingColumn, sortingOrder);
        this.combinedCCT.setSorting(sortingColumn, sortingOrder);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(FIND_IN_HOTSPOTS_STRING);
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(FIND_IN_CALLTREE_STRING);
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        if (this.combinedFlat.getPopupFindItem() != null) {
            this.combinedFlat.getPopupFindItem().setText(FIND_IN_CALLTREE_STRING);
            this.combinedFlat.getPopupFindItem().setVisible(true);
        }
        if (this.combinedCCT.getPopupFindItem() != null) {
            this.combinedCCT.getPopupFindItem().setText(FIND_IN_HOTSPOTS_STRING);
            this.combinedCCT.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay(this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay(this.snapshot, 0);
        this.combinedFlat.setDataToDisplay(this.snapshot, -1, 0);
        this.combinedCCT.setDataToDisplay(this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.infoPanel.updateInfo();
        this.flatPanel.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.combinedFlat.setFilterValues(CPUSnapshotPanel.this.flatPanel.getFilterValue(), CPUSnapshotPanel.this.flatPanel.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combinedFlat.addFilterListener(new FilterComponent.FilterListener(){

            public void filterChanged() {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.flatPanel.setFilterValues(CPUSnapshotPanel.this.combinedFlat.getFilterValue(), CPUSnapshotPanel.this.combinedFlat.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combined = new CombinedPanel(0, (Component)this.combinedCCT, (Component)this.combinedFlat){

            public void requestFocus() {
                if (CPUSnapshotPanel.this.combinedCCT != null) {
                    CPUSnapshotPanel.this.combinedCCT.requestFocus();
                }
            }
        };
        this.combined.setResizeWeight(0.5);
        this.combined.setBorder(BorderFactory.createEmptyBorder());
        this.combined.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                CPUSnapshotPanel.this.combined.setDividerLocation(0.5);
            }
        });
        this.tabs.addTab(CALLTREE_STRING, CALL_TREE_TAB_ICON, (Component)this.cctPanel, CALLTREE_TAB_DESCR);
        this.tabs.addTab(HOTSPOTS_STRING, HOTSPOTS_TAB_ICON, (Component)this.flatPanel, HOTSPOT_TAB_DESCR);
        this.tabs.addTab(COMBINED_STRING, COMBINED_TAB_ICON, (Component)this.combined, COMBINED_TAB_DESCR);
        this.tabs.addTab(INFO_STRING, INFO_TAB_ICON, this.infoPanel, INFO_TAB_DESCR);
        this.add((Component)this.tabs, "Center");
        this.tabs.addChangeListener(this);
        JToolBar toolBar = new JToolBar(){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((AbstractButton)((JButton)comp));
                }
                return super.add(comp);
            }
        };
        toolBar.setFloatable(false);
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        toolBar.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        this.saveAction = new SaveSnapshotAction(this.loadedSnapshot);
        toolBar.add(this.saveAction);
        toolBar.add(new ExportAction(this, this.loadedSnapshot));
        this.saveViewAction = new SaveViewAction(this);
        toolBar.add(this.saveViewAction);
        toolBar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{METHODS_STRING, CLASSES_STRING, PACKAGES_STRING}){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(AGGREGATION_COMBO_ACCESS_NAME);
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(AGGREGATION_COMBO_ACCESS_DESCR);
        this.currentAggregationMode = 0;
        String[] tn = this.snapshot.getThreadNames();
        Object[] threadNames = new Object[tn.length + 1];
        threadNames[0] = new Object(){

            public String toString() {
                return ALL_THREADS_ITEM;
            }
        };
        for (int i = 0; i < tn.length; ++i) {
            final String tname = tn[i];
            threadNames[i + 1] = new Object(){

                public String toString() {
                    return tname;
                }
            };
        }
        this.threadIds = this.snapshot.getThreadIds();
        this.threadsCombo = new JComboBox(threadNames){

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = 1;
                return d;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension d = super.getPreferredSize();
                d.width += 50;
                return d;
            }
        };
        this.threadsCombo.getAccessibleContext().setAccessibleName(THREADS_COMBO_ACCESS_NAME);
        this.threadsCombo.getAccessibleContext().setAccessibleDescription(THREADS_COMBO_ACCESS_DESCR);
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DefaultListCellRenderer dlcr = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value == METHODS_STRING) {
                    dlcr.setIcon(METHODS_ICON);
                } else if (value == CLASSES_STRING) {
                    dlcr.setIcon(CLASSES_ICON);
                } else if (value == PACKAGES_STRING) {
                    dlcr.setIcon(PACKAGES_ICON);
                }
                return dlcr;
            }
        });
        JLabel lab = new JLabel(VIEW_LABEL_STRING);
        lab.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        lab.setLabelFor(this.aggregationCombo);
        int mnemCharIndex = 0;
        lab.setDisplayedMnemonic(lab.getText().charAt(mnemCharIndex));
        lab.setDisplayedMnemonicIndex(mnemCharIndex);
        toolBar.add(lab);
        toolBar.add(this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        toolBar.addSeparator(new Dimension(6, 0));
        this.slaveToggleButtonDown = new JToggleButton(SLAVE_DOWN_ICON);
        this.slaveToggleButtonDown.setSelected(this.slaveModeDown);
        this.slaveToggleButtonDown.addActionListener(this);
        this.slaveToggleButtonDown.setToolTipText(TOGGLE_DOWN_TOOLTIP);
        this.slaveToggleButtonDown.getAccessibleContext().setAccessibleName(TOGGLE_DOWN_TOOLTIP);
        toolBar.add(this.slaveToggleButtonDown);
        this.slaveToggleButtonUp = new JToggleButton(SLAVE_UP_ICON);
        this.slaveToggleButtonUp.setSelected(this.slaveModeUp);
        this.slaveToggleButtonUp.addActionListener(this);
        this.slaveToggleButtonUp.setToolTipText(TOGGLE_UP_TOOLTIP);
        this.slaveToggleButtonUp.getAccessibleContext().setAccessibleName(TOGGLE_UP_TOOLTIP);
        toolBar.add(this.slaveToggleButtonUp);
        toolBar.add(this.threadsCombo);
        this.threadsCombo.addActionListener(this);
        toolBar.addSeparator();
        this.findActionPresenter = toolBar.add((Action)SystemAction.get(FindAction.class));
        this.findPreviousPresenter = toolBar.add(new FindPreviousAction(this));
        this.findNextPresenter = toolBar.add(new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            JButton ab = this.findActionPresenter;
            ab.setIcon(Utils.FIND_ACTION_ICON);
            ab.setText("");
            ab.setToolTipText(FIND_ACTION_TOOLTIP);
        }
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        this.updateToolbar();
        this.add((Component)toolBar, "North");
        this.tabs.getActionMap().getParent().remove("navigatePageUp");
        this.tabs.getActionMap().getParent().remove("navigatePageDown");
        this.getActionMap().put("PreviousViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.moveToPreviousSubTab();
            }
        });
        this.getActionMap().put("NextViewAction", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.moveToNextSubTab();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CPUSnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, StringUtils.formatUserDate((Date)new Date(this.snapshot.getTimeTaken())));
    }

    @Override
    public BufferedImage getViewImage(boolean onlyVisibleArea) {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)this.tabs.getSelectedComponent()).getCurrentViewScreenshot(onlyVisibleArea);
    }

    @Override
    public String getViewName() {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return null;
        }
        String viewName = ((ScreenshotProvider)this.tabs.getSelectedComponent()).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + viewName;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.internalChange) {
            return;
        }
        Object src = e.getSource();
        if (src == this.aggregationCombo) {
            Object sel = this.aggregationCombo.getSelectedItem();
            if (sel == METHODS_STRING) {
                this.changeView(0);
            } else if (sel == CLASSES_STRING) {
                this.changeView(1);
            } else if (sel == PACKAGES_STRING) {
                this.changeView(2);
            }
        } else if (src == this.threadsCombo) {
            assert (this.tabs.getSelectedComponent() == this.flatPanel);
            int tid = -1;
            if (this.threadsCombo.getSelectedIndex() > 0) {
                tid = this.threadIds[this.threadsCombo.getSelectedIndex() - 1];
            }
            if (this.flatPanel.getCurrentThreadId() != tid) {
                this.flatPanel.setDataToDisplay(this.snapshot, tid, this.flatPanel.getCurrentView());
                this.flatPanel.prepareResults();
            }
        } else if (src == this.slaveToggleButtonDown) {
            this.slaveModeDown = this.slaveToggleButtonDown.isSelected();
        } else if (src == this.slaveToggleButtonUp) {
            this.slaveModeUp = this.slaveToggleButtonUp.isSelected();
        }
    }

    public void changeView(int view) {
        if (this.currentAggregationMode == view) {
            return;
        }
        this.currentAggregationMode = view;
        this.flatPanel.changeView(view);
        this.cctPanel.changeView(view);
        this.combinedCCT.changeView(view);
        this.combinedFlat.changeView(view);
        this.viewChanged(view);
    }

    @Override
    public boolean fitsVisibleArea() {
        if (!(this.tabs.getSelectedComponent() instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)this.tabs.getSelectedComponent()).fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        return this.tabs.getSelectedComponent() != null && this.tabs.getSelectedComponent() instanceof ScreenshotProvider && this.tabs.getSelectedComponent() != this.infoPanel;
    }

    @Override
    public void performFind() {
        if (this.tabs.getSelectedComponent() != this.infoPanel) {
            String findString = FindDialog.getFindString();
            if (findString == null) {
                return;
            }
            this.setFindString(findString);
            this.performFindFirst();
        }
    }

    public void performFindFirst() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findFirst();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findFirst();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findFirst();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findFirst();
        }
        if (!found) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    @Override
    public void performFindNext() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findNext();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findNext();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findNext();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findNext();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findNext();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findNext();
        }
        if (!found) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    @Override
    public void performFindPrevious() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean found = false;
        if (this.tabs.getSelectedComponent() == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.cctPanel.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.flatPanel.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedCCT.findPrevious();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String findString = FindDialog.getFindString();
                    if (findString == null) {
                        return;
                    }
                    this.setFindString(findString);
                }
                found = this.combinedFlat.findPrevious();
            }
        } else if (this.tabs.getSelectedComponent() == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.backtraceView.findPrevious();
        } else if (this.tabs.getSelectedComponent() == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String findString = FindDialog.getFindString();
                if (findString == null) {
                    return;
                }
                this.setFindString(findString);
            }
            found = this.subtreeView.findPrevious();
        }
        if (!found) {
            NetBeansProfiler.getDefaultNB().displayInfoAndWait(STRING_NOT_FOUND_MSG);
        }
    }

    @Override
    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateToolbar();
        if (this.tabs.getSelectedComponent() != null) {
            this.tabs.getSelectedComponent().requestFocus();
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot snapshot) {
        return "snapshot-" + snapshot.getTimeTaken();
    }

    private void setFindString(String findString) {
        this.cctPanel.setFindString(findString);
        this.flatPanel.setFindString(findString);
        this.combinedFlat.setFindString(findString);
        this.combinedCCT.setFindString(findString);
        if (this.backtraceView != null) {
            this.backtraceView.setFindString(findString);
        }
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(findString);
        }
    }

    private void closeReverseCallsGraphs() {
        if (this.backtraceView != null) {
            this.tabs.remove((Component)this.backtraceView);
            this.backtraceView = null;
        }
    }

    private void moveToNextSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getNextSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void moveToPreviousSubTab() {
        this.tabs.setSelectedIndex(UIUtils.getPreviousSubTabIndex((JTabbedPane)this.tabs, (int)this.tabs.getSelectedIndex()));
    }

    private void updateToolbar() {
        this.threadsCombo.setVisible(this.tabs.getSelectedComponent() == this.flatPanel);
        this.slaveToggleButtonDown.setVisible(this.tabs.getSelectedComponent() == this.combined);
        this.slaveToggleButtonUp.setVisible(this.tabs.getSelectedComponent() == this.combined);
        this.aggregationCombo.setEnabled(this.tabs.getSelectedComponent() != this.backtraceView && this.tabs.getSelectedComponent() != this.infoPanel && this.tabs.getSelectedComponent() != this.subtreeView);
        boolean findEnabled = this.tabs.getSelectedComponent() != this.infoPanel;
        this.saveViewAction.setEnabled(findEnabled);
        this.findActionPresenter.setEnabled(findEnabled);
        this.findPreviousPresenter.setEnabled(findEnabled);
        this.findNextPresenter.setEnabled(findEnabled);
    }

    private void viewChanged(int viewType) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (viewType) {
            case 2: {
                this.aggregationCombo.setSelectedItem(PACKAGES_STRING);
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(CLASSES_STRING);
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(METHODS_STRING);
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
    }

    @Override
    public void exportData(int exportedFileType, ExportDataDumper eDD) {
        if (this.tabs.getSelectedComponent() instanceof CCTDisplay) {
            this.cctPanel.exportData(exportedFileType, eDD, false, this.getTitle());
        } else if (this.tabs.getSelectedComponent() instanceof SnapshotFlatProfilePanel) {
            this.flatPanel.exportData(exportedFileType, eDD, false, this.getTitle());
        } else if (this.tabs.getSelectedComponent() instanceof SubtreeCallGraphPanel) {
            this.subtreeView.exportData(exportedFileType, eDD, this.getTitle());
        } else if (this.tabs.getSelectedComponent() instanceof ReverseCallGraphPanel) {
            this.backtraceView.exportData(exportedFileType, eDD, this.getTitle());
        } else if (this.tabs.getSelectedComponent() == this.combined) {
            this.combined.exportData(exportedFileType, eDD, this.getTitle());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return true;
    }

    @Override
    public boolean hasExportableView() {
        return this.tabs.getSelectedComponent() != null && this.tabs.getSelectedComponent() != this.infoPanel;
    }

    private class CombinedViewTracker
    extends FocusAdapter {
        private Object lastFocusOwner;

        private CombinedViewTracker() {
        }

        public Object getLastFocusOwner() {
            return this.lastFocusOwner;
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.lastFocusOwner = e.getSource();
        }
    }

    private final class CPUSnapshotSelectionHandler
    implements CPUSelectionHandler {
        private boolean cct;

        private CPUSnapshotSelectionHandler(boolean cct) {
            this.cct = cct;
        }

        public void methodSelected(int threadId, int methodId, int view) {
            if (CPUSnapshotPanel.this.internalSelChange) {
                return;
            }
            if (methodId == -1) {
                return;
            }
            if (this.cct) {
                if (threadId >= -1 && CPUSnapshotPanel.this.combinedFlat.getCurrentThreadId() != threadId) {
                    CPUSnapshotPanel.this.combinedFlat.setDataToDisplay(CPUSnapshotPanel.this.combinedFlat.getSnapshot(), threadId, view);
                    CPUSnapshotPanel.this.combinedFlat.prepareResults();
                }
                if (CPUSnapshotPanel.this.slaveModeDown) {
                    if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                        CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(false);
                    }
                    CPUSnapshotPanel.this.internalSelChange = true;
                    CPUSnapshotPanel.this.combinedFlat.selectMethod(methodId);
                    CPUSnapshotPanel.this.internalSelChange = false;
                } else if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(true);
                }
            } else if (CPUSnapshotPanel.this.slaveModeUp) {
                if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(false);
                }
                int curView = CPUSnapshotPanel.this.combinedFlat.getCurrentView();
                String[] names = CPUSnapshotPanel.this.snapshot.getMethodClassNameAndSig(methodId, curView);
                CPUSnapshotPanel.this.combinedCCT.setFindString(MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(names[0], names[1], names[2]).toFormatted());
                CPUSnapshotPanel.this.internalSelChange = true;
                CPUSnapshotPanel.this.combinedCCT.silentlyFindFirst();
                CPUSnapshotPanel.this.internalSelChange = false;
            } else if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(true);
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(String className, String methodName, String methodSig) {
            Project project = CPUSnapshotPanel.this.loadedSnapshot.getProject();
            ProfilingSettings[] projectSettings = ProfilingSettingsManager.getDefault().getProfilingSettings(project).getProfilingSettings();
            ArrayList<ProfilingSettings> cpuSettings = new ArrayList<ProfilingSettings>();
            for (ProfilingSettings settings : projectSettings) {
                if (!org.netbeans.modules.profiler.ui.stp.Utils.isCPUSettings(settings.getProfilingType())) continue;
                cpuSettings.add(settings);
            }
            ProfilingSettings settings = IDEUtils.selectSettings(project, 16, cpuSettings.toArray(new ProfilingSettings[cpuSettings.size()]), null);
            if (settings == null) {
                return;
            }
            settings.addRootMethod(className, methodName, methodSig);
            if (cpuSettings.contains(settings)) {
                ProfilingSettingsManager.getDefault().storeProfilingSettings(projectSettings, settings, project);
            } else {
                ProfilingSettings[] newProjectSettings = new ProfilingSettings[projectSettings.length + 1];
                System.arraycopy(projectSettings, 0, newProjectSettings, 0, projectSettings.length);
                newProjectSettings[projectSettings.length] = settings;
                ProfilingSettingsManager.getDefault().storeProfilingSettings(newProjectSettings, settings, project);
            }
        }

        public void find(Object source, String findString) {
            if (source == CPUSnapshotPanel.this.cctPanel) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.flatPanel);
                CPUSnapshotPanel.this.flatPanel.selectMethod(findString);
            } else if (source == CPUSnapshotPanel.this.flatPanel) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.cctPanel);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (source == CPUSnapshotPanel.this.combinedFlat) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (source == CPUSnapshotPanel.this.combinedCCT) {
                CPUSnapshotPanel.this.setFindString(findString);
                CPUSnapshotPanel.this.combinedFlat.selectMethod(findString);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot s, int threadId, int methodId, int view, int sortingColumn, boolean sortingOrder) {
            if (CPUSnapshotPanel.this.backtraceView != null) {
                CPUSnapshotPanel.this.tabs.remove((Component)CPUSnapshotPanel.this.backtraceView);
            }
            CPUSnapshotPanel.this.backtraceView = new ReverseCallGraphPanel((CPUResUserActionsHandler)this);
            CPUSnapshotPanel.this.backtraceView.setDataToDisplay(s, threadId, view);
            CPUSnapshotPanel.this.backtraceView.setSelectedMethodId(methodId);
            CPUSnapshotPanel.this.backtraceView.setSorting(sortingColumn, sortingOrder);
            CPUSnapshotPanel.this.backtraceView.prepareResults();
            CPUSnapshotPanel.this.backtraceView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.tabs.addTab(CPUSnapshotPanel.this.backtraceView.getShortTitle(), BACK_TRACES_TAB_ICON, (Component)CPUSnapshotPanel.this.backtraceView, CPUSnapshotPanel.this.backtraceView.getTitle());
            CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.backtraceView);
        }

        public void showSourceForMethod(String className, String methodName, String methodSig) {
            NetBeansProfiler.getDefaultNB().openJavaSource(CPUSnapshotPanel.this.loadedSnapshot.getProject(), className, methodName, methodSig);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot s, CCTNode node, int view, int sortingColumn, boolean sortingOrder) {
            if (!(node instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUSnapshotPanel.this.subtreeView != null) {
                CPUSnapshotPanel.this.tabs.remove((Component)CPUSnapshotPanel.this.subtreeView);
            }
            CPUSnapshotPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this);
            CPUSnapshotPanel.this.subtreeView.setDataToDisplay(s, (PrestimeCPUCCTNode)node, view);
            CPUSnapshotPanel.this.subtreeView.setSorting(sortingColumn, sortingOrder);
            CPUSnapshotPanel.this.subtreeView.prepareResults();
            CPUSnapshotPanel.this.subtreeView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.tabs.addTab(CPUSnapshotPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, (Component)CPUSnapshotPanel.this.subtreeView, CPUSnapshotPanel.this.subtreeView.getTitle());
            CPUSnapshotPanel.this.tabs.setSelectedComponent((Component)CPUSnapshotPanel.this.subtreeView);
        }
    }
}

