/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.search.AbstractSearchScope;
import org.openide.filesystems.FileObject;
import org.openide.util.WeakListeners;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

abstract class AbstractProjectSearchScope
extends AbstractSearchScope
implements PropertyChangeListener {
    private final String interestingProperty;
    private PropertyChangeListener openProjectsWeakListener;

    protected AbstractProjectSearchScope(String interestingProperty) {
        this.interestingProperty = interestingProperty;
    }

    protected void startListening() {
        OpenProjects openProjects = OpenProjects.getDefault();
        this.openProjectsWeakListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)openProjects);
        openProjects.addPropertyChangeListener(this.openProjectsWeakListener);
    }

    protected void stopListening() {
        OpenProjects.getDefault().removePropertyChangeListener(this.openProjectsWeakListener);
        this.openProjectsWeakListener = null;
    }

    @Override
    public final void propertyChange(PropertyChangeEvent e) {
        if (this.interestingProperty.equals(e.getPropertyName())) {
            this.updateIsApplicable();
        }
    }

    protected SearchInfo createSingleProjectSearchInfo(Project project) {
        SearchInfo prjSearchInfo = (SearchInfo)project.getLookup().lookup(SearchInfo.class);
        if (prjSearchInfo != null) {
            return prjSearchInfo;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        if (sourceGroups.length == 0) {
            return this.createEmptySearchInfo();
        }
        FileObjectFilter[] filters = new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER, SearchInfoFactory.SHARABILITY_FILTER};
        if (sourceGroups.length == 1) {
            return SearchInfoFactory.createSearchInfo((FileObject)sourceGroups[0].getRootFolder(), (boolean)true, (FileObjectFilter[])filters);
        }
        FileObject[] rootFolders = new FileObject[sourceGroups.length];
        for (int i = 0; i < sourceGroups.length; ++i) {
            rootFolders[i] = sourceGroups[i].getRootFolder();
        }
        return SearchInfoFactory.createSearchInfo((FileObject[])rootFolders, (boolean)true, (FileObjectFilter[])filters);
    }
}

