/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class RubyProjectUtil {
    private RubyProjectUtil() {
    }

    public static Object getEvaluatedProperty(Project p, String value) {
        if (value == null) {
            return null;
        }
        RubyProject j2seprj = (RubyProject)p.getLookup().lookup(RubyProject.class);
        if (j2seprj != null) {
            return j2seprj.evaluator().evaluate(value);
        }
        return null;
    }

    public static boolean hasMainMethod(FileObject fo) {
        return true;
    }

    public static List<String> getMainClasses(FileObject[] roots) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < roots.length; ++i) {
            RubyProjectUtil.getMainClasses(roots[i], result);
        }
        return result;
    }

    public static void getAllScripts(String prefix, FileObject sourcesRoot, List<String> result) {
        FileObject[] children = sourcesRoot.getChildren();
        if (!"".equals(prefix)) {
            prefix = prefix + "/";
        }
        for (int i = 0; i < children.length; ++i) {
            if (children[i].isData() && children[i].getMIMEType().equals("text/x-ruby")) {
                result.add(prefix + children[i].getNameExt());
            }
            if (!children[i].isFolder()) continue;
            RubyProjectUtil.getAllScripts(prefix + children[i].getNameExt(), children[i], result);
        }
    }

    private static void getMainClasses(FileObject root, List<String> addInto) {
        RubyProjectUtil.getAllScripts("", root, addInto);
    }

    public static boolean isMainClass(String className, FileObject[] roots) {
        if (roots == null) {
            return false;
        }
        for (FileObject root : roots) {
            if (root.getFileObject(className) == null) continue;
            return true;
        }
        return false;
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = root.toURI().toURL();
        if (FileUtil.isArchiveFile((URL)url)) {
            url = FileUtil.getArchiveRoot((URL)url);
        } else if (!root.exists()) {
            url = new URL(url.toExternalForm() + "/");
        }
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static String getLoadPath(Project project) {
        RubyBaseProject baseProject = (RubyBaseProject)project.getLookup().lookup(RubyBaseProject.class);
        assert (baseProject != null) : "No RubyBaseProject found in the project lookup. Project: " + project;
        FileObject[] srcPath = baseProject.getSourceRootFiles();
        FileObject[] testPath = baseProject.getTestSourceRootFiles();
        return RubyProjectUtil.asLoadPath(srcPath) + RubyProjectUtil.asLoadPath(testPath);
    }

    private static String asLoadPath(FileObject[] paths) {
        StringBuilder result = new StringBuilder();
        for (FileObject root : paths) {
            if (root == null || !root.isValid()) continue;
            if (result.length() > 0) {
                result.append(' ');
            }
            result.append("-I\"");
            result.append(root.getPath());
            result.append("\"");
        }
        return result.toString();
    }
}

