/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.io.IOException;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class CheckNode
extends DefaultMutableTreeNode {
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private int selectionMode;
    private boolean isSelected = true;
    private String nodeLabel;
    private Icon icon;
    private boolean disabled = false;
    private boolean needsRefresh = false;
    private String tooltip;

    public CheckNode(Object userObject, String nodeLabel, Icon icon) {
        super(userObject, !(userObject instanceof RefactoringElement));
        RefactoringElement ree;
        int s;
        this.setSelectionMode(4);
        this.nodeLabel = nodeLabel;
        this.icon = icon;
        if (userObject instanceof TreeElement && ((TreeElement)userObject).getUserObject() instanceof RefactoringElement && ((s = (ree = (RefactoringElement)((TreeElement)userObject).getUserObject()).getStatus()) == 2 || s == 3)) {
            this.isSelected = false;
            this.disabled = true;
            this.nodeLabel = "[<font color=#CC0000>" + NbBundle.getMessage(CheckNode.class, (String)(s == 2 ? "LBL_InGuardedBlock" : "LBL_InReadOnlyFile")) + "</font>]" + this.nodeLabel;
        }
    }

    String getLabel() {
        return this.nodeLabel;
    }

    Icon getIcon() {
        return this.icon;
    }

    public void setDisabled() {
        this.disabled = true;
        this.isSelected = false;
        this.removeAllChildren();
    }

    boolean isDisabled() {
        return this.disabled;
    }

    void setNeedsRefresh() {
        this.needsRefresh = true;
        this.setDisabled();
    }

    boolean needsRefresh() {
        return this.needsRefresh;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        Object ob;
        this.isSelected = isSelected;
        if (this.userObject instanceof TreeElement && (ob = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            ((RefactoringElement)ob).setEnabled(isSelected);
        }
        if (this.selectionMode == 4 && this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                CheckNode node = (CheckNode)e.nextElement();
                node.setSelected(isSelected);
            }
        }
    }

    public boolean isSelected() {
        Object ob;
        if (this.userObject instanceof TreeElement && (ob = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            return ((RefactoringElement)ob).isEnabled() && ((RefactoringElement)ob).getStatus() != 2 && ((RefactoringElement)ob).getStatus() != 3;
        }
        return this.isSelected;
    }

    public PositionBounds getPosition() {
        Object re;
        if (this.userObject instanceof TreeElement && (re = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            return ((RefactoringElement)re).getPosition();
        }
        return null;
    }

    public String getToolTip() {
        Object re;
        if (this.tooltip == null && this.userObject instanceof TreeElement && (re = ((TreeElement)this.userObject).getUserObject()) instanceof RefactoringElement) {
            RefactoringElement ree = (RefactoringElement)re;
            PositionBounds bounds = this.getPosition();
            FileObject file = ree.getParentFile();
            if (bounds != null && file != null) {
                int line;
                try {
                    line = bounds.getBegin().getLine() + 1;
                }
                catch (IOException ioe) {
                    return null;
                }
                this.tooltip = FileUtil.getFileDisplayName((FileObject)file) + ':' + line;
            }
        }
        return this.tooltip;
    }
}

