/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.model.CodeMarker;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.impl.CachingSupport;
import org.netbeans.modules.php.editor.model.impl.CodeMarkerImpl;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.openide.filesystems.FileObject;
import org.openide.util.Union2;

final class FileScopeImpl
extends ScopeImpl
implements FileScope {
    private CachingSupport cachedModelSupport;
    private ParserResult info;
    private final List<CodeMarkerImpl> codeMarkers = Collections.synchronizedList(new ArrayList());

    FileScopeImpl(ParserResult info) {
        this(info, "program");
    }

    private FileScopeImpl(ParserResult info, String name) {
        super(null, name, (Union2<String, FileObject>)Union2.createSecond(info != null ? info.getSnapshot().getSource().getFileObject() : null), new OffsetRange(0, 0), PhpElementKind.PROGRAM);
        this.info = info;
        this.cachedModelSupport = new CachingSupport(this);
    }

    void addCodeMarker(CodeMarkerImpl codeMarkerImpl) {
        this.codeMarkers.add(codeMarkerImpl);
    }

    List<? extends CodeMarker> getMarkers() {
        return this.codeMarkers;
    }

    void clearMarkers() {
        this.codeMarkers.clear();
    }

    @Override
    public IndexScope getIndexScope() {
        return ModelVisitor.getIndexScope(this.info);
    }

    @Override
    public Collection<? extends NamespaceScope> getDeclaredNamespaces() {
        return FileScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter<NamespaceScope>(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.NAMESPACE_DECLARATION);
            }
        });
    }

    @NonNull
    public CachingSupport getCachingSupport() {
        return this.cachedModelSupport;
    }

    @Override
    public NamespaceScope getDefaultDeclaredNamespace() {
        return ModelUtils.getFirst(ModelUtils.filter(this.getDeclaredNamespaces(), new ModelUtils.ElementFilter<NamespaceScope>(){

            @Override
            public boolean isAccepted(NamespaceScope ns) {
                return ns.isDefaultNamespace();
            }
        }));
    }
}

