/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.ConstantElement;
import org.netbeans.modules.php.editor.model.FieldElement;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.ClassScopeImpl;
import org.netbeans.modules.php.editor.model.impl.FileScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.TypeScopeImpl;

class CachingSupport {
    private FileScopeImpl fileScope;
    private List<ClassScope> classScopes = new ArrayList<ClassScope>();
    private List<InterfaceScope> ifaceScopes = new ArrayList<InterfaceScope>();
    private List<ConstantElement> constantScopes = new ArrayList<ConstantElement>();
    private List<FunctionScope> fncScopes = new ArrayList<FunctionScope>();
    private Map<TypeScope, List<MethodScope>> methodScopes = new LinkedHashMap<TypeScope, List<MethodScope>>();
    private Map<TypeScope, List<FieldElement>> fldElems = new LinkedHashMap<TypeScope, List<FieldElement>>();
    private Map<TypeScope, List<ClassConstantElement>> clzConstantElems = new LinkedHashMap<TypeScope, List<ClassConstantElement>>();

    @CheckForNull
    static CachingSupport getInstance(ModelElement elem) {
        FileScopeImpl fileScope = (FileScopeImpl)ModelUtils.getFileScope(elem);
        return fileScope != null ? fileScope.getCachingSupport() : null;
    }

    CachingSupport(FileScopeImpl fileScope) {
        this.fileScope = fileScope;
    }

    static Collection<? extends ClassConstantElement> getInheritedConstants(ClassScope clsScope, String constName, ModelElement elem) {
        CachingSupport modelSupport = CachingSupport.getInstance(elem);
        Collection<? extends ClassConstantElement> retval = modelSupport != null ? modelSupport.getInheritedMergedConstants((ClassScopeImpl)clsScope, constName) : ModelUtils.filter(clsScope.getInheritedConstants(), constName);
        return retval;
    }

    static Collection<? extends FieldElement> getInheritedFields(ClassScope clsScope, String fieldName, ModelElement elem, int ... modifiers) {
        assert (fieldName.startsWith("$")) : fieldName;
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        List<? extends FieldElement> retval = cachingSupport != null ? cachingSupport.getInheritedMergedFields((ClassScopeImpl)clsScope, fieldName) : ModelUtils.filter(clsScope.getInheritedFields(), fieldName);
        return retval;
    }

    static Collection<? extends MethodScope> getMethods(TypeScope clsScope, String methodName, ModelElement elem, int ... modifiers) {
        Collection<? extends MethodScope> retval;
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        if (cachingSupport != null) {
            retval = cachingSupport.getMergedMethods(clsScope, methodName, new int[0]);
        } else {
            HashSet<? extends MethodScope> tmp = new HashSet<MethodScope>();
            tmp.addAll(ModelUtils.filter(clsScope.getDeclaredMethods(), methodName));
            tmp.addAll(ModelUtils.filter(clsScope.getInheritedMethods(), methodName));
            retval = tmp;
        }
        return retval;
    }

    static Collection<? extends MethodScope> getInheritedMethods(TypeScope typeScope, String methodName, ModelElement elem, int ... modifiers) {
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        List<? extends MethodScope> retval = cachingSupport != null ? cachingSupport.getInheritedMergedMethods((TypeScopeImpl)typeScope, methodName) : ModelUtils.filter(typeScope.getInheritedMethods(), methodName);
        return retval;
    }

    static Collection<? extends TypeScope> getTypes(String typeName, ModelElement elem) {
        IndexScope indexScope = ModelUtils.getIndexScope(elem);
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        Collection<? extends TypeScope> retval = cachingSupport != null ? cachingSupport.getMergedTypes(typeName) : indexScope.findTypes(typeName);
        return retval;
    }

    static List<? extends ClassScope> getClasses(String className, ModelElement elem) {
        IndexScope indexScope = ModelUtils.getIndexScope(elem);
        CachingSupport modelSupport = CachingSupport.getInstance(elem);
        List<? extends ClassScope> retval = modelSupport != null ? modelSupport.getMergedClasses(className) : indexScope.findClasses(className);
        return retval;
    }

    static List<? extends InterfaceScope> getInterfaces(String ifaceName, ModelElement elem) {
        IndexScope indexScope = ModelUtils.getIndexScope(elem);
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        List<? extends InterfaceScope> retval = cachingSupport != null ? cachingSupport.getMergedIfaces(ifaceName) : ModelUtils.filter(indexScope.findInterfaces(ifaceName), new String[0]);
        return retval;
    }

    static List<? extends ConstantElement> getConstants(String constantName, Scope scope) {
        IndexScope indexScope = ModelUtils.getIndexScope(scope);
        CachingSupport cachingSupport = CachingSupport.getInstance(scope);
        List<? extends ConstantElement> retval = cachingSupport != null ? cachingSupport.getMergedConstants(constantName) : ModelUtils.filter(indexScope.findConstants(constantName), new String[0]);
        return retval;
    }

    static Collection<? extends FunctionScope> getFunctions(String fncName, ModelElement elem) {
        IndexScope indexScope = ModelUtils.getIndexScope(elem);
        CachingSupport cachingSupport = CachingSupport.getInstance(elem);
        List<? extends FunctionScope> retval = cachingSupport != null ? cachingSupport.getMergedFunctions(fncName) : ModelUtils.filter(indexScope.findFunctions(fncName), new String[0]);
        return retval;
    }

    private Collection<? extends ClassConstantElement> getInheritedMergedConstants(ClassScopeImpl clsScope, String constName) {
        List<ClassConstantElement> fields = this.getCachedClassConstants(clsScope, constName);
        if (fields.isEmpty()) {
            List<ClassConstantElement> methList;
            List<Object> list = fields = clsScope != null ? ModelUtils.filter(clsScope.getInheritedConstants(), constName) : Collections.emptyList();
            if (fields.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                List<Object> list2 = fields = clsScope != null ? indexScope.findInheritedClassConstants(clsScope, constName) : Collections.emptyList();
            }
            if (!fields.isEmpty() && (methList = this.clzConstantElems.get(clsScope)) != null) {
                methList.add(ModelUtils.getFirst(fields));
            }
        }
        return fields;
    }

    private List<? extends FieldElement> getInheritedMergedFields(ClassScopeImpl clsScope, String fieldName) {
        List<FieldElement> fields = this.getCachedFields(clsScope, fieldName, new int[0]);
        if (fields.isEmpty()) {
            List<FieldElement> methList;
            fields = ModelUtils.filter(clsScope.getDeclaredFields(), fieldName);
            if (fields.isEmpty()) {
                List<Object> list = fields = clsScope != null ? ModelUtils.filter(clsScope.getInheritedFields(), fieldName) : Collections.emptyList();
            }
            if (fields.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                List<Object> list = fields = clsScope != null ? indexScope.findInheritedFields(clsScope, fieldName) : Collections.emptyList();
            }
            if (!fields.isEmpty() && (methList = this.fldElems.get(clsScope)) != null) {
                methList.add(ModelUtils.getFirst(fields));
            }
        }
        return fields;
    }

    private List<? extends MethodScope> getInheritedMergedMethods(TypeScopeImpl typeScope, String methodName) {
        List<MethodScope> methods = this.getCachedMethods(typeScope, methodName, new int[0]);
        if (methods.isEmpty()) {
            methods = ModelUtils.filter(typeScope.getDeclaredMethods(), methodName);
            if (methods.isEmpty()) {
                List<Object> list = methods = typeScope != null ? ModelUtils.filter(typeScope.getInheritedMethods(), methodName) : Collections.emptyList();
            }
            if (methods.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                List<Object> list = methods = typeScope != null ? indexScope.findInheritedMethods(typeScope, methodName) : Collections.emptyList();
            }
            if (!methods.isEmpty()) {
                List<MethodScope> methList = this.methodScopes.get(typeScope);
                if (methList == null) {
                    methList = new ArrayList<MethodScope>();
                    this.methodScopes.put(typeScope, methList);
                }
                methList.add(ModelUtils.getFirst(methods));
            }
        }
        return methods;
    }

    private Collection<? extends MethodScope> getMergedMethods(TypeScope clsScope, String methodName, int ... modifiers) {
        Collection<MethodScope> methods = this.getCachedMethods(clsScope, methodName, new int[0]);
        if (methods.isEmpty()) {
            List<MethodScope> methList;
            Collection<Object> collection = methods = clsScope instanceof TypeScopeImpl ? ((TypeScopeImpl)clsScope).findDeclaredMethods(methodName, modifiers) : Collections.emptyList();
            if (methods.isEmpty()) {
                HashSet<MethodScope> tmp = new HashSet<MethodScope>();
                tmp.addAll(ModelUtils.filter(clsScope.getDeclaredMethods(), methodName));
                tmp.addAll(ModelUtils.filter(clsScope.getInheritedMethods(), methodName));
                methods = tmp;
            }
            if (!methods.isEmpty() && (methList = this.methodScopes.get(clsScope)) != null) {
                methList.add(ModelUtils.getFirst(methods));
            }
        }
        return methods;
    }

    private List<? extends InterfaceScope> getMergedIfaces(String ifaceName) {
        List<InterfaceScope> ifaces = this.getCachedInterfaces(ifaceName);
        if (ifaces.isEmpty()) {
            List<Object> list = ifaces = ifaceName != null ? ModelUtils.filter(ModelUtils.getDeclaredInterfaces(this.fileScope), ifaceName) : Collections.emptyList();
            if (ifaces.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                ifaces = ifaceName != null ? indexScope.findInterfaces(ifaceName) : Collections.emptyList();
                InterfaceScope ifce = ModelUtils.getFirst(ifaces);
                if (ifce != null) {
                    this.ifaceScopes.add(ifce);
                    this.methodScopes.put(ifce, new ArrayList());
                    this.fldElems.put(ifce, new ArrayList());
                    this.clzConstantElems.put(ifce, new ArrayList());
                }
            }
        }
        return ifaces;
    }

    private List<? extends ClassScope> getMergedClasses(String clzName) {
        List<ClassScope> classes = this.getCachedClasses(clzName);
        if (classes.isEmpty()) {
            List<Object> list = classes = clzName != null ? ModelUtils.filter(ModelUtils.getDeclaredClasses(this.fileScope), clzName) : Collections.emptyList();
            if (classes.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                classes = clzName != null ? indexScope.findClasses(clzName) : Collections.emptyList();
                ClassScope clz = ModelUtils.getFirst(classes);
                if (clz != null) {
                    this.classScopes.add(clz);
                    this.methodScopes.put(clz, new ArrayList());
                    this.fldElems.put(clz, new ArrayList());
                    this.clzConstantElems.put(clz, new ArrayList());
                }
            }
        }
        return classes;
    }

    private Collection<? extends TypeScope> getMergedTypes(String typeName) {
        Collection<? extends TypeScope> types = this.getCachedTypes(typeName);
        if (types.isEmpty()) {
            Collection<Object> collection = types = typeName != null ? ModelUtils.filter(ModelUtils.getDeclaredTypes(this.fileScope), typeName) : Collections.emptyList();
            if (types.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                types = typeName != null ? indexScope.findTypes(typeName) : Collections.emptyList();
                for (TypeScope typeScope : types) {
                    if (typeScope instanceof ClassScopeImpl) {
                        this.classScopes.add((ClassScopeImpl)typeScope);
                        continue;
                    }
                    if (!(typeScope instanceof InterfaceScopeImpl)) continue;
                    this.ifaceScopes.add((InterfaceScopeImpl)typeScope);
                }
            }
        }
        return types;
    }

    private List<? extends ConstantElement> getMergedConstants(String constantName) {
        List<ConstantElement> constants = this.getCachedConstants(constantName);
        if (constants.isEmpty()) {
            List<Object> list = constants = constantName != null ? ModelUtils.filter(ModelUtils.getDeclaredConstants(this.fileScope), constantName) : Collections.emptyList();
            if (constants.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                constants = constantName != null ? indexScope.findConstants(constantName) : Collections.emptyList();
                this.constantScopes.addAll(constants);
            }
        }
        return constants;
    }

    private List<? extends FunctionScope> getMergedFunctions(String fncName) {
        List<FunctionScope> functions = this.getCachedFunctions(fncName);
        if (functions.isEmpty()) {
            List<Object> list = functions = fncName != null ? ModelUtils.filter(ModelUtils.getDeclaredFunctions(this.fileScope), fncName) : Collections.emptyList();
            if (functions.isEmpty()) {
                IndexScope indexScope = this.fileScope.getIndexScope();
                functions = fncName != null ? indexScope.findFunctions(fncName) : Collections.emptyList();
                this.fncScopes.addAll(functions);
            }
        }
        return functions;
    }

    private List<? extends InterfaceScope> getCachedInterfaces(String ... queryName) {
        return this.getCachedInterfaces(QuerySupport.Kind.EXACT, queryName);
    }

    private List<? extends InterfaceScope> getCachedInterfaces(final QuerySupport.Kind nameKind, final String ... queryName) {
        return ModelUtils.filter(this.ifaceScopes, new ModelUtils.ElementFilter<InterfaceScope>(){

            @Override
            public boolean isAccepted(InterfaceScope element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.IFACE) && (queryName.length == 0 || ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName));
            }
        });
    }

    private List<? extends ClassScope> getCachedClasses(String ... queryName) {
        return this.getCachedClasses(QuerySupport.Kind.EXACT, queryName);
    }

    private List<? extends ClassScope> getCachedClasses(final QuerySupport.Kind nameKind, final String ... queryName) {
        return ModelUtils.filter(this.classScopes, new ModelUtils.ElementFilter<ClassScope>(){

            @Override
            public boolean isAccepted(ClassScope element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.CLASS) && (queryName.length == 0 || ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName));
            }
        });
    }

    private List<? extends FieldElement> getCachedFields(ClassScope clsScope, String queryName, int ... modifiers) {
        return this.getCachedFields(QuerySupport.Kind.EXACT, clsScope, queryName, modifiers);
    }

    private List<? extends FieldElement> getCachedFields(final QuerySupport.Kind nameKind, ClassScope clsScope, final String queryName, final int ... modifiers) {
        List<FieldElement> toFilter = this.fldElems.get(clsScope);
        if (toFilter == null) {
            return Collections.emptyList();
        }
        return ModelUtils.filter(toFilter, new ModelUtils.ElementFilter<FieldElement>(){

            @Override
            public boolean isAccepted(FieldElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.FIELD) && ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName) && (modifiers.length == 0 || (element.getPhpModifiers().toFlags() & PhpModifiers.fromBitMask(modifiers).toFlags()) != 0);
            }
        });
    }

    private List<? extends ClassConstantElement> getCachedClassConstants(ClassScopeImpl clsScope, String queryName) {
        return this.getCachedClassConstants(QuerySupport.Kind.EXACT, clsScope, queryName);
    }

    private List<? extends ClassConstantElement> getCachedClassConstants(final QuerySupport.Kind nameKind, ClassScopeImpl clsScope, final String queryName) {
        List<ClassConstantElement> toFilter = this.clzConstantElems.get(clsScope);
        if (toFilter == null) {
            return Collections.emptyList();
        }
        return ModelUtils.filter(toFilter, new ModelUtils.ElementFilter<ClassConstantElement>(){

            @Override
            public boolean isAccepted(ClassConstantElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.TYPE_CONSTANT) && ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName);
            }
        });
    }

    private List<? extends MethodScope> getCachedMethods(TypeScope typeScope, String queryName, int ... modifiers) {
        return this.getCachedMethods(QuerySupport.Kind.EXACT, typeScope, queryName, modifiers);
    }

    private List<? extends MethodScope> getCachedMethods(final QuerySupport.Kind nameKind, TypeScope typeScope, final String queryName, final int ... modifiers) {
        List<MethodScope> toFilter = this.methodScopes.get(typeScope);
        if (toFilter == null) {
            return Collections.emptyList();
        }
        List<MethodScope> retval = ModelUtils.filter(toFilter, new ModelUtils.ElementFilter<MethodScope>(){

            @Override
            public boolean isAccepted(MethodScope element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.METHOD) && ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName) && (modifiers.length == 0 || (element.getPhpModifiers().toFlags() & PhpModifiers.fromBitMask(modifiers).toFlags()) != 0);
            }
        });
        return retval;
    }

    private Collection<? extends InterfaceScope> getCachedIfaces(String ... queryName) {
        return this.getCachedIfaces(QuerySupport.Kind.EXACT, queryName);
    }

    private Collection<? extends InterfaceScope> getCachedIfaces(final QuerySupport.Kind nameKind, final String ... queryName) {
        return ModelUtils.filter(this.ifaceScopes, new ModelUtils.ElementFilter<InterfaceScope>(){

            @Override
            public boolean isAccepted(InterfaceScope element) {
                return queryName.length == 0 || ScopeImpl.nameKindMatch(element.getName(), nameKind, queryName);
            }
        });
    }

    private Collection<? extends TypeScope> getCachedTypes(String ... queryName) {
        return this.getCachedTypes(QuerySupport.Kind.EXACT, queryName);
    }

    private Collection<? extends TypeScope> getCachedTypes(QuerySupport.Kind nameKind, String ... queryName) {
        return ModelUtils.merge(this.getCachedClasses(nameKind, queryName), this.getCachedIfaces(nameKind, queryName));
    }

    public List<? extends FunctionScope> getCachedFunctions(String ... queryName) {
        return this.getCachedFunctions(QuerySupport.Kind.EXACT, queryName);
    }

    public List<? extends FunctionScope> getCachedFunctions(final QuerySupport.Kind nameKind, final String ... queryName) {
        return ModelUtils.filter(this.fncScopes, new ModelUtils.ElementFilter<FunctionScope>(){

            @Override
            public boolean isAccepted(FunctionScope element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.FUNCTION) && (queryName.length == 0 || ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName));
            }
        });
    }

    public List<? extends ConstantElement> getCachedConstants(String ... queryName) {
        return this.getCachedConstants(QuerySupport.Kind.EXACT, queryName);
    }

    private List<? extends ConstantElement> getCachedConstants(final QuerySupport.Kind nameKind, final String ... queryName) {
        return ModelUtils.filter(this.constantScopes, new ModelUtils.ElementFilter<ConstantElement>(){

            @Override
            public boolean isAccepted(ConstantElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.CONSTANT) && (queryName.length == 0 || ModelElementImpl.nameKindMatch(element.getName(), nameKind, queryName));
            }
        });
    }
}

