/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.subversion.FileStatusCache;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.client.SvnClientFactory;
import org.netbeans.modules.subversion.notifications.NotificationsManager;
import org.netbeans.modules.subversion.ui.status.StatusAction;
import org.netbeans.modules.subversion.util.Context;
import org.netbeans.modules.subversion.util.SvnSearchHistorySupport;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.FileUtils;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

class FilesystemHandler
extends VCSInterceptor {
    private final FileStatusCache cache;
    private Set<File> movedFiles = new HashSet<File>();
    private Set<File> internalyDeletedFiles = new HashSet<File>();
    private final Set<File> invalidMetadata = new HashSet<File>(5);

    public FilesystemHandler(Subversion svn) {
        this.cache = svn.getStatusCache();
    }

    public boolean beforeDelete(File file) {
        Subversion.LOG.fine("beforeDelete " + file);
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping delete due to missing client");
            return false;
        }
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return true;
        }
        return this.hasMetadata(file.getParentFile());
    }

    public void doDelete(File file) throws IOException {
        Subversion.LOG.fine("doDelete " + file);
        if (!SvnUtils.isPartOfSubversionMetadata(file)) {
            try {
                SvnClient client = Subversion.getInstance().getClient(false);
                if (this.hasMetadata(file.getParentFile())) {
                    client.remove(new File[]{file}, true);
                }
            }
            catch (SVNClientException e) {
                if (!SvnClientExceptionHandler.isTooOldClientForWC(e.getMessage())) {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                }
                IOException ex = new IOException();
                Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file, e.getLocalizedMessage()}));
                ex.initCause(e);
                throw ex;
            }
            finally {
                this.internalyDeletedFiles.add(file);
            }
        }
    }

    public void afterDelete(final File file) {
        Subversion.LOG.fine("afterDelete " + file);
        if (file == null || SvnUtils.isPartOfSubversionMetadata(file)) {
            return;
        }
        if (this.internalyDeletedFiles.remove(file)) {
            this.cache.refreshAsync(file);
            return;
        }
        Utils.post((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        File parent = file.getParentFile();
                        if (parent == null || parent.exists()) break block6;
                    }
                    catch (Throwable throwable) {
                        FilesystemHandler.this.cache.refreshAsync(file);
                        throw throwable;
                    }
                    FilesystemHandler.this.cache.refreshAsync(file);
                    return;
                }
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    if (FilesystemHandler.this.shallRemove(client, file)) {
                        client.remove(new File[]{file}, true);
                    }
                }
                catch (SVNClientException e) {
                    Subversion.LOG.log(Level.FINER, null, e);
                }
                FilesystemHandler.this.cache.refreshAsync(file);
            }
        });
    }

    private void moveFolderToDifferentRepository(File from, File to) throws IOException, SVNClientException {
        File[] files;
        assert (from.isDirectory());
        assert (to.getParentFile().exists());
        if (!to.exists()) {
            if (to.mkdir()) {
                this.cache.refreshAsync(to);
            } else {
                Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": Cannot create folder " + to);
            }
        }
        for (File file : files = from.listFiles()) {
            if (SvnUtils.isAdministrative(file)) continue;
            this.svnMoveImplementation(file, new File(to, file.getName()));
        }
    }

    private boolean shallRemove(SvnClient client, File file) throws SVNClientException {
        String existingFilename;
        boolean retval = true;
        ISVNStatus status = FilesystemHandler.getStatus(client, file);
        if (!SVNStatusKind.MISSING.equals((Object)status.getTextStatus())) {
            Subversion.LOG.fine(" shallRemove: skipping delete due to correct metadata");
            retval = false;
        } else if ("false".equals(System.getProperty("org.netbeans.modules.subversion.deleteMissingFiles", "true"))) {
            Subversion.LOG.log(Level.FINE, "File {0} deleted externally, metadata not repaired (org.netbeans.modules.subversion.deleteMissingFiles=false)", new String[]{file.getAbsolutePath()});
            retval = false;
        } else if ((Utilities.isMac() || Utilities.isWindows()) && (existingFilename = FileUtils.getExistingFilenameInParent((File)file)) != null) {
            retval = false;
        }
        return retval;
    }

    public boolean beforeMove(File from, File to) {
        Subversion.LOG.fine("beforeMove " + from + " -> " + to);
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping move due to missing client");
            return false;
        }
        File destDir = to.getParentFile();
        if (from != null && destDir != null && this.isVersioned(from)) {
            return SvnUtils.isManaged(to);
        }
        return false;
    }

    public void doMove(File from, File to) throws IOException {
        Subversion.LOG.fine("doMove " + from + " -> " + to);
        if (SwingUtilities.isEventDispatchThread()) {
            Subversion.LOG.log(Level.INFO, "Warning: launching external process in AWT", new Exception().fillInStackTrace());
        }
        this.svnMoveImplementation(from, to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterMove(File from, File to) {
        File[] files;
        Subversion.LOG.fine("afterMove " + from + " -> " + to);
        Set<File> set = this.movedFiles;
        synchronized (set) {
            this.movedFiles.add(from);
            files = this.movedFiles.toArray(new File[this.movedFiles.size()]);
            this.movedFiles.clear();
        }
        this.cache.refreshAsync(true, to);
        this.cache.refreshAsync(files);
        File parent = to.getParentFile();
        if (parent != null && from.equals(to)) {
            Subversion.LOG.warning("Wrong (identity) rename event for " + from.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beforeCreate(File file, boolean isDirectory) {
        block10: {
            Subversion.LOG.fine("beforeCreate " + file);
            if (!SvnClientFactory.isClientAvailable()) {
                Subversion.LOG.fine(" skipping create due to missing client");
                return false;
            }
            if (SvnUtils.isPartOfSubversionMetadata(file)) {
                Set<File> set = this.invalidMetadata;
                synchronized (set) {
                    File p = file;
                    while (!SvnUtils.isAdministrative(p.getName())) {
                        p = p.getParentFile();
                        assert (p != null) : "file " + file + " doesn't have a .svn parent";
                    }
                    this.invalidMetadata.add(p);
                }
                return false;
            }
            if (!file.exists()) {
                try {
                    SvnClient client = Subversion.getInstance().getClient(false);
                    this.revertDeleted(client, file, true);
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) break block10;
                    SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
                }
            }
        }
        return false;
    }

    public void doCreate(File file, boolean isDirectory) throws IOException {
    }

    public void afterCreate(final File file) {
        Subversion.LOG.fine("afterCreate " + file);
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                if (file == null) {
                    return;
                }
                int status = FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                if ((status & 0xFFFFFFFE) == 0) {
                    return;
                }
                if (file.isDirectory()) {
                    FilesystemHandler.this.cache.directoryContentChanged(file);
                }
            }
        });
    }

    public void afterChange(final File file) {
        if (!SvnClientFactory.isClientAvailable()) {
            Subversion.LOG.fine(" skipping afterChange due to missing client");
            return;
        }
        Subversion.LOG.fine("afterChange " + file);
        Utils.post((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((FilesystemHandler.this.cache.getStatus(file).getStatus() & 0xFFFFFFFE) != 0) {
                    FilesystemHandler.this.cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
            }
        });
    }

    public Object getAttribute(final File file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    if (!SvnClientFactory.isClientAvailable()) {
                        Subversion.LOG.fine(" skipping ProvidedExtensions.Refresh due to missing client");
                        return;
                    }
                    if (!SvnUtils.isManaged(file)) {
                        return;
                    }
                    try {
                        SvnClient client = Subversion.getInstance().getClient(file);
                        if (client != null) {
                            Subversion.getInstance().getStatusCache().refreshCached(new Context(file));
                            StatusAction.executeStatus(file, client, null);
                        }
                    }
                    catch (SVNClientException ex) {
                        SvnClientExceptionHandler.notifyException((Exception)((Object)ex), true, true);
                        return;
                    }
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new SvnSearchHistorySupport(file);
        }
        return super.getAttribute(file, attrName);
    }

    public void beforeEdit(File file) {
        NotificationsManager.getInstance().scheduleFor(file);
    }

    public long refreshRecursively(File dir, long lastTimeStamp, List<? super File> children) {
        long retval = -1L;
        if (SvnUtils.isAdministrative(dir.getName())) {
            retval = 0L;
        }
        return retval;
    }

    public boolean isMutable(File file) {
        return SvnUtils.isPartOfSubversionMetadata(file) || super.isMutable(file);
    }

    private String getRemoteRepository(File file) {
        if (file == null) {
            return null;
        }
        SVNUrl url = null;
        try {
            url = SvnUtils.getRepositoryRootUrl(file);
        }
        catch (SVNClientException ex) {
            Subversion.LOG.log(Level.FINE, "No repository root url found for managed file : [" + file + "]", ex);
            try {
                url = SvnUtils.getRepositoryUrl(file);
            }
            catch (SVNClientException ex1) {
                Subversion.LOG.log(Level.FINE, "No repository url found for managed file : [" + file + "]", ex1);
            }
        }
        return url != null ? url.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInvalidMetadata() {
        Set<File> set = this.invalidMetadata;
        synchronized (set) {
            for (File file : this.invalidMetadata) {
                Utils.deleteRecursively((File)file);
            }
            this.invalidMetadata.clear();
        }
    }

    private boolean hasMetadata(File file) {
        return new File(file, SvnUtils.SVN_ENTRIES_DIR).canRead();
    }

    private boolean isVersioned(File file) {
        if (SvnUtils.isPartOfSubversionMetadata(file)) {
            return false;
        }
        return !file.isFile() && this.hasMetadata(file) || file.isFile() && this.hasMetadata(file.getParentFile());
    }

    private static List<File> getDeletedParents(File file, SvnClient client) throws SVNClientException {
        ArrayList<File> ret = new ArrayList<File>();
        for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
            ISVNStatus status = FilesystemHandler.getStatus(client, parent);
            if (status == null || !status.getTextStatus().equals((Object)SVNStatusKind.DELETED)) {
                return ret;
            }
            ret.add(parent);
        }
        return ret;
    }

    private void revertDeleted(SvnClient client, File file, boolean checkParents) {
        block2: {
            try {
                ISVNStatus status = FilesystemHandler.getStatus(client, file);
                this.revertDeleted(client, status, file, checkParents);
            }
            catch (SVNClientException ex) {
                if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) break block2;
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    private void revertDeleted(SvnClient client, ISVNStatus status, File file, boolean checkParents) {
        block5: {
            try {
                if (this.equals(status, SVNStatusKind.DELETED)) {
                    if (checkParents) {
                        List<File> deletedParents = FilesystemHandler.getDeletedParents(file, client);
                        for (File parent : deletedParents) {
                            client.revert(parent, false);
                        }
                    }
                    client.revert(file, false);
                    this.internalyDeletedFiles.add(file);
                    file.delete();
                }
            }
            catch (SVNClientException ex) {
                if (SvnClientExceptionHandler.isTooOldClientForWC(ex.getMessage())) break block5;
                SvnClientExceptionHandler.notifyException((Exception)((Object)ex), false, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnMoveImplementation(File from, File to) throws IOException {
        try {
            boolean force = true;
            SvnClient client = Subversion.getInstance().getClient(false);
            File tmpMetadata = null;
            try {
                this.removeInvalidMetadata();
                File parent = to.isDirectory() ? to : to.getParentFile();
                if (parent != null) {
                    assert (SvnUtils.isManaged(parent)) : "Cannot move " + from.getAbsolutePath() + " to " + to.getAbsolutePath() + ", " + parent.getAbsolutePath() + " is not managed";
                    if (!this.hasMetadata(parent)) {
                        this.addDirectories(parent);
                    }
                }
                int retryCounter = 6;
                while (true) {
                    try {
                        ISVNStatus toStatus = FilesystemHandler.getStatus(client, to);
                        ISVNStatus status = FilesystemHandler.getStatus(client, from);
                        List<File> srcChildren = null;
                        SVNUrl url = status != null ? status.getUrlCopiedFrom() : null;
                        SVNUrl toUrl = toStatus != null ? toStatus.getUrl() : null;
                        try {
                            srcChildren = SvnUtils.listRecursively(from);
                            boolean moved = true;
                            if (status != null && status.getTextStatus().equals((Object)SVNStatusKind.ADDED) && (!status.isCopied() || url != null && url.equals((Object)toUrl))) {
                                this.revertDeleted(client, toStatus, to, false);
                                client.revert(from, true);
                                moved = from.renameTo(to);
                            } else if (status != null && (status.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED) || status.getTextStatus().equals((Object)SVNStatusKind.IGNORED))) {
                                this.revertDeleted(client, toStatus, to, false);
                                moved = from.renameTo(to);
                            } else {
                                SVNUrl repositoryTarget;
                                SVNUrl repositorySource = SvnUtils.getRepositoryRootUrl(from);
                                if (repositorySource.equals((Object)(repositoryTarget = SvnUtils.getRepositoryRootUrl(parent)))) {
                                    client.move(from, to, force);
                                } else if (from.isDirectory()) {
                                    this.moveFolderToDifferentRepository(from, to);
                                } else if (from.renameTo(to)) {
                                    client.remove(new File[]{from}, force);
                                    Subversion.LOG.log(Level.FINE, FilesystemHandler.class.getName() + ": moving between different repositories {0} to {1}", new Object[]{from, to});
                                } else {
                                    Subversion.LOG.log(Level.WARNING, FilesystemHandler.class.getName() + ": cannot rename {0} to {1}", new Object[]{from, to});
                                }
                            }
                            if (!moved) {
                                Subversion.LOG.log(Level.INFO, "Cannot rename file {0} to {1}", new Object[]{from, to});
                            }
                        }
                        finally {
                            Set<File> set = this.movedFiles;
                            synchronized (set) {
                                if (srcChildren != null) {
                                    this.movedFiles.addAll(srcChildren);
                                }
                            }
                        }
                    }
                    catch (SVNClientException e) {
                        if (e.getMessage().endsWith("' locked") && retryCounter > 0) {
                            try {
                                Thread.sleep(107L);
                            }
                            catch (InterruptedException ex) {
                                // empty catch block
                            }
                            --retryCounter;
                            continue;
                        }
                        if (!SvnClientExceptionHandler.isTooOldClientForWC(e.getMessage())) {
                            SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
                        }
                        IOException ex = new IOException();
                        Exceptions.attachLocalizedMessage((Throwable)e, (String)NbBundle.getMessage(FilesystemHandler.class, (String)"MSG_RenameFailed", (Object[])new Object[]{from, to, e.getLocalizedMessage()}));
                        ex.initCause(e);
                        throw ex;
                    }
                    break;
                }
            }
            finally {
                if (tmpMetadata != null) {
                    FileUtils.deleteRecursively(tmpMetadata);
                }
            }
        }
        catch (SVNClientException e) {
            if (!SvnClientExceptionHandler.isTooOldClientForWC(e.getMessage())) {
                SvnClientExceptionHandler.notifyException((Exception)((Object)e), false, false);
            }
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)e, (String)("Subversion failed to rename " + from.getAbsolutePath() + " to: " + to.getAbsolutePath() + "\n" + e.getLocalizedMessage()));
            ex.initCause(e);
            throw ex;
        }
    }

    private boolean addDirectories(File dir) throws SVNClientException {
        File parent = dir.getParentFile();
        SvnClient client = Subversion.getInstance().getClient(false);
        if (parent != null) {
            ISVNStatus s = FilesystemHandler.getStatus(client, parent);
            if (s.getTextStatus().equals((Object)SVNStatusKind.IGNORED)) {
                return false;
            }
            if (SvnUtils.isManaged(parent) && !this.hasMetadata(parent) && !this.addDirectories(parent)) {
                return false;
            }
            client.addDirectory(dir, false);
            this.cache.refreshAsync(dir);
            return true;
        }
        throw new SVNClientException("Reached FS root, but it's still not Subversion versioned!");
    }

    private static ISVNStatus getStatus(SvnClient client, File file) throws SVNClientException {
        return client.getSingleStatus(file);
    }

    private boolean equals(ISVNStatus status, SVNStatusKind kind) {
        return status != null && status.getTextStatus().equals((Object)kind);
    }
}

