/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.WeakListeners;

class JavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation {
    private static final String PROP_JAVADOC_DIR = "dist.javadoc.dir";
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final String[] binaryProperties;

    public JavadocForBinaryQueryImpl(AntProjectHelper helper, PropertyEvaluator evaluator, String[] binaryProperties) {
        assert (helper != null);
        assert (evaluator != null);
        assert (binaryProperties != null && binaryProperties.length > 0);
        this.helper = helper;
        this.evaluator = evaluator;
        this.binaryProperties = binaryProperties;
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        for (String property : this.binaryProperties) {
            if (!this.isRootOwner(binaryRoot, property)) continue;
            class Result
            implements JavadocForBinaryQuery.Result,
            PropertyChangeListener {
                private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
                private URL[] result;
                private long eventId;

                public Result() {
                    JavadocForBinaryQueryImpl.this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)JavadocForBinaryQueryImpl.this.evaluator));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public URL[] getRoots() {
                    URL[] lResult;
                    long lEventId;
                    Result result = this;
                    synchronized (result) {
                        if (this.result != null) {
                            return this.result;
                        }
                        lEventId = this.eventId;
                    }
                    String javadocDir = JavadocForBinaryQueryImpl.this.evaluator.getProperty(JavadocForBinaryQueryImpl.PROP_JAVADOC_DIR);
                    if (javadocDir != null) {
                        File f = JavadocForBinaryQueryImpl.this.helper.resolveFile(javadocDir);
                        try {
                            URL url = f.toURI().toURL();
                            if (!f.exists()) {
                                assert (!url.toExternalForm().endsWith("/")) : f;
                                url = new URL(url.toExternalForm() + "/");
                            }
                            lResult = new URL[]{url};
                        }
                        catch (MalformedURLException e) {
                            lResult = new URL[]{};
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    } else {
                        lResult = new URL[]{};
                    }
                    Result result2 = this;
                    synchronized (result2) {
                        if (lEventId == this.eventId) {
                            if (this.result == null) {
                                this.result = lResult;
                            }
                            return this.result;
                        }
                        return lResult;
                    }
                }

                public void addChangeListener(ChangeListener l) {
                    this.changeSupport.addChangeListener(l);
                }

                public void removeChangeListener(ChangeListener l) {
                    this.changeSupport.removeChangeListener(l);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void propertyChange(PropertyChangeEvent event) {
                    if (JavadocForBinaryQueryImpl.PROP_JAVADOC_DIR.equals(event.getPropertyName())) {
                        Result result = this;
                        synchronized (result) {
                            this.result = null;
                            ++this.eventId;
                        }
                        this.changeSupport.fireChange();
                    }
                }
            }
            return new Result();
        }
        return null;
    }

    private boolean isRootOwner(URL binaryRoot, String binaryProperty) {
        try {
            String outDir;
            if (FileUtil.getArchiveFile((URL)binaryRoot) != null) {
                binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
            }
            if ((outDir = this.evaluator.getProperty(binaryProperty)) != null) {
                File f = this.helper.resolveFile(outDir);
                URL url = f.toURI().toURL();
                if (!f.exists() && !f.getPath().toLowerCase().endsWith(".jar")) {
                    assert (!url.toExternalForm().endsWith("/")) : f;
                    url = new URL(url.toExternalForm() + "/");
                }
                return url.equals(binaryRoot) || binaryRoot.toExternalForm().startsWith(url.toExternalForm());
            }
        }
        catch (MalformedURLException malformedURL) {
            Exceptions.printStackTrace((Throwable)malformedURL);
        }
        return false;
    }
}

