/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.testrunner.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.ruby.rubyproject.spi.TestRunner;
import org.netbeans.modules.ruby.testrunner.TestRunnerUtilities;
import org.netbeans.modules.ruby.testrunner.ui.TestHandlerFactory;
import org.netbeans.modules.ruby.testrunner.ui.TestRecognizerHandler;
import org.openide.util.NbBundle;

public class TestUnitHandlerFactory
implements TestHandlerFactory {
    private static final Logger LOGGER = Logger.getLogger(TestUnitHandlerFactory.class.getName());

    @Override
    public boolean printSummary() {
        return true;
    }

    @Override
    public List<TestRecognizerHandler> createHandlers() {
        ArrayList<TestRecognizerHandler> result = new ArrayList<TestRecognizerHandler>();
        result.add(new SuiteStartingHandler());
        result.add(new SuiteStartedHandler());
        result.add(new SuiteFinishedHandler());
        result.add(new SuiteErrorOutputHandler());
        result.add(new ShouldaTestStartedHandler());
        result.add(new ShouldaTestFailedHandler());
        result.add(new ShouldaTestErrorHandler());
        result.add(new TestStartedHandler());
        result.add(new TestFailedHandler());
        result.add(new TestErrorHandler());
        result.add(new ShouldaTestFinishedHandler());
        result.add(new TestFinishedHandler());
        result.add(new TestLoggerHandler());
        result.add(new TestMiscHandler());
        result.add(new SuiteMiscHandler());
        return result;
    }

    private static String errorMsg(long failureCount) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Error", (Object)failureCount);
    }

    private static String failureMsg(long failureCount) {
        return NbBundle.getMessage(TestUnitHandlerFactory.class, (String)"MSG_Failure", (Object)failureCount);
    }

    static String[] getStackTrace(String message, String stackTrace) {
        ArrayList<String> stackTraceList = new ArrayList<String>();
        stackTraceList.add(message);
        for (String location : stackTrace.split("%BR%")) {
            if (TestRunnerUtilities.filterOutFromStacktrace(location)) continue;
            stackTraceList.add(location);
        }
        return stackTraceList.toArray(new String[stackTraceList.size()]);
    }

    static class TestLoggerHandler
    extends TestRecognizerHandler {
        public TestLoggerHandler() {
            super("%TEST_LOGGER%\\slevel=(.+)\\smsg=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Level level = Level.parse(this.matcher.group(1));
            if (LOGGER.isLoggable(level)) {
                LOGGER.log(level, this.matcher.group(2));
            }
        }
    }

    static class SuiteMiscHandler
    extends TestRecognizerHandler {
        public SuiteMiscHandler() {
            super("%SUITE_.*");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SuiteStartingHandler
    extends TestRecognizerHandler {
        private boolean firstSuite = true;

        public SuiteStartingHandler() {
            super("%SUITE_STARTING%\\s(.+)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            if (this.firstSuite) {
                this.firstSuite = false;
                manager.testStarted(session);
            }
            String suiteName = this.matcher.group(1);
            session.addSuite(new TestSuite(suiteName));
            manager.displaySuiteRunning(session, suiteName);
        }
    }

    static class SuiteErrorOutputHandler
    extends TestRecognizerHandler {
        public SuiteErrorOutputHandler() {
            super("%SUITE_ERROR_OUTPUT%\\serror=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            manager.displayOutput(session, this.matcher.group(1), true);
            manager.displayOutput(session, "", false);
        }

        @Override
        List<String> getRecognizedOutput() {
            return Collections.singletonList(this.matcher.group(1));
        }
    }

    static class SuiteStartedHandler
    extends TestRecognizerHandler {
        public SuiteStartedHandler() {
            super("%SUITE_STARTED%\\s.*");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class SuiteFinishedHandler
    extends TestRecognizerHandler {
        public SuiteFinishedHandler() {
            super("%SUITE_FINISHED%\\stime=(.+)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            manager.displayReport(session, session.getReport((long)SuiteFinishedHandler.toMillis(this.matcher.group(1))));
        }
    }

    static class TestMiscHandler
    extends TestRecognizerHandler {
        public TestMiscHandler() {
            super("%TEST_.*");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class ShouldaTestErrorHandler
    extends TestErrorHandler {
        public ShouldaTestErrorHandler() {
            super("%TEST_ERROR%\\stime=(.+)\\stestname=test:\\s(.+)\\.\\s\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }
    }

    static class ShouldaTestFinishedHandler
    extends TestFinishedHandler {
        public ShouldaTestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\stest:\\s(.*)\\.\\s\\((.+)\\)");
        }
    }

    static class TestFinishedHandler
    extends TestRecognizerHandler {
        public TestFinishedHandler(String regex) {
            super(regex);
        }

        public TestFinishedHandler() {
            super("%TEST_FINISHED%\\stime=(.+)\\s(.+)\\((.+)\\)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), session);
            testcase.setTimeMillis((long)TestFinishedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            session.addTestCase(testcase);
        }
    }

    static class ShouldaTestStartedHandler
    extends TestRecognizerHandler {
        public ShouldaTestStartedHandler() {
            super("%TEST_STARTED%\\stest:\\s(.*)\\.\\s\\((.+)\\)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class TestStartedHandler
    extends TestRecognizerHandler {
        public TestStartedHandler() {
            super("%TEST_STARTED%\\s(.+)\\((.+)\\)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
        }
    }

    static class TestErrorHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestErrorHandler() {
            this("%TEST_ERROR%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        public TestErrorHandler(String regex) {
            super(regex);
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), session);
            testcase.setTimeMillis((long)TestErrorHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(true));
            testcase.getTrouble().setStackTrace(TestUnitHandlerFactory.getStackTrace(this.matcher.group(4), this.matcher.group(5)));
            session.addTestCase(testcase);
            String errorMsg = TestUnitHandlerFactory.errorMsg(session.incrementFailuresCount());
            String testCase = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(errorMsg);
            this.output.add(testCase);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(session, "", false);
            manager.displayOutput(session, errorMsg, false);
            manager.displayOutput(session, testCase, false);
            for (String line : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(session, line, true);
            }
            manager.displayOutput(session, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }

    static class ShouldaTestFailedHandler
    extends TestFailedHandler {
        public ShouldaTestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=test:\\s(.*)\\.\\s\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }
    }

    static class TestFailedHandler
    extends TestRecognizerHandler {
        private List<String> output;

        public TestFailedHandler(String regex) {
            super(regex);
        }

        public TestFailedHandler() {
            super("%TEST_FAILED%\\stime=(.+)\\stestname=(.+)\\((.+)\\)\\smessage=(.*)\\slocation=(.*)");
        }

        @Override
        void updateUI(Manager manager, TestSession session) {
            Testcase testcase = new Testcase(this.matcher.group(2), TestRunner.TestType.TEST_UNIT.name(), session);
            testcase.setTimeMillis((long)TestFailedHandler.toMillis(this.matcher.group(1)));
            testcase.setClassName(this.matcher.group(3));
            testcase.setTrouble(new Trouble(false));
            String message = this.matcher.group(4);
            testcase.getTrouble().setComparisonFailure(TestFailedHandler.getComparisonFailure(message));
            String location = this.matcher.group(5);
            testcase.getTrouble().setStackTrace(TestUnitHandlerFactory.getStackTrace(message, location));
            session.addTestCase(testcase);
            String failureMsg = TestUnitHandlerFactory.failureMsg(session.incrementFailuresCount());
            String testCase = testcase.getName() + "(" + testcase.getClassName() + "):";
            this.output = new ArrayList<String>();
            this.output.add("");
            this.output.add(failureMsg);
            this.output.add(testCase);
            this.output.addAll(Arrays.asList(testcase.getTrouble().getStackTrace()));
            this.output.add("");
            manager.displayOutput(session, "", false);
            manager.displayOutput(session, failureMsg, false);
            manager.displayOutput(session, testCase, false);
            for (String line : testcase.getTrouble().getStackTrace()) {
                manager.displayOutput(session, line, false);
            }
            manager.displayOutput(session, "", false);
            testcase.addOutputLines(this.output);
        }

        @Override
        List<String> getRecognizedOutput() {
            return new ArrayList<String>(this.output);
        }
    }
}

