/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardinstaller;

import com.sun.javacard.offcardinstaller.TargetHelper;
import com.sun.javacard.tools.util.JCToolsLogger;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodRetryHandler;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;

public class RITargetHelper
extends TargetHelper {
    JCToolsLogger toolsLogger;
    private HttpMethodRetryHandler retryhandler = new HttpMethodRetryHandler(){

        public boolean retryMethod(HttpMethod httpMethod, IOException iOException, int n) {
            if (n >= 5) {
                return false;
            }
            if (iOException instanceof ConnectException) {
                return false;
            }
            if (iOException instanceof SocketException) {
                return false;
            }
            if (iOException instanceof NoHttpResponseException) {
                return true;
            }
            return !httpMethod.isRequestSent();
        }
    };

    public RITargetHelper(ResourceBundle resourceBundle, JCToolsLogger jCToolsLogger) {
        super(resourceBundle);
        this.toolsLogger = jCToolsLogger;
    }

    @Override
    public int load(String string, String string2, String string3, String string4, File file, File file2, String string5, String string6, String string7, String string8, String string9, String string10, String string11, int n) throws Exception {
        this.toolsLogger.info("RITH.info.1", new Object[0]);
        if (string4 == null) {
            throw new Exception(this.getResourceString("load.error.1"));
        }
        if (n == -1) {
            throw new Exception(this.getResourceString("load.error.11"));
        }
        if (string6 == null) {
            throw new Exception(this.getFormattedResourceString("load.error.6", file2.getAbsolutePath()));
        }
        if (string5 == null) {
            throw new Exception(this.getFormattedResourceString("load.error.7", file2.getAbsolutePath()));
        }
        if (!file.exists()) {
            throw new Exception(this.getFormattedResourceString("load.error.4", file.getAbsolutePath()));
        }
        int n2 = 5;
        if (string7 != null && string8 != null && string9 != null && string10 != null && string11 != null) {
            n2 = 10;
        }
        Part[] partArray = new Part[n2];
        partArray[0] = new FilePart("bundleFile", file, "application/java-archive", null);
        partArray[1] = new StringPart("bundleID", string4);
        partArray[2] = new StringPart("signature", string6);
        partArray[3] = new StringPart("certificate", string5);
        if (n2 == 5) {
            partArray[4] = new StringPart("type", Integer.toString(n));
        } else {
            partArray[4] = new StringPart("selfIdServer", string7);
            partArray[5] = new StringPart("sslPrivKeyMod", string8);
            partArray[6] = new StringPart("sslPrivKeyExp", string9);
            partArray[7] = new StringPart("trustedCA", string10);
            partArray[8] = new StringPart("acceptedIssuer", string11);
            partArray[9] = new StringPart("type", Integer.toString(n));
        }
        this.toolsLogger.info("RITH.info.2", new Object[0]);
        return this.doPost(string, string2, string3, "load", partArray);
    }

    @Override
    public int create(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        int n;
        Object object;
        this.toolsLogger.info("RITH.info.3", new Object[0]);
        if (string4 == null) {
            throw new Exception(this.getResourceString("create.error.1"));
        }
        if (string5 != null) {
            if (string7 != null) {
                if (string7.length() % 2 == 1) {
                    throw new Exception(this.getResourceString("create.error.3"));
                }
                for (int i = 0; i < string7.length(); ++i) {
                    try {
                        Integer.parseInt(string7.substring(i, i + 1), 16);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new Exception(this.getResourceString("create.error.4"));
                    }
                }
            }
        } else if (string7 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string7, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                n = object.indexOf(61);
                if (n > 0) continue;
                throw new Exception(this.getResourceString("create.error.5"));
            }
        }
        if (string8 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string8, ";");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                n = object.indexOf(61);
                if (n > 0) continue;
                throw new Exception(this.getResourceString("create.error.6"));
            }
        }
        this.toolsLogger.info("RITH.info.4", new Object[0]);
        Vector<StringPart> vector = new Vector<StringPart>();
        vector.addElement(new StringPart("bundleID", string4));
        if (string5 != null) {
            vector.addElement(new StringPart("appletID", string5));
        }
        if (string6 != null) {
            vector.addElement(new StringPart("instanceID", string6));
        }
        if (string7 != null) {
            vector.addElement(new StringPart("initParameters", string7));
        }
        if (string8 != null) {
            vector.addElement(new StringPart("runtimeParameters", string8));
        }
        object = new Part[vector.size()];
        vector.toArray((T[])object);
        this.toolsLogger.info("RITH.info.5", new Object[0]);
        return this.doPost(string, string2, string3, "create", (Part[])object);
    }

    @Override
    public int delete(String string, String string2, String string3, String string4) throws Exception {
        this.toolsLogger.info("RITH.info.6", new Object[0]);
        if (string4 == null) {
            this.toolsLogger.severe("delete.error.1", new Object[0]);
            throw new Exception(this.getResourceString("delete.error.1"));
        }
        Part[] partArray = new Part[]{new StringPart("instanceID", string4)};
        this.toolsLogger.info("RITH.info.7", new Object[0]);
        return this.doPost(string, string2, string3, "delete", partArray);
    }

    @Override
    public int unload(String string, String string2, String string3, String string4, boolean bl) throws Exception {
        this.toolsLogger.info("RITH.info.8", new Object[0]);
        if (string4 == null) {
            throw new Exception(this.getResourceString("unload.error.1"));
        }
        Part[] partArray = new Part[]{new StringPart("bundleID", string4), new StringPart("force", bl ? "1" : "0")};
        this.toolsLogger.info("RITH.info.9", new Object[0]);
        return this.doPost(string, string2, string3, "unload", partArray);
    }

    @Override
    public int list(String string, String string2, String string3, boolean bl) throws Exception {
        Part[] partArray = new Part[]{new StringPart("detailed", bl ? "1" : "0")};
        this.toolsLogger.info("RITH.info.10", new Object[0]);
        return this.doPost(string, string2, string3, "list", partArray);
    }

    private int doPost(String string, String string2, String string3, String string4, Part[] partArray) throws Exception {
        String string5;
        int n = 0;
        String string6 = null;
        String string7 = null;
        HttpClient httpClient = new HttpClient();
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        string = string + string4;
        PostMethod postMethod = new PostMethod(string);
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)this.retryhandler);
        postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(partArray, postMethod.getParams()));
        try {
            Header header;
            httpClient.executeMethod((HttpMethod)postMethod);
            n = postMethod.getStatusCode();
            string6 = postMethod.getStatusText();
            if (n == 401) {
                if (string2 == null) {
                    throw new Exception(this.getResourceString("installer.error.2"));
                }
                if (string3 == null) {
                    throw new Exception(this.getResourceString("installer.error.3"));
                }
                httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(string2, string3));
                httpClient.executeMethod((HttpMethod)postMethod);
                n = postMethod.getStatusCode();
                string6 = postMethod.getStatusText();
            }
            if ((header = postMethod.getResponseHeader("JC-Status")) == null) {
                throw new Exception(this.getResourceString("installer.error.4"));
            }
            string5 = header.getValue();
            string7 = postMethod.getResponseBodyAsString();
            if (string7 == null) {
                string7 = "";
            }
            this.handleResponse(string4, n, string6, string5, string7);
        }
        catch (UnknownHostException unknownHostException) {
            throw new Exception(this.getResourceString("installer.error.1"));
        }
        finally {
            postMethod.releaseConnection();
        }
        int n2 = Integer.parseInt(string5);
        if (n2 != 2000 && n2 != 2010) {
            if (n2 == 4089) {
                return n2;
            }
            return 1;
        }
        return 0;
    }

    private void handleResponse(String string, int n, String string2, String string3, String string4) {
        if (n != 200 && n != 400) {
            this.toolsLogger.severe("installer.error.5", new Object[0]);
            this.toolsLogger.severe("    " + string2, new Object[0]);
            String string5 = null;
            try {
                string5 = this.getFormattedResourceString("response." + string3, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string5 != null) {
                this.toolsLogger.severe("    " + string5, new Object[0]);
            }
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string4, "\r\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken().trim();
        }
        try {
            String string6 = this.getFormattedResourceString("response." + string3, stringArray);
            this.toolsLogger.info(string6, new Object[0]);
            if (string.equals("list")) {
                this.toolsLogger.info(string4, new Object[0]);
            }
        }
        catch (Exception exception) {
            this.toolsLogger.severe("installer.error.6", new Object[0]);
            this.toolsLogger.severe("JC Status Code: " + string3, new Object[0]);
            this.toolsLogger.severe("HTTP Status Code: " + n, new Object[0]);
            this.toolsLogger.severe("    message: " + string2, new Object[0]);
            this.toolsLogger.severe("    JC-Status: " + string4, new Object[0]);
            this.toolsLogger.severe("    description: " + string4, new Object[0]);
        }
    }
}

