/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.jcasm.cap;

import com.sun.javacard.jcasm.ExceptionTable;
import com.sun.javacard.jcasm.ExceptionTableEntry;
import com.sun.javacard.jcasm.Instruction;
import com.sun.javacard.jcasm.JCClass;
import com.sun.javacard.jcasm.JCMethod;
import com.sun.javacard.jcasm.JCPackage;
import com.sun.javacard.jcasm.Msg;
import com.sun.javacard.jcasm.Operand;
import com.sun.javacard.jcasm.Statement;
import com.sun.javacard.jcasm.cap.Component;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Vector;

public class ReferenceLocationComponent
extends Component {
    protected Vector<Integer> ref1Vector = new Vector();
    protected Vector<Integer> ref2Vector = new Vector();
    private static int f_byteOffset;
    private static int f_byte2Offset;

    public ReferenceLocationComponent(JCPackage jCPackage) {
        super(jCPackage);
        f_byte2Offset = f_byteOffset = 1;
    }

    public void addOneByteOffset(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.ref1Vector.addElement(new Integer(n));
    }

    public void addTwoByteOffset(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException();
        }
        this.ref2Vector.addElement(new Integer(n));
    }

    @Override
    public int dataSize() {
        return 4 + this.ref1Vector.size() + this.ref2Vector.size();
    }

    @Override
    public byte[] toByteArray() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            byte[] byArray = super.toByteArray();
            dataOutputStream.write(byArray, 0, byArray.length);
            dataOutputStream.writeShort(this.ref1Vector.size());
            for (Integer n : this.ref1Vector) {
                dataOutputStream.writeByte(n);
            }
            dataOutputStream.writeShort(this.ref2Vector.size());
            for (Integer n : this.ref2Vector) {
                dataOutputStream.writeByte(n);
            }
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            return null;
        }
        assert (this.size() == byteArrayOutputStream.size()) : "size() != bos.size()";
        return byteArrayOutputStream.toByteArray();
    }

    public void addException(JCClass jCClass) {
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration<JCMethod> enumeration = jCClass.methodElements();
        while (enumeration.hasMoreElements()) {
            JCMethod jCMethod = enumeration.nextElement();
            ExceptionTable exceptionTable = jCMethod.getExceptionTable();
            if (exceptionTable == null) continue;
            Enumeration<ExceptionTableEntry> enumeration2 = exceptionTable.elements();
            while (enumeration2.hasMoreElements()) {
                ExceptionTableEntry exceptionTableEntry = enumeration2.nextElement();
                if (exceptionTableEntry.getCatchIndex() != 0) {
                    this.addTwoByteOffset(f_byte2Offset + 6);
                    f_byte2Offset = 2;
                } else {
                    f_byte2Offset += 8;
                }
                f_byteOffset += 8;
            }
        }
    }

    public void add(JCClass jCClass) {
        int n;
        int n2;
        Operand operand;
        Enumeration<Operand> enumeration;
        Instruction instruction;
        Statement statement;
        Enumeration<Statement> enumeration2;
        JCMethod jCMethod;
        if (Modifier.isInterface(jCClass.getAttributes())) {
            return;
        }
        Enumeration<JCMethod> enumeration3 = jCClass.methodElements();
        while (enumeration3.hasMoreElements()) {
            jCMethod = enumeration3.nextElement();
            f_byteOffset += jCMethod.getMethodHeader().length;
            enumeration2 = jCMethod.statementElements();
            while (enumeration2.hasMoreElements()) {
                statement = enumeration2.nextElement();
                instruction = statement.getInstruction();
                ++f_byteOffset;
                enumeration = instruction.operandElements();
                block8: while (enumeration.hasMoreElements()) {
                    operand = enumeration.nextElement();
                    switch (operand.getType()) {
                        case 7: {
                            if (f_byteOffset >= 255) {
                                n2 = f_byteOffset / 255;
                                f_byteOffset %= 255;
                                for (n = 0; n < n2; ++n) {
                                    this.addOneByteOffset(255);
                                }
                            }
                            this.addOneByteOffset(f_byteOffset);
                            f_byteOffset = operand.size();
                            continue block8;
                        }
                    }
                    f_byteOffset += operand.size();
                }
            }
        }
        enumeration3 = jCClass.methodElements();
        while (enumeration3.hasMoreElements()) {
            jCMethod = enumeration3.nextElement();
            f_byte2Offset += jCMethod.getMethodHeader().length;
            enumeration2 = jCMethod.statementElements();
            while (enumeration2.hasMoreElements()) {
                statement = enumeration2.nextElement();
                instruction = statement.getInstruction();
                ++f_byte2Offset;
                enumeration = instruction.operandElements();
                block12: while (enumeration.hasMoreElements()) {
                    operand = enumeration.nextElement();
                    switch (operand.getType()) {
                        case 8: {
                            if (f_byte2Offset >= 255) {
                                n2 = f_byte2Offset / 255;
                                f_byte2Offset %= 255;
                                for (n = 0; n < n2; ++n) {
                                    this.addTwoByteOffset(255);
                                }
                            }
                            this.addTwoByteOffset(f_byte2Offset);
                            f_byte2Offset = operand.size();
                            continue block12;
                        }
                    }
                    f_byte2Offset += operand.size();
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        int n = 0;
        stringBuffer.append("byte index count: " + this.ref1Vector.size() + Msg.eol);
        stringBuffer.append("// Offsets to Byte Indices[]: " + Msg.eol);
        for (Integer n2 : this.ref1Vector) {
            stringBuffer.append(" " + Msg.toHexString((byte)n2.intValue()));
            if (++n % 16 != 0) continue;
            stringBuffer.append(Msg.eol);
        }
        if (n % 16 != 0) {
            stringBuffer.append(Msg.eol);
        }
        n = 0;
        stringBuffer.append("byte2 index count: " + this.ref2Vector.size() + Msg.eol);
        stringBuffer.append("// Offsets to Byte2 Indices[]: " + Msg.eol);
        for (Integer n2 : this.ref2Vector) {
            stringBuffer.append(" " + Msg.toHexString((byte)n2.intValue()));
            if (++n % 16 != 0) continue;
            stringBuffer.append(Msg.eol);
        }
        if (n % 16 != 0) {
            stringBuffer.append(Msg.eol);
        }
        return stringBuffer.toString();
    }
}

