/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.symbol;

import java.io.File;
import javax.swing.Icon;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmDisplayUtilities;
import org.netbeans.modules.cnd.modelutil.CsmImageLoader;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.spi.jumpto.symbol.SymbolDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class CppSymbolDescriptor
extends SymbolDescriptor {
    private final Icon icon;
    private final CsmProject project;
    private final CharSequence absPath;
    private final int offset;
    private final CharSequence ownerName;
    private final CharSequence name;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CppSymbolDescriptor(CsmOffsetable csmObj) {
        Parameters.notNull((CharSequence)"csmObj", (Object)csmObj);
        CsmFile csmFile = csmObj.getContainingFile();
        this.absPath = csmFile.getAbsolutePath();
        this.offset = csmObj.getStartOffset();
        this.project = csmFile.getProject();
        if (CsmKindUtilities.isFunction((CsmObject)csmObj)) {
            this.name = ((CsmFunction)csmObj).getSignature();
        } else {
            if (!CsmKindUtilities.isNamedElement((CsmObject)csmObj)) throw new IllegalArgumentException("should be CsmNamedElement, in fact " + csmObj.getClass().getName());
            this.name = ((CsmNamedElement)csmObj).getName();
        }
        if (CsmKindUtilities.isMacro((CsmObject)csmObj)) {
            this.ownerName = this.getBriefFileName(this.absPath);
        } else {
            if (!CsmKindUtilities.isOffsetableDeclaration((Object)csmObj)) throw new IllegalArgumentException("should be either CsmMacro or CsmDeclaration, in fact " + csmObj.getClass().getName());
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)csmObj;
            CsmScope scope = decl.getScope();
            if (CsmKindUtilities.isFile((CsmObject)scope)) {
                this.ownerName = this.getBriefFileName(this.absPath);
            } else {
                if (!CsmKindUtilities.isQualified((CsmObject)scope)) throw new IllegalArgumentException("should be either CsmFile or CsmQualifiedNamedElement, in fact " + csmObj.getClass().getName());
                CharSequence fileName = this.getBriefFileName(this.absPath);
                CharSequence qName = ((CsmQualifiedNamedElement)scope).getQualifiedName();
                this.ownerName = qName.length() > 0 ? NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CPP_Descriptor_In_Compound", (Object)qName, (Object)fileName) : fileName;
            }
        }
        this.icon = CsmImageLoader.getIcon((CsmObject)csmObj);
    }

    private CharSequence getBriefFileName(CharSequence fileName) {
        for (int i = fileName.length() - 1; i >= 0; --i) {
            char c = fileName.charAt(i);
            if (c != '/' && c != '\\') continue;
            return fileName.subSequence(i + 1, fileName.length());
        }
        return fileName;
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)new File(((Object)this.absPath).toString()));
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOwnerName() {
        return ((Object)this.ownerName).toString();
    }

    public Icon getProjectIcon() {
        return CsmImageLoader.getIcon((CsmObject)this.project);
    }

    public String getProjectName() {
        CharSequence prjName = this.project.getName();
        if (this.project.isArtificial()) {
            prjName = CsmDisplayUtilities.shrinkPath((CharSequence)prjName, (int)32, (int)2, (int)2);
        }
        return ((Object)prjName).toString();
    }

    public String getSymbolName() {
        return ((Object)this.name).toString();
    }

    public CharSequence getRawName() {
        for (int i = 0; i < this.name.length(); ++i) {
            if (this.name.charAt(i) != '(') continue;
            return this.name.subSequence(0, i);
        }
        return this.name;
    }

    public void open() {
        CsmUtilities.openSource((FileObject)this.getFileObject(), (int)this.offset);
    }
}

