/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.samples.ui;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.websvc.rest.samples.ui.SampleWizardPanel;
import org.netbeans.modules.websvc.rest.samples.util.RestSampleUtils;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class SampleWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    public static final String PROJDIR = "projdir";
    public static final String NAME = "name";
    private Project myProject;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    public transient WizardDescriptor wiz;
    private String projectConfigNamespace = "http://www.netbeans.org/ns/web-project/3";

    public static SampleWizardIterator createIterator() {
        return new SampleWizardIterator();
    }

    protected WizardDescriptor.Panel[] createPanels() {
        return new WizardDescriptor.Panel[]{new SampleWizardPanel()};
    }

    protected String[] createSteps() {
        return new String[]{NbBundle.getMessage(SampleWizardIterator.class, (String)"MSG_NameAndLocation")};
    }

    public Project getProject() {
        return this.myProject;
    }

    public void setProjectConfigNamespace(String namespace) {
        this.projectConfigNamespace = namespace;
    }

    public Set<FileObject> instantiate() throws IOException {
        Project p;
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty(PROJDIR)));
        dirF.mkdirs();
        String name = (String)this.wiz.getProperty(NAME);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        dir = dir.createFolder(name);
        dirF = FileUtil.toFile((FileObject)dir);
        RestSampleUtils.unZipFile(template.getInputStream(), dir);
        ProjectManager.getDefault().clearNonProjectCache();
        if (this.projectConfigNamespace != null) {
            RestSampleUtils.setProjectName(dir, this.projectConfigNamespace, name);
        }
        this.myProject = p = ProjectManager.getDefault().findProject(dir);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty(PROJDIR, null);
        this.wiz.putProperty(NAME, null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    protected void replaceTokens(FileObject dir, String[] files, String[][] tokens) throws IOException {
        for (String file : files) {
            this.replaceToken(dir.getFileObject(file), tokens);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceToken(FileObject fo, String[][] tokens) throws IOException {
        if (fo == null) {
            return;
        }
        FileLock lock = fo.lock();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(FileUtil.toFile((FileObject)fo)));
            StringBuffer sb = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                for (int i = 0; i < tokens.length; ++i) {
                    line = line.replaceAll(tokens[i][0], tokens[i][1]);
                }
                sb.append(line);
                sb.append("\n");
            }
            OutputStreamWriter writer = new OutputStreamWriter(fo.getOutputStream(lock), "UTF-8");
            try {
                writer.write(sb.toString());
            }
            finally {
                writer.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }
}

