/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.editor.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.EditorOptions;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.groovy.editor.api.AstPath;
import org.netbeans.modules.groovy.editor.api.AstUtilities;
import org.netbeans.modules.groovy.editor.api.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.editor.api.lexer.LexUtilities;
import org.netbeans.modules.groovy.editor.api.parser.GroovyParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class BracketCompleter
implements KeystrokeHandler {
    static final boolean CONTINUE_COMMENTS = Boolean.getBoolean("groovy.cont.comment");
    private static final TokenId[] STRING_TOKENS = new TokenId[]{GroovyTokenId.STRING_LITERAL, GroovyTokenId.STRING_END};
    private static final TokenId[] REGEXP_TOKENS = new TokenId[]{GroovyTokenId.REGEXP_LITERAL, GroovyTokenId.REGEXP_END};
    private int previousAdjustmentOffset = -1;
    private boolean isAfter;
    private int previousAdjustmentIndent;

    public boolean isInsertMatchingEnabled(BaseDocument doc) {
        EditorOptions options = EditorOptions.get((String)"text/x-groovy");
        if (options != null) {
            return options.getMatchBrackets();
        }
        return true;
    }

    public int beforeBreak(Document document, int offset, JTextComponent target) throws BadLocationException {
        boolean isComment;
        int end;
        String line;
        boolean isBlockStart;
        int begin;
        Token<? extends GroovyTokenId> prevToken;
        String text;
        boolean insert;
        this.isAfter = false;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        boolean insertMatching = this.isInsertMatchingEnabled(doc);
        int lineBegin = Utilities.getRowStart((BaseDocument)doc, (int)offset);
        int lineEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset);
        if (lineBegin == offset && lineEnd == offset) {
            return -1;
        }
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        TokenId id = token.id();
        boolean[] insertRBraceResult = new boolean[1];
        int[] indentResult = new int[1];
        boolean bl = insert = insertMatching && BracketCompleter.isEndMissing(doc, offset, false, insertRBraceResult, null, indentResult);
        if (insert) {
            boolean insertRBrace = insertRBraceResult[0];
            int indent = indentResult[0];
            int afterLastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            if (offset > afterLastNonWhite) {
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            } else {
                String restOfLine = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)afterLastNonWhite) - offset);
                sb.append(restOfLine);
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                doc.remove(offset, restOfLine.length());
            }
            if (insertRBrace) {
                sb.append("}");
            }
            int insertOffset = offset;
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
            return -1;
        }
        if (id == GroovyTokenId.ERROR && (text = ((Object)token.text()).toString()).startsWith("/*") && ts.offset() == Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            sb.append(" * ");
            int offsetDelta = sb.length() + 1;
            sb.append("\n");
            sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            sb.append(" */");
            doc.insertString(offset, sb.toString(), null);
            caret.setDot(offset);
            return offset + offsetDelta;
        }
        if (id == GroovyTokenId.REGEXP_LITERAL || id == GroovyTokenId.REGEXP_END && offset < ts.offset() + ts.token().length()) {
            String str = id != GroovyTokenId.REGEXP_LITERAL || offset > ts.offset() ? "\\n\\" : "\\";
            doc.insertString(offset, str, null);
            caret.setDot(offset + str.length());
            return offset + 1 + str.length();
        }
        if ((id == GroovyTokenId.RBRACE || id == GroovyTokenId.RBRACKET) && offset > 0 && (prevToken = LexUtilities.getToken(doc, offset - 1)) != null) {
            GroovyTokenId prevTokenId = (GroovyTokenId)prevToken.id();
            if (id == GroovyTokenId.RBRACE && prevTokenId == GroovyTokenId.LBRACE || id == GroovyTokenId.RBRACKET && prevTokenId == GroovyTokenId.LBRACKET) {
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                StringBuilder sb = new StringBuilder();
                sb.append("\n");
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                int insertOffset = offset;
                doc.insertString(insertOffset, sb.toString(), null);
                caret.setDot(insertOffset);
            }
        }
        if (id == GroovyTokenId.WHITESPACE && (begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset)) != -1 && offset < begin) {
            ts.move(begin);
            if (ts.moveNext() && (id = ts.token().id()) == GroovyTokenId.LINE_COMMENT) {
                offset = begin;
            }
        }
        if (id == GroovyTokenId.BLOCK_COMMENT && offset > ts.offset() && ((isBlockStart = (line = doc.getText(begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset), (end = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1) - begin)).startsWith("/*")) || line.startsWith("*"))) {
            char c;
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            StringBuilder sb = new StringBuilder();
            if (isBlockStart) {
                ++indent;
            }
            sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
            sb.append("*");
            int afterStar = isBlockStart ? begin + 2 : begin + 1;
            line = doc.getText(afterStar, Utilities.getRowEnd((BaseDocument)doc, (int)afterStar) - afterStar);
            for (int i = 0; i < line.length() && ((c = line.charAt(i)) == ' ' || c == '\t'); ++i) {
                sb.append(c);
            }
            int insertOffset = offset;
            if (offset == begin && insertOffset > 0) {
                insertOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                int sp = Utilities.getRowStart((BaseDocument)doc, (int)offset) + sb.length();
                doc.insertString(insertOffset, sb.toString(), null);
                caret.setDot(sp);
                return sp;
            }
            doc.insertString(insertOffset, sb.toString(), null);
            caret.setDot(insertOffset);
            return insertOffset + sb.length() + 1;
        }
        boolean bl2 = isComment = id == GroovyTokenId.LINE_COMMENT;
        if (id == GroovyTokenId.EOL && ts.movePrevious() && ts.token().id() == GroovyTokenId.LINE_COMMENT) {
            isComment = true;
        }
        if (isComment) {
            Token<? extends GroovyTokenId> firstToken;
            int nextBegin;
            int rowEnd;
            Token<? extends GroovyTokenId> firstToken2;
            int prevBegin;
            boolean continueComment = false;
            int begin2 = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
            boolean previousLineWasComment = false;
            boolean nextLineIsComment = false;
            int rowStart = Utilities.getRowStart((BaseDocument)doc, (int)offset);
            if (rowStart > 0 && (prevBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)(rowStart - 1))) != -1 && (firstToken2 = LexUtilities.getToken(doc, prevBegin)) != null && firstToken2.id() == GroovyTokenId.LINE_COMMENT) {
                previousLineWasComment = true;
            }
            if ((rowEnd = Utilities.getRowEnd((BaseDocument)doc, (int)offset)) < doc.getLength() && (nextBegin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)(rowEnd + 1))) != -1 && (firstToken = LexUtilities.getToken(doc, nextBegin)) != null && firstToken.id() == GroovyTokenId.LINE_COMMENT) {
                nextLineIsComment = true;
            }
            if (previousLineWasComment || nextLineIsComment || offset > ts.offset() && offset < ts.offset() + ts.token().length()) {
                Token<? extends GroovyTokenId> firstToken3;
                int nextLineFirst;
                int nextLine;
                if (ts.offset() + token.length() > offset + 1) {
                    String trailing = doc.getText(offset, Utilities.getRowEnd((BaseDocument)doc, (int)offset) - offset);
                    if (trailing.trim().length() != 0) {
                        continueComment = true;
                    }
                } else if (CONTINUE_COMMENTS && (firstToken = LexUtilities.getToken(doc, begin2)).id() == GroovyTokenId.LINE_COMMENT) {
                    continueComment = true;
                }
                if (!continueComment && (nextLine = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1) < doc.getLength() && (nextLineFirst = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)nextLine)) != -1 && (firstToken3 = LexUtilities.getToken(doc, nextLineFirst)) != null && firstToken3.id() == GroovyTokenId.LINE_COMMENT) {
                    continueComment = true;
                }
            }
            if (continueComment) {
                char c;
                int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                StringBuilder sb = new StringBuilder();
                sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
                sb.append("//");
                int afterSlash = begin2 + 2;
                String line2 = doc.getText(afterSlash, Utilities.getRowEnd((BaseDocument)doc, (int)afterSlash) - afterSlash);
                for (int i = 0; i < line2.length() && ((c = line2.charAt(i)) == ' ' || c == '\t'); ++i) {
                    sb.append(c);
                }
                int insertOffset = offset;
                if (offset == begin2 && insertOffset > 0) {
                    insertOffset = Utilities.getRowStart((BaseDocument)doc, (int)offset);
                    int sp = Utilities.getRowStart((BaseDocument)doc, (int)offset) + sb.length();
                    doc.insertString(insertOffset, sb.toString(), null);
                    caret.setDot(sp);
                    return sp;
                }
                doc.insertString(insertOffset, sb.toString(), null);
                caret.setDot(insertOffset);
                return insertOffset + sb.length() + 1;
            }
        }
        return -1;
    }

    static boolean isEndMissing(BaseDocument doc, int offset, boolean skipJunk, boolean[] insertRBraceResult, int[] startOffsetResult, int[] indentResult) throws BadLocationException {
        int length = doc.getLength();
        if (startOffsetResult != null) {
            startOffsetResult[0] = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
        }
        int beginEndBalance = LexUtilities.getBeginEndLineBalance(doc, offset, true);
        int braceBalance = LexUtilities.getLineBalance(doc, offset, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE);
        if (beginEndBalance == 1 || braceBalance == 1) {
            int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
            boolean insertRBrace = braceBalance > 0;
            int next = Utilities.getRowEnd((BaseDocument)doc, (int)offset) + 1;
            while (next < length) {
                if (!(Utilities.isRowEmpty((BaseDocument)doc, (int)next) || Utilities.isRowWhite((BaseDocument)doc, (int)next) || LexUtilities.isCommentOnlyLine(doc, next))) {
                    int nextIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)next);
                    if (nextIndent > indent) {
                        insertRBrace = false;
                        break;
                    }
                    if (nextIndent != indent || !insertRBrace || LexUtilities.getLineBalance(doc, next, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE) >= 0) break;
                    insertRBrace = false;
                    break;
                }
                next = Utilities.getRowEnd((BaseDocument)doc, (int)next) + 1;
            }
            if (insertRBraceResult != null) {
                insertRBraceResult[0] = insertRBrace;
            }
            if (indentResult != null) {
                indentResult[0] = indent;
            }
            return insertRBrace;
        }
        return false;
    }

    public boolean beforeCharInserted(Document document, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> ts;
        this.isAfter = false;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (!this.isInsertMatchingEnabled(doc)) {
            return false;
        }
        if (target.getSelectionStart() != -1) {
            char firstChar;
            String selection;
            if (GsfUtilities.isCodeTemplateEditing((Document)doc)) {
                int end;
                int start = target.getSelectionStart();
                if (start < (end = target.getSelectionEnd())) {
                    target.setSelectionStart(start);
                    target.setSelectionEnd(start);
                    caretOffset = start;
                    caret.setDot(caretOffset);
                    doc.remove(start, end - start);
                }
            } else if ((ch == '\"' || ch == '\'' || ch == '(' || ch == '{' || ch == '[' || ch == '/') && (selection = target.getSelectedText()) != null && selection.length() > 0 && (firstChar = selection.charAt(0)) != ch) {
                int start = target.getSelectionStart();
                int end = target.getSelectionEnd();
                TokenSequence<? extends GroovyTokenId> ts2 = LexUtilities.getPositionedSequence(doc, start);
                if (ts2 != null && ts2.token().id() != GroovyTokenId.STRING_LITERAL) {
                    char lastChar = selection.charAt(selection.length() - 1);
                    if (selection.length() > 1 && (firstChar == '\"' || firstChar == '\'' || firstChar == '(' || firstChar == '{' || firstChar == '[' || firstChar == '/') && lastChar == this.matching(firstChar)) {
                        doc.remove(end - 1, 1);
                        doc.insertString(end - 1, "" + this.matching(ch), null);
                        doc.remove(start, 1);
                        doc.insertString(start, "" + ch, null);
                        target.getCaret().setDot(end);
                    } else {
                        doc.remove(start, end - start);
                        doc.insertString(start, ch + selection + this.matching(ch), null);
                        target.getCaret().setDot(start + selection.length() + 2);
                    }
                    return true;
                }
            }
        }
        if ((ts = LexUtilities.getGroovyTokenSequence(doc, caretOffset)) == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token token = ts.token();
        TokenId id = token.id();
        TokenId[] stringTokens = null;
        GroovyTokenId beginTokenId = null;
        if (ch == '\"' || ch == '\'') {
            stringTokens = STRING_TOKENS;
            beginTokenId = GroovyTokenId.STRING_BEGIN;
        } else if (id == GroovyTokenId.ERROR) {
            ts.movePrevious();
            TokenId prevId = ts.token().id();
            if (prevId == GroovyTokenId.STRING_BEGIN) {
                stringTokens = STRING_TOKENS;
                beginTokenId = prevId;
            } else if (prevId == GroovyTokenId.REGEXP_BEGIN) {
                stringTokens = REGEXP_TOKENS;
                beginTokenId = GroovyTokenId.REGEXP_BEGIN;
            }
        } else if (id == GroovyTokenId.STRING_BEGIN && caretOffset == ts.offset() + 1) {
            if (!Character.isLetter(ch)) {
                stringTokens = STRING_TOKENS;
                beginTokenId = id;
            }
        } else if (id == GroovyTokenId.STRING_BEGIN && caretOffset == ts.offset() + 2 || id == GroovyTokenId.STRING_END) {
            stringTokens = STRING_TOKENS;
            beginTokenId = GroovyTokenId.STRING_BEGIN;
        } else if (id == GroovyTokenId.REGEXP_BEGIN && caretOffset == ts.offset() + 2 || id == GroovyTokenId.REGEXP_END) {
            stringTokens = REGEXP_TOKENS;
            beginTokenId = GroovyTokenId.REGEXP_BEGIN;
        }
        if (stringTokens != null) {
            boolean inserted = this.completeQuote(doc, caretOffset, caret, ch, stringTokens, beginTokenId);
            if (inserted) {
                caret.setDot(caretOffset + 1);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean afterCharInserted(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> ts;
        this.isAfter = true;
        Caret caret = target.getCaret();
        BaseDocument doc = (BaseDocument)document;
        if (this.previousAdjustmentOffset != -1) {
            if (dotPos == this.previousAdjustmentOffset && (ts = LexUtilities.getGroovyTokenSequence(doc, dotPos)) != null) {
                ts.move(dotPos);
                if (ts.moveNext() && ts.offset() < dotPos) {
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)dotPos, (int)this.previousAdjustmentIndent);
                }
            }
            this.previousAdjustmentOffset = -1;
        }
        switch (ch) {
            case '(': 
            case ')': 
            case '[': 
            case ']': 
            case '{': 
            case '}': {
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                Token<? extends GroovyTokenId> token = LexUtilities.getToken(doc, dotPos);
                if (token == null) {
                    return true;
                }
                TokenId id = token.id();
                if (id == GroovyTokenId.ANY_OPERATOR) {
                    int length = token.length();
                    String s = ((Object)token.text()).toString();
                    if (length == 2 && "[]".equals(s) || "[]=".equals(s)) {
                        this.skipClosingBracket(doc, caret, ch, GroovyTokenId.RBRACKET);
                        return true;
                    }
                }
                if (id == GroovyTokenId.IDENTIFIER && token.length() == 1 || id == GroovyTokenId.LBRACKET || id == GroovyTokenId.RBRACKET || id == GroovyTokenId.LBRACE || id == GroovyTokenId.RBRACE || id == GroovyTokenId.LPAREN || id == GroovyTokenId.RPAREN) {
                    if (ch == ']') {
                        this.skipClosingBracket(doc, caret, ch, GroovyTokenId.RBRACKET);
                    } else if (ch == ')') {
                        this.skipClosingBracket(doc, caret, ch, GroovyTokenId.RPAREN);
                    } else if (ch == '}') {
                        this.skipClosingBracket(doc, caret, ch, GroovyTokenId.RBRACE);
                    } else if (ch == '[' || ch == '(' || ch == '{') {
                        this.completeOpeningBracket(doc, dotPos, caret, ch);
                    }
                }
                if (ch == '}') {
                    this.reindent(doc, dotPos, GroovyTokenId.RBRACE, caret);
                    break;
                }
                if (ch != ']') break;
                this.reindent(doc, dotPos, GroovyTokenId.RBRACKET, caret);
                break;
            }
            case ';': {
                BracketCompleter.moveSemicolon(doc, dotPos, caret);
                break;
            }
            case '/': {
                if (!this.isInsertMatchingEnabled(doc)) {
                    return false;
                }
                ts = LexUtilities.getPositionedSequence(doc, dotPos);
                if (ts == null) break;
                Token token = ts.token();
                TokenId id = token.id();
                if (id == GroovyTokenId.LINE_COMMENT && dotPos == ts.offset() + 1 && dotPos + 1 < doc.getLength() && doc.getText(dotPos + 1, 1).charAt(0) == '/') {
                    doc.remove(dotPos, 1);
                    caret.setDot(dotPos + 1);
                    return true;
                }
                if (id != GroovyTokenId.REGEXP_BEGIN && id != GroovyTokenId.REGEXP_END) break;
                TokenId[] stringTokens = REGEXP_TOKENS;
                GroovyTokenId beginTokenId = GroovyTokenId.REGEXP_BEGIN;
                boolean inserted = this.completeQuote(doc, dotPos, caret, ch, stringTokens, beginTokenId);
                if (inserted) {
                    caret.setDot(dotPos + 1);
                }
                return inserted;
            }
        }
        return true;
    }

    private void reindent(BaseDocument doc, int offset, TokenId id, Caret caret) throws BadLocationException {
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, offset);
        if (ts != null) {
            ts.move(offset);
            if (!ts.moveNext() && !ts.movePrevious()) {
                return;
            }
            Token token = ts.token();
            if (token.id() == id) {
                int rowFirstNonWhite = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)offset);
                if (ts.offset() > rowFirstNonWhite) {
                    return;
                }
                OffsetRange begin = id == GroovyTokenId.RBRACE ? LexUtilities.findBwd(doc, ts, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE) : (id == GroovyTokenId.RBRACKET ? LexUtilities.findBwd(doc, ts, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET) : LexUtilities.findBegin(doc, ts));
                if (begin != OffsetRange.NONE) {
                    int beginOffset = begin.getStart();
                    int indent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)beginOffset);
                    this.previousAdjustmentIndent = GsfUtilities.getLineIndent((BaseDocument)doc, (int)offset);
                    GsfUtilities.setLineIndentation((BaseDocument)doc, (int)offset, (int)indent);
                    this.previousAdjustmentOffset = caret.getDot();
                }
            }
        }
    }

    public OffsetRange findMatching(Document document, int offset) {
        return OffsetRange.NONE;
    }

    public boolean charBackspaced(Document document, int dotPos, JTextComponent target, char ch) throws BadLocationException {
        BaseDocument doc = (BaseDocument)document;
        switch (ch) {
            case '(': 
            case '[': 
            case '{': {
                char tokenAtDot = LexUtilities.getTokenChar(doc, dotPos);
                if (!(tokenAtDot == ']' && LexUtilities.getTokenBalance(doc, GroovyTokenId.LBRACKET, GroovyTokenId.RBRACKET, dotPos) != 0 || tokenAtDot == ')' && LexUtilities.getTokenBalance(doc, GroovyTokenId.LPAREN, GroovyTokenId.RPAREN, dotPos) != 0) && (tokenAtDot != '}' || LexUtilities.getTokenBalance(doc, GroovyTokenId.LBRACE, GroovyTokenId.RBRACE, dotPos) == 0)) break;
                doc.remove(dotPos, 1);
                break;
            }
            case '\"': 
            case '\'': 
            case '|': {
                char[] match = doc.getChars(dotPos, 1);
                if (match == null || match[0] != ch) break;
                doc.remove(dotPos, 1);
            }
        }
        return true;
    }

    private void skipClosingBracket(BaseDocument doc, Caret caret, char bracket, TokenId bracketId) throws BadLocationException {
        int caretOffset = caret.getDot();
        if (this.isSkipClosingBracket(doc, caretOffset, bracketId)) {
            doc.remove(caretOffset - 1, 1);
            caret.setDot(caretOffset);
        }
    }

    private boolean isSkipClosingBracket(BaseDocument doc, int caretOffset, TokenId bracketId) throws BadLocationException {
        if (caretOffset == doc.getLength()) {
            return false;
        }
        boolean skipClosingBracket = false;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, caretOffset);
        if (ts == null) {
            return false;
        }
        ts.move(caretOffset);
        if (!ts.moveNext()) {
            return false;
        }
        Token token = ts.token();
        if (token != null && token.id() == bracketId) {
            int bracketIntId = bracketId.ordinal();
            int leftBracketIntId = bracketIntId == GroovyTokenId.RPAREN.ordinal() ? GroovyTokenId.LPAREN.ordinal() : GroovyTokenId.LBRACKET.ordinal();
            ts.moveNext();
            Token nextToken = ts.token();
            while (nextToken != null && nextToken.id() == bracketId) {
                token = nextToken;
                if (!ts.moveNext()) break;
                nextToken = ts.token();
            }
            int braceBalance = 0;
            int bracketBalance = -1;
            Token lastRBracket = token;
            ts.movePrevious();
            token = ts.token();
            boolean finished = false;
            while (!finished && token != null) {
                int tokenIntId = ((GroovyTokenId)token.id()).ordinal();
                if (token.id() == GroovyTokenId.LPAREN || token.id() == GroovyTokenId.LBRACKET) {
                    if (tokenIntId == bracketIntId && ++bracketBalance == 0) {
                        if (braceBalance != 0) {
                            bracketBalance = 1;
                        }
                        finished = true;
                    }
                } else if (token.id() == GroovyTokenId.RPAREN || token.id() == GroovyTokenId.RBRACKET) {
                    if (tokenIntId == bracketIntId) {
                        --bracketBalance;
                    }
                } else if (token.id() == GroovyTokenId.LBRACE) {
                    if (++braceBalance > 0) {
                        finished = true;
                    }
                } else if (token.id() == GroovyTokenId.RBRACE) {
                    --braceBalance;
                }
                if (!ts.movePrevious()) break;
                token = ts.token();
            }
            if (bracketBalance != 0) {
                skipClosingBracket = true;
            } else {
                braceBalance = 0;
                bracketBalance = 1;
                TokenHierarchy th = TokenHierarchy.get((Document)doc);
                int ofs = lastRBracket.offset(th);
                ts.move(ofs);
                ts.moveNext();
                token = ts.token();
                finished = false;
                while (!finished && token != null) {
                    if (token.id() == GroovyTokenId.LPAREN || token.id() == GroovyTokenId.LBRACKET) {
                        if (((GroovyTokenId)token.id()).ordinal() == leftBracketIntId) {
                            ++bracketBalance;
                        }
                    } else if (token.id() == GroovyTokenId.RPAREN || token.id() == GroovyTokenId.RBRACKET) {
                        if (((GroovyTokenId)token.id()).ordinal() == bracketIntId && --bracketBalance == 0) {
                            if (braceBalance != 0) {
                                bracketBalance = -1;
                            }
                            finished = true;
                        }
                    } else if (token.id() == GroovyTokenId.LBRACE) {
                        ++braceBalance;
                    } else if (token.id() == GroovyTokenId.RBRACE && --braceBalance < 0) {
                        finished = true;
                    }
                    if (!ts.movePrevious()) break;
                    token = ts.token();
                }
                skipClosingBracket = bracketBalance == 0;
            }
        }
        return skipClosingBracket;
    }

    private void completeOpeningBracket(BaseDocument doc, int dotPos, Caret caret, char bracket) throws BadLocationException {
        if (this.isCompletablePosition(doc, dotPos + 1)) {
            String matchingBracket = "" + this.matching(bracket);
            doc.insertString(dotPos + 1, matchingBracket, null);
            caret.setDot(dotPos + 1);
        }
    }

    private boolean isEscapeSequence(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos <= 0) {
            return false;
        }
        char previousChar = doc.getChars(dotPos - 1, 1)[0];
        return previousChar == '\\';
    }

    private boolean completeQuote(BaseDocument doc, int dotPos, Caret caret, char bracket, TokenId[] stringTokens, TokenId beginToken) throws BadLocationException {
        int lastNonWhite;
        boolean eol;
        if (this.isEscapeSequence(doc, dotPos)) {
            return false;
        }
        if (doc.getLength() < dotPos) {
            return false;
        }
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, dotPos);
        if (ts == null) {
            return false;
        }
        ts.move(dotPos);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return false;
        }
        Token<? extends GroovyTokenId> token = ts.token();
        Token previousToken = null;
        if (ts.movePrevious()) {
            previousToken = ts.token();
        }
        boolean bl = eol = (lastNonWhite = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)dotPos)) < dotPos;
        if (token.id() == GroovyTokenId.BLOCK_COMMENT || token.id() == GroovyTokenId.LINE_COMMENT) {
            return false;
        }
        if ((token.id() == GroovyTokenId.WHITESPACE || token.id() == GroovyTokenId.NLS) && eol && dotPos - 1 > 0 && (token = LexUtilities.getToken(doc, dotPos - 1)).id() == GroovyTokenId.LINE_COMMENT) {
            return false;
        }
        boolean completablePosition = this.isQuoteCompletablePosition(doc, dotPos);
        boolean insideString = false;
        TokenId id = token.id();
        for (TokenId currId : stringTokens) {
            if (id != currId) continue;
            insideString = true;
            break;
        }
        if (id == GroovyTokenId.ERROR && previousToken != null && previousToken.id() == beginToken) {
            insideString = true;
        }
        if (id == GroovyTokenId.EOL && previousToken != null) {
            if (previousToken.id() == beginToken) {
                insideString = true;
            } else if (previousToken.id() == GroovyTokenId.ERROR && ts.movePrevious() && ts.token().id() == beginToken) {
                insideString = true;
            }
        }
        if (!insideString && token.id() == GroovyTokenId.WHITESPACE && eol && dotPos - 1 > 0) {
            token = LexUtilities.getToken(doc, dotPos - 1);
            boolean bl2 = insideString = token.id() == GroovyTokenId.STRING_LITERAL;
        }
        if (insideString) {
            if (eol) {
                return false;
            }
            char chr = doc.getChars(dotPos, 1)[0];
            if (chr == bracket) {
                if (!this.isAfter) {
                    doc.insertString(dotPos, "" + bracket, null);
                } else if (dotPos >= doc.getLength() - 1 || doc.getText(dotPos + 1, 1).charAt(0) != bracket) {
                    return true;
                }
                doc.remove(dotPos, 1);
                return true;
            }
        }
        if (completablePosition && !insideString || eol) {
            doc.insertString(dotPos, "" + bracket + (this.isAfter ? "" : Character.valueOf(this.matching(bracket))), null);
            return true;
        }
        return false;
    }

    private boolean isCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        char chr = doc.getChars(dotPos, 1)[0];
        return chr == ')' || chr == ',' || chr == '\"' || chr == '\'' || chr == ' ' || chr == ']' || chr == '}' || chr == '\n' || chr == '\t' || chr == ';';
    }

    private boolean isQuoteCompletablePosition(BaseDocument doc, int dotPos) throws BadLocationException {
        if (dotPos == doc.getLength()) {
            return true;
        }
        int eol = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        if (dotPos == eol || eol == -1) {
            return false;
        }
        int firstNonWhiteFwd = Utilities.getFirstNonWhiteFwd((BaseDocument)doc, (int)dotPos, (int)eol);
        if (firstNonWhiteFwd == -1) {
            return false;
        }
        char chr = doc.getChars(firstNonWhiteFwd, 1)[0];
        return chr == ')' || chr == ',' || chr == '+' || chr == '}' || chr == ';' || chr == ']' || chr == '/';
    }

    private char matching(char bracket) {
        switch (bracket) {
            case '(': {
                return ')';
            }
            case '/': {
                return '/';
            }
            case '[': {
                return ']';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
        }
        return bracket;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        ModuleNode root = AstUtilities.getRoot(info);
        if (root == null) {
            return Collections.emptyList();
        }
        GroovyParserResult gpr = AstUtilities.getParseResult((Parser.Result)info);
        int astOffset = AstUtilities.getAstOffset((Parser.Result)info, caretOffset);
        if (astOffset == -1) {
            return Collections.emptyList();
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int min = 0;
        int max = Integer.MAX_VALUE;
        try {
            BaseDocument doc = LexUtilities.getDocument(gpr, false);
            if (doc == null) {
                return ranges;
            }
            AstPath path = new AstPath((ASTNode)root, astOffset, doc);
            int length = doc.getLength();
            TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getPositionedSequence(doc, caretOffset);
            if (ts != null) {
                int end;
                int begin;
                Token token = ts.token();
                if (token != null && token.id() == GroovyTokenId.BLOCK_COMMENT) {
                    begin = ts.offset();
                    end = begin + token.length();
                    ranges.add(new OffsetRange(begin, end));
                } else if (token != null && token.id() == GroovyTokenId.LINE_COMMENT) {
                    begin = Utilities.getRowStart((BaseDocument)doc, (int)caretOffset);
                    end = Utilities.getRowEnd((BaseDocument)doc, (int)caretOffset);
                    if (LexUtilities.isCommentOnlyLine(doc, caretOffset)) {
                        ranges.add(new OffsetRange(Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)begin), Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end) + 1));
                        int lineBegin = begin;
                        int lineEnd = end;
                        while (begin > 0) {
                            int newBegin = Utilities.getRowStart((BaseDocument)doc, (int)(begin - 1));
                            if (newBegin < 0 || !LexUtilities.isCommentOnlyLine(doc, newBegin)) {
                                begin = Utilities.getRowFirstNonWhite((BaseDocument)doc, (int)begin);
                                break;
                            }
                            begin = newBegin;
                        }
                        while (true) {
                            int newEnd;
                            if ((newEnd = Utilities.getRowEnd((BaseDocument)doc, (int)(end + 1))) >= length || !LexUtilities.isCommentOnlyLine(doc, newEnd)) break;
                            end = newEnd;
                        }
                        end = Utilities.getRowLastNonWhite((BaseDocument)doc, (int)end) + 1;
                        if (lineBegin > begin || lineEnd < end) {
                            ranges.add(new OffsetRange(begin, end));
                        }
                    } else {
                        TokenHierarchy th = TokenHierarchy.get((Document)doc);
                        int offset = token.offset(th);
                        ranges.add(new OffsetRange(offset, offset + token.length()));
                    }
                }
            }
            ListIterator<ASTNode> it = path.leafToRoot();
            OffsetRange previous = OffsetRange.NONE;
            while (it.hasNext()) {
                ASTNode node = (ASTNode)it.next();
                OffsetRange range = AstUtilities.getRange(node, doc);
                if (!range.containsInclusive(astOffset) || range.equals((Object)previous) || (range = LexUtilities.getLexerOffsets(gpr, range)) == OffsetRange.NONE) continue;
                if (range.getStart() < min) {
                    ranges.add(new OffsetRange(min, max));
                    ranges.add(new OffsetRange(0, length));
                    break;
                }
                ranges.add(range);
                previous = range;
            }
        }
        catch (BadLocationException ble) {
            Exceptions.printStackTrace((Throwable)ble);
            return ranges;
        }
        return ranges;
    }

    public int getNextWordOffset(Document document, int offset, boolean reverse) {
        BaseDocument doc = (BaseDocument)document;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getGroovyTokenSequence(doc, offset);
        if (ts == null) {
            return -1;
        }
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return -1;
        }
        if (reverse && ts.offset() == offset && !ts.movePrevious()) {
            return -1;
        }
        Token token = ts.token();
        TokenId id = token.id();
        if (id == GroovyTokenId.WHITESPACE) {
            int start;
            if (reverse && ts.offset() < offset || !reverse && ts.offset() > offset) {
                return ts.offset();
            }
            while (id == GroovyTokenId.WHITESPACE) {
                if (reverse && !ts.movePrevious()) {
                    return -1;
                }
                if (!reverse && !ts.moveNext()) {
                    return -1;
                }
                token = ts.token();
                id = token.id();
            }
            if (reverse ? (start = ts.offset() + token.length()) < offset : (start = ts.offset()) > offset) {
                return start;
            }
        }
        if (id == GroovyTokenId.IDENTIFIER || id == GroovyTokenId.CONSTANT || id == GroovyTokenId.GLOBAL_VAR) {
            char charAtI;
            int i;
            String s = ((Object)token.text()).toString();
            int length = s.length();
            int wordOffset = offset - ts.offset();
            if (reverse) {
                int offsetInImage = offset - 1 - ts.offset();
                if (offsetInImage < 0) {
                    return -1;
                }
                if (offsetInImage < length && Character.isUpperCase(s.charAt(offsetInImage))) {
                    for (int i2 = offsetInImage - 1; i2 >= 0; --i2) {
                        char charAtI2 = s.charAt(i2);
                        if (charAtI2 == '_') {
                            return ts.offset() + i2 + 1;
                        }
                        if (Character.isUpperCase(charAtI2)) continue;
                        return ts.offset() + i2 + 1;
                    }
                    return ts.offset();
                }
                for (int i3 = offsetInImage - 1; i3 >= 0; --i3) {
                    char charAtI3 = s.charAt(i3);
                    if (charAtI3 == '_') {
                        return ts.offset() + i3 + 1;
                    }
                    if (!Character.isUpperCase(charAtI3)) continue;
                    for (int j = i3; j >= 0; --j) {
                        char charAtJ = s.charAt(j);
                        if (charAtJ == '_') {
                            return ts.offset() + j + 1;
                        }
                        if (Character.isUpperCase(charAtJ)) continue;
                        return ts.offset() + j + 1;
                    }
                    return ts.offset();
                }
                return ts.offset();
            }
            int start = wordOffset + 1;
            if (wordOffset < 0 || wordOffset >= s.length()) {
                return -1;
            }
            if (Character.isUpperCase(s.charAt(wordOffset))) {
                for (i = start; i < length && Character.isUpperCase(charAtI = s.charAt(i)); ++i) {
                    if (s.charAt(i) == '_') {
                        return ts.offset() + i;
                    }
                    ++start;
                }
            }
            for (i = start; i < length; ++i) {
                charAtI = s.charAt(i);
                if (charAtI != '_' && !Character.isUpperCase(charAtI)) continue;
                return ts.offset() + i;
            }
        }
        return -1;
    }

    private static boolean moveSemicolon(BaseDocument doc, int dotPos, Caret caret) throws BadLocationException {
        int eolPos = Utilities.getRowEnd((BaseDocument)doc, (int)dotPos);
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getPositionedSequence(doc, dotPos);
        int lastParenPos = dotPos;
        while (ts.moveNext() && ts.offset() < eolPos) {
            Token token = ts.token();
            GroovyTokenId tokenId = (GroovyTokenId)token.id();
            if (tokenId == GroovyTokenId.RPAREN) {
                lastParenPos = ts.offset();
                continue;
            }
            if (tokenId == GroovyTokenId.WHITESPACE) continue;
            return false;
        }
        if (BracketCompleter.isForLoopSemicolon(ts) || BracketCompleter.posWithinAnyQuote(doc, dotPos)) {
            return false;
        }
        doc.remove(dotPos, 1);
        doc.insertString(lastParenPos, ";", null);
        caret.setDot(lastParenPos + 1);
        return true;
    }

    private static boolean isForLoopSemicolon(TokenSequence<? extends GroovyTokenId> ts) {
        Token token = ts.token();
        if (token == null || token.id() != GroovyTokenId.SEMI) {
            return false;
        }
        int parDepth = 0;
        int braceDepth = 0;
        boolean semicolonFound = false;
        Token token2 = token = ts.movePrevious() ? ts.token() : null;
        while (token != null) {
            if (token.id() == GroovyTokenId.LPAREN) {
                if (parDepth == 0) {
                    Token token3 = token = ts.movePrevious() ? ts.token() : null;
                    while (token != null && (token.id() == GroovyTokenId.WHITESPACE || token.id() == GroovyTokenId.BLOCK_COMMENT || token.id() == GroovyTokenId.LINE_COMMENT)) {
                        token = ts.movePrevious() ? ts.token() : null;
                    }
                    return token != null && token.id() == GroovyTokenId.LITERAL_for;
                }
                --parDepth;
            } else if (token.id() == GroovyTokenId.RPAREN) {
                ++parDepth;
            } else if (token.id() == GroovyTokenId.LBRACE) {
                if (braceDepth == 0) {
                    return false;
                }
                --braceDepth;
            } else if (token.id() == GroovyTokenId.RBRACE) {
                ++braceDepth;
            } else if (token.id() == GroovyTokenId.SEMI) {
                if (semicolonFound) {
                    return false;
                }
                semicolonFound = true;
            }
            token = ts.movePrevious() ? ts.token() : null;
        }
        return false;
    }

    private static boolean posWithinAnyQuote(BaseDocument doc, int dotPos) {
        Token token;
        TokenSequence<? extends GroovyTokenId> ts = LexUtilities.getPositionedSequence(doc, dotPos);
        return ts != null && (token = ts.token()) != null && token.id() == GroovyTokenId.STRING_LITERAL;
    }
}

