/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.classhierarchy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.navigation.classhierarchy.HierarchyNode;
import org.netbeans.modules.cnd.navigation.services.HierarchyModel;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

public class HierarchyChildren
extends Children.Keys<CsmClass> {
    private static Comparator<CsmClass> COMARATOR = new MyComparator();
    private CsmClass object;
    private HierarchyModel model;
    private HierarchyChildren parent;
    private boolean isInited = false;

    public HierarchyChildren(CsmClass object, HierarchyModel model, HierarchyChildren parent) {
        this.object = object;
        this.model = model;
        this.parent = parent;
    }

    public void dispose() {
        if (this.isInited) {
            this.isInited = false;
            this.setKeys(new CsmClass[0]);
        }
    }

    private synchronized void resetKeys() {
        Set<CsmClass> set;
        if (this.object.isValid() && (set = this.model.getModel().get(this.object)) != null && set.size() > 0) {
            ArrayList<CsmClass> list = new ArrayList<CsmClass>(set);
            Collections.sort(list, COMARATOR);
            this.setKeys(list);
            return;
        }
        this.setKeys(new CsmClass[0]);
    }

    protected Node[] createNodes(CsmClass cls) {
        HierarchyNode node = null;
        Set<CsmClass> set = this.model.getModel().get(cls);
        node = set == null || set.size() == 0 ? new HierarchyNode(cls, Children.LEAF, this.model, false) : (this.checkRecursion(cls) ? new HierarchyNode(cls, Children.LEAF, this.model, true) : new HierarchyNode(cls, this.model, this));
        return new Node[]{node};
    }

    private boolean checkRecursion(CsmClass cls) {
        if (cls.equals(this.object)) {
            return true;
        }
        HierarchyChildren arr = this.parent;
        while (arr != null) {
            if (cls.equals(arr.object)) {
                return true;
            }
            arr = arr.parent;
        }
        return false;
    }

    protected void addNotify() {
        this.isInited = true;
        this.resetKeys();
        super.addNotify();
    }

    protected void removeNotify() {
        super.removeNotify();
        this.dispose();
    }

    private static class MyComparator
    implements Comparator<CsmClass> {
        private MyComparator() {
        }

        @Override
        public int compare(CsmClass o1, CsmClass o2) {
            String n1 = ((Object)o1.getName()).toString();
            String n2 = ((Object)o2.getName()).toString();
            return n1.compareTo(n2);
        }
    }
}

