/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.iocontainer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.terminal.iocontainer.TerminalContainerCommon;
import org.openide.awt.TabbedPaneFactory;
import org.openide.windows.TopComponent;

public final class TerminalContainerTabbed
extends TerminalContainerCommon {
    private JTabbedPane tabbedPane;
    private JComponent soleComponent;

    public TerminalContainerTabbed(TopComponent owner, String originalName) {
        super(owner, originalName);
        this.initComponents();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.tabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.tabbedPane.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("close")) {
                    JComponent comp = (JComponent)evt.getNewValue();
                    TerminalContainerTabbed.this.remove(comp);
                }
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TerminalContainerTabbed.this.checkSelectionChange();
            }
        });
    }

    @Override
    protected boolean contains(JComponent comp) {
        return this.soleComponent == comp || this.tabbedPane.indexOfComponent(comp) != -1;
    }

    @Override
    protected void restoreAttrsFor(JComponent comp) {
        int index = this.tabbedPane.indexOfComponent(comp);
        if (index == -1) {
            return;
        }
        TerminalContainerCommon.Attributes attrs = this.attributesFor(comp);
        this.tabbedPane.setTitleAt(index, attrs.title);
        this.tabbedPane.setIconAt(index, attrs.icon);
        this.tabbedPane.setDisabledIconAt(index, attrs.icon);
        this.tabbedPane.setToolTipTextAt(index, attrs.toolTipText);
    }

    @Override
    protected final void addTabWork(JComponent comp) {
        if (this.soleComponent != null) {
            assert (this.tabbedPane.getParent() == null);
            assert (this.tabbedPane.getTabCount() == 0);
            this.componentRemove(this.soleComponent);
            super.add(this.tabbedPane);
            this.tabbedPane.add(this.soleComponent);
            this.restoreAttrsFor(this.soleComponent);
            this.soleComponent = null;
            this.updateWindowName(null);
            this.tabbedPane.add(comp);
            this.restoreAttrsFor(comp);
        } else if (this.tabbedPane.getTabCount() > 0) {
            assert (this.tabbedPane.getParent() != null);
            assert (this.soleComponent == null);
            this.tabbedPane.add(comp);
            this.restoreAttrsFor(comp);
        } else {
            assert (this.tabbedPane.getParent() == null);
            assert (this.soleComponent == null);
            this.setFocusable(false);
            this.soleComponent = comp;
            super.add(comp);
            this.updateWindowName(this.soleComponent.getName());
            this.checkSelectionChange();
        }
        this.revalidate();
    }

    @Override
    protected final void removeTabWork(JComponent comp) {
        if (this.soleComponent != null) {
            assert (this.soleComponent == comp);
            this.componentRemove(this.soleComponent);
            this.soleComponent = null;
            this.updateWindowName(null);
            this.checkSelectionChange();
            this.setFocusable(true);
            this.revalidate();
            this.repaint();
        } else if (this.tabbedPane.getParent() == this) {
            assert (this.tabbedPane.getTabCount() > 1);
            this.tabbedPane.remove(comp);
            if (this.tabbedPane.getTabCount() == 1) {
                this.soleComponent = (JComponent)this.tabbedPane.getComponentAt(0);
                this.tabbedPane.remove(this.soleComponent);
                this.componentRemove(this.tabbedPane);
                super.add(this.soleComponent);
                this.updateWindowName(this.soleComponent.getName());
            }
            this.checkSelectionChange();
            this.revalidate();
        }
    }

    @Override
    protected void selectLite(JComponent comp) {
        if (this.soleComponent == null) {
            this.tabbedPane.setSelectedComponent(comp);
        } else {
            this.checkSelectionChange();
        }
    }

    @Override
    public JComponent getSelected() {
        if (this.soleComponent != null) {
            return this.soleComponent;
        }
        return (JComponent)this.tabbedPane.getSelectedComponent();
    }

    @Override
    public void setTitleWork(JComponent comp, String title) {
        if (this.soleComponent != null) {
            assert (this.soleComponent == comp);
            this.updateWindowName(title);
        } else {
            assert (this.tabbedPane.getParent() == this);
            this.updateWindowName(null);
            this.restoreAttrsFor(comp);
        }
    }
}

