/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bookmarks;

import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.lib.editor.bookmarks.actions.ClearDocumentBookmarksAction;
import org.netbeans.lib.editor.bookmarks.actions.GotoBookmarkAction;
import org.netbeans.lib.editor.bookmarks.actions.ToggleBookmarkAction;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class WrapperBookmarkAction
extends NodeAction {
    static final long serialVersionUID = 0L;
    private Action originalAction;

    public WrapperBookmarkAction(Action originalAction) {
        this.originalAction = originalAction;
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        String name = (String)this.originalAction.getValue("ShortDescription");
        assert (name != null);
        return name;
    }

    public void performAction(Node[] activatedNodes) {
        JTextComponent editorPane = WrapperBookmarkAction.getEditorPane(activatedNodes);
        if (editorPane != null) {
            ActionEvent paneEvt = new ActionEvent(editorPane, 0, "");
            this.originalAction.actionPerformed(paneEvt);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (EditorRegistry.componentList().isEmpty()) {
            return false;
        }
        return activatedNodes[0].getLookup().lookup(EditorCookie.class) != null;
    }

    private static JTextComponent getEditorPane(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            HashSet<JTextComponent> editors = new HashSet<JTextComponent>();
            for (Node node : activatedNodes) {
                JTextComponent pane = ToggleBookmarkAction.findComponent(node.getLookup());
                if (pane == null) continue;
                editors.add(pane);
            }
            if (editors.size() == 1) {
                return (JTextComponent)editors.iterator().next();
            }
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected String iconResource() {
        return (String)this.originalAction.getValue("IconResource");
    }

    public static final class ClearDocumentBookmarks
    extends WrapperBookmarkAction {
        public ClearDocumentBookmarks() {
            super((Action)((Object)new ClearDocumentBookmarksAction()));
        }
    }

    public static final class Previous
    extends WrapperBookmarkAction {
        public Previous() {
            super((Action)((Object)GotoBookmarkAction.createPrevious()));
        }
    }

    public static final class Next
    extends WrapperBookmarkAction {
        public Next() {
            super((Action)((Object)GotoBookmarkAction.createNext()));
        }
    }
}

