/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FileTreeElement
implements TreeElement {
    private final FileObject fo;
    private final CsmUID<CsmProject> csmProject;
    private final Icon icon;

    FileTreeElement(FileObject fo, CsmFile csmFile) {
        this.fo = fo;
        ImageIcon readIcon = null;
        try {
            readIcon = new ImageIcon(DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1));
        }
        catch (DataObjectNotFoundException ex) {
            readIcon = null;
        }
        this.icon = readIcon;
        this.csmProject = CsmRefactoringUtils.getHandler(csmFile.getProject());
    }

    public TreeElement getParent(boolean isLogical) {
        CsmProject prj = (CsmProject)this.csmProject.getObject();
        if (prj == null) {
            return null;
        }
        return TreeElementFactory.getTreeElement((Object)prj);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getText(boolean isLogical) {
        return this.fo.getNameExt();
    }

    public Object getUserObject() {
        return this.fo;
    }
}

