/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.jsf.editor.JsfSupport;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;

public class FaceletsLibraryDescriptorCache {
    private final Map<String, FaceletsLibraryDescriptor> LIBRARIES = new HashMap<String, FaceletsLibraryDescriptor>();
    private JsfSupport support;

    public FaceletsLibraryDescriptorCache(JsfSupport jsfSupport) {
        this.support = jsfSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, FaceletsLibraryDescriptor> map = this.LIBRARIES;
        synchronized (map) {
            this.LIBRARIES.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaceletsLibraryDescriptor getLibrary(String string) throws LibraryDescriptorException {
        Map<String, FaceletsLibraryDescriptor> map = this.LIBRARIES;
        synchronized (map) {
            FaceletsLibraryDescriptor faceletsLibraryDescriptor = this.LIBRARIES.get(string);
            if (faceletsLibraryDescriptor == null) {
                FileObject fileObject = this.support.getIndex().getFaceletsLibaryDescriptorFile(string);
                if (fileObject != null) {
                    faceletsLibraryDescriptor = FaceletsLibraryDescriptor.create(fileObject);
                    this.LIBRARIES.put(string, faceletsLibraryDescriptor);
                } else {
                    return DefaultFaceletLibraries.getInstance().getLibrariesDescriptors().get(string);
                }
            }
            return faceletsLibraryDescriptor;
        }
    }

    private void dumpLibs() {
        System.out.println("Available Facelets Library Descriptors:");
        for (FaceletsLibraryDescriptor faceletsLibraryDescriptor : this.LIBRARIES.values()) {
            System.out.println(faceletsLibraryDescriptor.getDisplayName() + " (" + faceletsLibraryDescriptor.getURI() + "; " + (faceletsLibraryDescriptor.getDefinitionFile() != null ? faceletsLibraryDescriptor.getDefinitionFile().getPath() : "default library") + ")");
        }
    }
}

