/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components.databinding;

import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.codegen.InstanceNameResolver;
import org.netbeans.modules.vmd.midp.components.MidpDocumentSupport;
import org.netbeans.modules.vmd.midp.components.categories.DatabindingCategoryCD;
import org.netbeans.modules.vmd.midp.components.databinding.DataSetConnectorCD;
import org.netbeans.modules.vmd.midp.components.databinding.IndexableDataAbstractSetCD;
import org.netbeans.modules.vmd.midp.components.databinding.IndexableDataSetIndexCD;

public final class MidpDatabindingSupport {
    private MidpDatabindingSupport() {
    }

    public static DesignComponent getConnector(DesignComponent bindedComponent, String bindedPropertyName) {
        DesignComponent category = MidpDocumentSupport.getCategoryComponent(bindedComponent.getDocument(), DatabindingCategoryCD.TYPEID);
        for (DesignComponent dataSet : category.getComponents()) {
            for (DesignComponent component : dataSet.getComponents()) {
                if (component.getType() != DataSetConnectorCD.TYPEID) continue;
                String currentbindedPropertyName = (String)component.readProperty("property").getPrimitiveValue();
                Long id = (Long)component.readProperty("referencedComponent").getPrimitiveValue();
                if (!currentbindedPropertyName.equals(bindedPropertyName) || id == null || bindedComponent.getComponentID() != id.longValue()) continue;
                return component;
            }
        }
        return null;
    }

    public static Collection<DesignComponent> getAllRelatedConnectors(DesignComponent bindedComponent) {
        DesignComponent category = MidpDocumentSupport.getCategoryComponent(bindedComponent.getDocument(), DatabindingCategoryCD.TYPEID);
        HashSet<DesignComponent> connectors = new HashSet<DesignComponent>();
        for (DesignComponent dataSet : category.getComponents()) {
            for (DesignComponent component : dataSet.getComponents()) {
                Long id;
                if (component.getType() != DataSetConnectorCD.TYPEID || (id = (Long)component.readProperty("referencedComponent").getPrimitiveValue()) == null || bindedComponent.getComponentID() != id.longValue()) continue;
                connectors.add(component);
            }
        }
        return connectors;
    }

    public static Collection<DesignComponent> getAllConnectors(DesignDocument document) {
        DesignComponent category = MidpDocumentSupport.getCategoryComponent(document, DatabindingCategoryCD.TYPEID);
        HashSet<DesignComponent> connectors = new HashSet<DesignComponent>();
        for (DesignComponent dataSet : category.getComponents()) {
            for (DesignComponent component : dataSet.getComponents()) {
                if (component.getType() != DataSetConnectorCD.TYPEID) continue;
                connectors.add(component);
            }
        }
        return connectors;
    }

    public static String getDatabaindingAsText(final DesignComponent component, final String propertyName) {
        if (component != null) {
            final boolean[] isConnector = new boolean[1];
            component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    if (MidpDatabindingSupport.getConnector(component, propertyName) != null) {
                        isConnector[0] = true;
                    }
                }
            });
            if (isConnector[0]) {
                return "<databinding>";
            }
        }
        return null;
    }

    public static Collection<DesignComponent> getIndexes(DesignComponent indexableDataSet) {
        HashSet<DesignComponent> indexes = new HashSet<DesignComponent>();
        for (DesignComponent component : indexableDataSet.getComponents()) {
            if (component.getType() != IndexableDataSetIndexCD.TYPEID) continue;
            indexes.add(component);
        }
        return indexes;
    }

    public static DesignComponent getIndex(DesignComponent indexableDataSet, String instanceName) {
        for (DesignComponent component : indexableDataSet.getComponents()) {
            if (component.getType() != IndexableDataSetIndexCD.TYPEID || !component.readProperty("instanceName").getPrimitiveValue().equals(instanceName)) continue;
            return component;
        }
        return null;
    }

    public static DesignComponent createIndex(DesignComponent indexableDataSet, String instanceName) {
        DesignComponent index = indexableDataSet.getDocument().createComponent(IndexableDataSetIndexCD.TYPEID);
        index.writeProperty("instanceName", InstanceNameResolver.createFromSuggested(index, instanceName));
        indexableDataSet.addComponent(index);
        return index;
    }

    public static void removerUnusedIndexes(DesignDocument document) {
        assert (document != null);
        Collection<DesignComponent> connectors = MidpDatabindingSupport.getAllConnectors(document);
        Collection dataSets = MidpDocumentSupport.getCategoryComponent(document, DatabindingCategoryCD.TYPEID).getComponents();
        HashSet<DesignComponent> indexes = new HashSet<DesignComponent>();
        for (DesignComponent dataSet : dataSets) {
            if (!MidpDatabindingSupport.isIndexableDataSet(document, dataSet.getType())) continue;
            indexes.addAll(MidpDatabindingSupport.getIndexes(dataSet));
        }
        for (DesignComponent connector : connectors) {
            DesignComponent index = connector.readProperty("index").getComponent();
            if (index == null) {
                return;
            }
            indexes.remove(index);
        }
        for (DesignComponent indexToRemove : indexes) {
            document.deleteComponent(indexToRemove);
        }
    }

    public static String getIndexName(DesignComponent connector) {
        DesignComponent index = connector.readProperty("index").getComponent();
        String name = null;
        if (index != null) {
            name = (String)index.readProperty("instanceName").getPrimitiveValue();
        }
        return name;
    }

    public static boolean isIndexableDataSet(DesignDocument document, TypeID typeID) {
        DescriptorRegistry registry = document.getDescriptorRegistry();
        return registry.isInHierarchy(IndexableDataAbstractSetCD.TYPEID, typeID);
    }

    public static synchronized void removeUnusedConnector(DesignComponent component, String propertyName) {
        DesignComponent connector = MidpDatabindingSupport.getConnector(component, propertyName);
        if (connector != null) {
            component.getDocument().deleteComponent(connector);
        }
    }
}

