/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.codegen;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeNamePresenter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.common.ValidatorPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public final class InstanceNameResolver {
    private InstanceNameResolver() {
    }

    public static PropertyValue createFromSuggested(DesignComponent component, String suggestedMainName) {
        return InstanceNameResolver.createFromSuggested(component, suggestedMainName, null);
    }

    public static PropertyValue createFromSuggested(DesignComponent component, String suggestedMainName, Collection<String> additionalReservedNames) {
        assert (component.getDocument().getTransactionManager().isAccess());
        Collection presenters = component.getPresenters(CodeNamePresenter.class);
        if (presenters.isEmpty()) {
            Debug.warning((Object[])new Object[]{"CodeNamePresenter is missing for", component});
        }
        HashSet<String> names = new HashSet<String>();
        InstanceNameResolver.gatherNames(component.getDocument().getRootComponent(), component, names);
        if (additionalReservedNames != null) {
            names.addAll(additionalReservedNames);
        }
        if (InstanceNameResolver.checkIfNameAlreadyReserved(presenters, suggestedMainName = InstanceNameResolver.checkForJavaIdentifierCompliant(suggestedMainName), names)) {
            int index;
            for (index = suggestedMainName.length(); index >= 1 && Character.isDigit(suggestedMainName.charAt(index - 1)); --index) {
            }
            int number = index < suggestedMainName.length() ? Integer.parseInt(suggestedMainName.substring(index)) : 1;
            suggestedMainName = suggestedMainName.substring(0, index);
            suggestedMainName = InstanceNameResolver.findNumberedInstanceName(presenters, suggestedMainName, number, names);
        }
        return MidpTypes.createStringValue(suggestedMainName);
    }

    private static String findNumberedInstanceName(Collection<? extends CodeNamePresenter> presenters, String suggestedMainName, int number, HashSet<String> names) {
        String testName;
        while (InstanceNameResolver.checkIfNameAlreadyReserved(presenters, testName = suggestedMainName + number, names)) {
            ++number;
        }
        return testName;
    }

    private static boolean checkIfNameAlreadyReserved(Collection<? extends CodeNamePresenter> presenters, String suggestedMainName, HashSet<String> names) {
        for (CodeNamePresenter codeNamePresenter : presenters) {
            List reservedNamesFor = codeNamePresenter.getReservedNamesFor(suggestedMainName);
            if (reservedNamesFor == null) continue;
            for (String name : reservedNamesFor) {
                if (!names.contains(name)) continue;
                return true;
            }
        }
        return false;
    }

    private static String checkForJavaIdentifierCompliant(String instanceName) {
        if (instanceName == null || instanceName.length() < 1) {
            return "object";
        }
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        if (Character.isJavaIdentifierStart(instanceName.charAt(0))) {
            buffer.append(instanceName.charAt(0));
            ++index;
        } else {
            buffer.append('a');
        }
        while (index < instanceName.length()) {
            char c = instanceName.charAt(index);
            if (Character.isJavaIdentifierPart(c)) {
                buffer.append(c);
            }
            ++index;
        }
        return buffer.toString();
    }

    private static void gatherNames(DesignComponent component, DesignComponent excludeComponent, HashSet<String> names) {
        assert (component.getDocument().getTransactionManager().isAccess());
        if (component == excludeComponent) {
            return;
        }
        Collection presenters = component.getPresenters(CodeNamePresenter.class);
        for (CodeNamePresenter presenter : presenters) {
            List reservedNames = presenter.getReservedNames();
            if (reservedNames == null) continue;
            names.addAll(reservedNames);
        }
        for (DesignComponent child : component.getComponents()) {
            InstanceNameResolver.gatherNames(child, excludeComponent, names);
        }
    }

    public static Presenter createValidatorPresenter() {
        return new ValidatorPresenter(){

            protected void checkCustomValidity() {
                InstanceNameResolver.checkValidity(this.getComponent().getDocument());
            }
        };
    }

    private static void checkValidity(DesignDocument document) {
    }
}

