/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.deployment.wm;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.netbeans.mobility.activesync.ActiveSyncException;
import org.netbeans.mobility.activesync.ActiveSyncOps;
import org.netbeans.mobility.activesync.DeviceConnectedListener;
import org.netbeans.mobility.activesync.RemoteFile;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOp;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

final class RemoteFilesystemChooser
extends JPanel
implements ExplorerManager.Provider {
    private static String currentFolder;
    private String selectedFolder;
    private static boolean foldersOnly;
    private ExplorerManager em;
    private static final ImageIcon CDC_PROJECT_ICON;
    private static final String FOLDER_ICON_BASE = "org/openide/loaders/defaultFolder";
    private PropertyChangeListener pcl = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("selectedNodes".equals(evt.getPropertyName())) {
                if (RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes().length == 1) {
                    RemoteFile remote = (RemoteFile)RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes()[0].getLookup().lookup(RemoteFile.class);
                    if (remote == null) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    if (foldersOnly && !remote.isDirectory()) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    if (!foldersOnly && remote.isDirectory()) {
                        RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                        return;
                    }
                    String[] path = NodeOp.createPath((Node)RemoteFilesystemChooser.this.getExplorerManager().getSelectedNodes()[0], (Node)RemoteFilesystemChooser.this.getExplorerManager().getRootContext());
                    StringBuffer sb = new StringBuffer("\\");
                    for (int i = 0; i < path.length; ++i) {
                        sb.append(path[i]);
                        if (i + 1 >= path.length) continue;
                        sb.append("\\");
                    }
                    RemoteFilesystemChooser.this.selectedFolder = sb.toString();
                    RemoteFilesystemChooser.this.firePropertyChange("valid", false, true);
                } else {
                    RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
                }
            }
        }
    };
    private ConnectionListener connectionListener;
    private static Comparator REMOTE_FILE_COMPARATOR;

    public RemoteFilesystemChooser(String curentFolder, boolean foldersOnly) {
        RemoteFilesystemChooser.foldersOnly = foldersOnly;
        this.selectedFolder = curentFolder;
        this.setPreferredSize(new Dimension(400, 500));
        this.setLayout(new BorderLayout());
        try {
            if (ActiveSyncOps.isAvailable()) {
                if (!ActiveSyncOps.getDefault().isDeviceConnected()) {
                    this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_DeviceDisconnected"));
                } else {
                    this.createView(null);
                }
            } else {
                this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyntNotInstalled"));
            }
        }
        catch (ActiveSyncException ex) {
            this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyncGeneralError"));
        }
    }

    public ExplorerManager getExplorerManager() {
        if (this.em == null) {
            this.em = new ExplorerManager();
        }
        return this.em;
    }

    public String getSelectedFile() {
        return this.selectedFolder;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        try {
            if (ActiveSyncOps.getDefault() != null) {
                this.connectionListener = new ConnectionListener();
                ActiveSyncOps.getDefault().addConnectionListener((DeviceConnectedListener)this.connectionListener);
            }
        }
        catch (ActiveSyncException activeSyncException) {
            // empty catch block
        }
    }

    @Override
    public void removeNotify() {
        try {
            if (ActiveSyncOps.getDefault() != null) {
                ActiveSyncOps.getDefault().removeConnectionListener((DeviceConnectedListener)this.connectionListener);
            }
        }
        catch (ActiveSyncException activeSyncException) {
            // empty catch block
        }
        super.removeNotify();
    }

    private void createView(final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            if (message == null) {
                this.createFileView();
            } else {
                this.createErrorView(message);
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteFilesystemChooser.this.createView(message);
                }
            });
        }
    }

    private void createFileView() {
        this.setVisible(false);
        this.removeAll();
        BeanTreeView btw = new BeanTreeView();
        btw.setBorder((Border)new LineBorder(Color.BLACK, 1, true));
        this.add((Component)btw, "Center");
        try {
            this.getExplorerManager().setRootContext((Node)new AbstractNode((Children)new RemoteFileSystemChildren(ActiveSyncOps.getDefault().getRootFilesystems()[0])){

                public String getName() {
                    return "\\";
                }

                public Image getIcon(int type) {
                    return CDC_PROJECT_ICON.getImage();
                }

                public Image getOpenedIcon(int i) {
                    return this.getIcon(i);
                }
            });
        }
        catch (ActiveSyncException ex) {
            this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_ActiveSyncGeneralError"));
        }
        this.getExplorerManager().addPropertyChangeListener(this.pcl);
        this.invalidate();
        this.setVisible(true);
    }

    private void createErrorView(String error) {
        this.setVisible(false);
        this.removeAll();
        this.getExplorerManager().removePropertyChangeListener(this.pcl);
        try {
            this.getExplorerManager().setRootContext((Node)new AbstractNode(Children.LEAF));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.firePropertyChange("valid", true, false);
        JLabel errorLabel = new JLabel(error);
        errorLabel.setHorizontalAlignment(0);
        this.add((Component)errorLabel, "Center");
        this.invalidate();
        this.setVisible(true);
    }

    static {
        CDC_PROJECT_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/deployment/wm/resources/cdcProject.png", (boolean)false);
        REMOTE_FILE_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                RemoteFile rf1 = (RemoteFile)o1;
                RemoteFile rf2 = (RemoteFile)o2;
                if (rf1.isDirectory() && rf2.isDirectory() || !rf1.isDirectory() && !rf2.isDirectory()) {
                    return rf1.getName().compareTo(rf2.getName());
                }
                return !rf1.isDirectory() && rf2.isDirectory() ? 1 : -1;
            }
        };
    }

    private class ConnectionListener
    implements DeviceConnectedListener {
        private ConnectionListener() {
        }

        public void onDeviceConnected(boolean connected) {
            if (connected) {
                RemoteFilesystemChooser.this.createView(null);
            } else {
                RemoteFilesystemChooser.this.createView(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"ERROR_DeviceDisconnected"));
                RemoteFilesystemChooser.this.firePropertyChange("valid", true, false);
            }
        }
    }

    private static class RemoteFileSystemChildren
    extends Children.Keys {
        private RemoteFile folder;

        RemoteFileSystemChildren(RemoteFile folder) {
            this.folder = folder;
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof RemoteFile) {
                try {
                    RemoteFile file = (RemoteFile)object;
                    if (foldersOnly && !file.isDirectory()) {
                        return new AbstractNode[0];
                    }
                    return new AbstractNode[]{file.isDirectory() ? new RemoteFileSystemNode(file, (Children)new RemoteFileSystemChildren(file)) : new RemoteFileSystemNode(file, Children.LEAF)};
                }
                catch (Exception ex) {
                    return new AbstractNode[0];
                }
            }
            AbstractNode waitNode = new AbstractNode(Children.LEAF);
            waitNode.setName(NbBundle.getMessage(RemoteFilesystemChooser.class, (String)"NodeWait"));
            return new Node[]{waitNode};
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(new Object[]{new Object()});
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ActiveSyncOps activeSync = ActiveSyncOps.getDefault();
                        Object[] files = activeSync.listFiles(RemoteFileSystemChildren.this.folder);
                        Arrays.sort(files, REMOTE_FILE_COMPARATOR);
                        RemoteFileSystemChildren.this.setKeys(files);
                    }
                    catch (ActiveSyncException activeSyncException) {
                        // empty catch block
                    }
                }
            });
        }

        protected void removeNotify() {
            super.removeNotify();
            this.setKeys(Collections.EMPTY_LIST);
        }
    }

    private static class RemoteFileSystemNode
    extends AbstractNode {
        private RemoteFile file;

        RemoteFileSystemNode(RemoteFile file, Children children) {
            super(children, Lookups.singleton((Object)file));
            this.file = file;
            this.setIconBase(RemoteFilesystemChooser.FOLDER_ICON_BASE);
        }

        public String getName() {
            return this.file.getName();
        }

        public Image getIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.icon");
            }
            if (img == null) {
                img = super.getIcon(type);
            }
            return img;
        }

        public Image getOpenedIcon(int type) {
            Image img = null;
            if (type == 1) {
                img = (Image)UIManager.get("Nb.Explorer.Folder.openedIcon");
            }
            if (img == null) {
                img = super.getOpenedIcon(type);
            }
            return img;
        }
    }
}

