/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.elements.IndexedElement;
import org.netbeans.modules.ruby.elements.MethodElement;
import org.openide.filesystems.FileObject;

public final class IndexedMethod
extends IndexedElement
implements MethodElement {
    public static final int BLOCK = 64;
    public static final int BLOCK_OPTIONAL = 128;
    protected final String signature;
    private String[] args;
    private String name;
    private List<String> parameters;
    private boolean smart;
    private boolean inherited;
    private boolean statik;
    private MethodType methodType = MethodType.METHOD;

    private IndexedMethod(String signature, RubyIndex index, FileObject file, String fqn, String clz, String require, String attributes, int flags, FileObject context) {
        super(index, file, fqn, clz, require, attributes, flags, context, null);
        this.signature = signature;
    }

    public static IndexedMethod create(RubyIndex index, String signature, String fqn, String clz, FileObject file, String require, String attributes, int flags, FileObject context) {
        return new IndexedMethod(signature, index, file, fqn, clz, require, attributes, flags, context);
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public void setMethodType(MethodType methodType) {
        this.methodType = methodType;
    }

    @Override
    public String toString() {
        return this.getSignature();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            int parenIndex = this.signature.indexOf(40);
            this.name = parenIndex == -1 ? this.signature : this.signature.substring(0, parenIndex);
        }
        return this.name;
    }

    @Override
    public String getSignature() {
        return this.fqn + "#" + this.signature;
    }

    public String[] getArgs() {
        if (this.args == null) {
            int parenIndex = this.signature.indexOf(40);
            if (parenIndex == -1) {
                return new String[0];
            }
            String argsPortion = this.signature.substring(parenIndex + 1, this.signature.length() - 1);
            this.args = argsPortion.split(",");
        }
        return this.args;
    }

    @Override
    public List<String> getParameters() {
        if (this.parameters == null) {
            String[] argArray = this.getArgs();
            if (argArray != null && argArray.length > 0) {
                this.parameters = new ArrayList<String>(argArray.length);
                for (String arg : argArray) {
                    this.parameters.add(arg);
                }
            } else {
                this.parameters = Collections.emptyList();
            }
        }
        return this.parameters;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public ElementKind getKind() {
        if (this.name == null && this.signature.startsWith("initialize(") || this.name != null && this.name.equals("initialize")) {
            return ElementKind.CONSTRUCTOR;
        }
        return ElementKind.METHOD;
    }

    public boolean isSmart() {
        return this.smart;
    }

    public void setSmart(boolean smart) {
        this.smart = smart;
    }

    public void setType(RubyType type) {
        this.type = type;
    }

    public void setStatic(boolean statik) {
        this.statik = statik;
    }

    @Override
    public boolean isStatic() {
        return this.statik || super.isStatic();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexedMethod other = (IndexedMethod)obj;
        if (!(this.signature == other.signature || this.signature != null && this.signature.equals(other.signature))) {
            return false;
        }
        if (!(this.fqn == other.fqn || this.fqn != null && this.fqn.equals(other.fqn))) {
            return false;
        }
        return this.flags == other.flags;
    }

    public int hashCode() {
        int hash = 7;
        hash = 53 * hash + (this.signature != null ? this.signature.hashCode() : 0);
        hash = 53 * hash + (this.fqn != null ? this.fqn.hashCode() : 0);
        hash = 53 * hash + this.flags;
        return hash;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    public void setInherited(boolean inherited) {
        this.inherited = inherited;
    }

    public boolean hasBlock() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isBlockOptional() {
        return (this.flags & 0x80) != 0;
    }

    public static String decodeFlags(int flags) {
        StringBuilder sb = new StringBuilder();
        sb.append(IndexedElement.decodeFlags(flags));
        if ((flags & 0x40) != 0) {
            sb.append("|BLOCK");
        }
        if ((flags & 0x80) != 0) {
            sb.append("|BLOCK_OPTIONAL");
        }
        if (sb.length() > 0) {
            sb.append("|");
        }
        return sb.toString();
    }

    public static int stringToFlags(String string) {
        int flags = IndexedElement.stringToFlags(string);
        int blockIndex = string.indexOf("|BLOCK_OPTIONAL");
        if (blockIndex != -1) {
            flags += 128;
            if (string.indexOf("|BLOCK") != blockIndex || string.lastIndexOf("|BLOCK") != blockIndex) {
                flags += 64;
            }
        } else if (string.indexOf("|BLOCK") != -1) {
            flags += 64;
        }
        return flags;
    }

    public String getEncodedAttributes() {
        return this.attributes;
    }

    public static enum MethodType {
        METHOD,
        ATTRIBUTE,
        DBCOLUMN,
        DYNAMIC_FINDER;

    }
}

