/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.PropertiesDataNode;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public final class Util {
    public static final String HELP_ID_PROPERTIES = "propfiles.prop";
    public static final String HELP_ID_CREATING = "propfiles.creating";
    public static final String HELP_ID_ADDING = "propfiles.adding";
    public static final String HELP_ID_MODIFYING = "propfiles.modifying";
    public static final String HELP_ID_ADDLOCALE = "propfiles.addlocale";
    public static final String HELP_ID_EDITLOCALE = "propfiles.editlocale";
    public static final char PRB_SEPARATOR_CHAR = '_';
    public static final int LABEL_FIRST_PART_LENGTH = 10;

    public static String stringToKey(String source) {
        StringBuffer result = new StringBuffer();
        block3: for (int i = 0; i < source.length(); ++i) {
            char x = source.charAt(i);
            switch (x) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case ':': 
                case '=': {
                    result.append('_');
                    continue block3;
                }
                default: {
                    result.append(x);
                }
            }
        }
        return result.toString();
    }

    public static String assembleName(String baseName, String lang) {
        if (lang.length() == 0) {
            return baseName;
        }
        if (lang.charAt(0) != '_') {
            StringBuffer res = new StringBuffer().append(baseName).append('_').append(lang);
            return res.toString();
        }
        return baseName + lang;
    }

    public static String getLocaleSuffix(MultiDataObject.Entry fe) {
        String baseName;
        FileObject fo = fe.getFile();
        String fName = fo.getName();
        if (fName.equals(baseName = Util.getBaseName(fName))) {
            return "";
        }
        return fName.substring(baseName.length());
    }

    private static boolean isValidLocaleSuffix(String s) {
        HashSet<String> knownCountries;
        String s2;
        int n = s.length();
        if (n != 3 && (n <= 3 || s.charAt(3) != '_')) {
            return false;
        }
        String s1 = s.substring(1, 3).toLowerCase();
        if (n == 3) {
            s2 = null;
        } else if (n == 6 || n > 6 && s.charAt(6) == '_') {
            s2 = s.substring(4, 6).toUpperCase();
        } else {
            return false;
        }
        HashSet<String> knownLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        if (!knownLanguages.contains(s1)) {
            return false;
        }
        return s2 == null || (knownCountries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()))).contains(s2);
    }

    public static String getLanguage(String localeSuffix) {
        return Util.getFirstPart(localeSuffix);
    }

    public static String getCountry(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        int start = localeSuffix.indexOf(95, 1);
        return start != -1 ? Util.getFirstPart(localeSuffix.substring(start)) : "";
    }

    public static String getVariant(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        int start = localeSuffix.indexOf(95, 1);
        if (start == -1) {
            return "";
        }
        return (start = localeSuffix.indexOf(95, start + 1)) != -1 ? localeSuffix.substring(start + 1) : "";
    }

    private static String getFirstPart(String localeSuffix) {
        if (localeSuffix.length() == 0) {
            return null;
        }
        assert (localeSuffix.charAt(0) == '_');
        int end = localeSuffix.indexOf(95, 1);
        return end != -1 ? localeSuffix.substring(1, end) : localeSuffix.substring(1);
    }

    public static String getLocaleLabel(MultiDataObject.Entry fe) {
        String variantName;
        String langName;
        String variant;
        String country;
        String language;
        String localeSuffix = Util.getLocaleSuffix(fe);
        if (localeSuffix.length() == 0) {
            language = "";
            country = "";
            variant = "";
        } else {
            language = Util.getLanguage(localeSuffix);
            country = Util.getCountry(localeSuffix);
            variant = Util.getVariant(localeSuffix);
            language = language.length() != 0 ? language : "";
            country = country.length() != 0 ? country : "";
            variant = variant.length() != 0 ? variant : "";
        }
        String defaultLangName = null;
        if (language == "") {
            defaultLangName = NbBundle.getMessage(Util.class, (String)"LAB_defaultLanguage");
        }
        if (language == "" && country == "" && variant == "") {
            return defaultLangName;
        }
        String localeSpec = localeSuffix.substring(1);
        Locale locale = new Locale(language, country, variant);
        if (language == "") {
            langName = defaultLangName;
        } else {
            langName = locale.getDisplayLanguage();
            if (langName.equals(language)) {
                langName = NbBundle.getMessage(Util.class, (String)"LAB_unknownLanguage", (Object)language);
            }
        }
        if (country == "" && variant == "") {
            return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLang", (Object)localeSpec, (Object)langName);
        }
        String countryName = "";
        if (country != "" && (countryName = locale.getDisplayCountry()).equals(country)) {
            countryName = NbBundle.getMessage(Util.class, (String)"LAB_unknownCountry", (Object)country);
        }
        String string = variantName = variant == "" ? "" : locale.getDisplayVariant();
        String countryAndVariant = variantName == "" ? countryName : (countryName == "" ? variantName : countryName + ", " + variantName);
        return NbBundle.getMessage(Util.class, (String)"LAB_localeSpecLangCountry", (Object)localeSpec, (Object)langName, (Object)countryAndVariant);
    }

    private static void notifyError(String locale) {
        NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)MessageFormat.format(NbBundle.getBundle(PropertiesDataNode.class).getString("MSG_LangExists"), locale), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
    }

    public static PropertiesDataObject createPropertiesDataObject(FileObject folder, String fileName) throws IOException {
        int idx = fileName.lastIndexOf(47);
        if (idx > 0) {
            String folderPath = fileName.substring(0, idx);
            folder = FileUtil.createFolder((FileObject)folder, (String)folderPath);
            fileName = fileName.substring(idx + 1);
        }
        FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
        FileObject templateFO = defaultFS.findResource("Templates/Other/properties.properties");
        DataObject template = DataObject.find((FileObject)templateFO);
        return (PropertiesDataObject)template.createFromTemplate(DataFolder.findFolder((FileObject)folder), fileName);
    }

    public static void createLocaleFile(PropertiesDataObject propertiesDataObject, String locale, boolean copyInitialContent) {
        try {
            if (locale.length() == 0) {
                Util.notifyError(locale);
                return;
            }
            if (propertiesDataObject != null) {
                String extension;
                FileObject file = propertiesDataObject.getBundleStructure().getNthEntry(0).getFile();
                if (!file.hasExt(extension = "properties") && file.getMIMEType().equalsIgnoreCase("text/x-properties")) {
                    extension = file.getExt();
                }
                final String newName = Util.getBaseName(file.getName()) + '_' + locale;
                final FileObject folder = file.getParent();
                Iterator it = propertiesDataObject.secondaryEntries().iterator();
                while (it.hasNext()) {
                    FileObject f = ((FileEntry)it.next()).getFile();
                    if (!newName.startsWith(f.getName()) || f.getName().length() <= file.getName().length()) continue;
                    file = f;
                }
                if (file.getName().equals(newName)) {
                    return;
                }
                if (copyInitialContent) {
                    if (folder.getFileObject(newName, extension) == null) {
                        SaveCookie save = (SaveCookie)propertiesDataObject.getCookie(SaveCookie.class);
                        if (save != null) {
                            save.save();
                        }
                        final FileObject templateFile = file;
                        final String ext = extension;
                        folder.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                            public void run() throws IOException {
                                templateFile.copy(folder, newName, ext);
                            }
                        });
                        PropertiesDataObject dataObject = (PropertiesDataObject)DataObject.find((FileObject)folder.getFileObject(newName, extension));
                        dataObject.setBundleStructure(propertiesDataObject.getBundleStructure());
                        propertiesDataObject.getBundleStructure().updateEntries();
                        propertiesDataObject.getOpenSupport().addDataObject(dataObject);
                        propertiesDataObject.getBundleStructure().notifyOneFileChanged(folder.getFileObject(newName, extension));
                    }
                } else {
                    DataObject.find((FileObject)folder.createData(newName, extension));
                    propertiesDataObject.getBundleStructure().updateEntries();
                }
            }
        }
        catch (IOException ioe) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                ioe.printStackTrace();
            }
            Util.notifyError(locale);
        }
    }

    static PropertiesDataObject findPrimaryDataObject(PropertiesDataObject obj) throws DataObjectNotFoundException {
        FileObject primary = obj.getPrimaryFile();
        assert (primary != null) : "Object " + (Object)((Object)obj) + " cannot have null primary file";
        String fName = primary.getName();
        String baseName = Util.getBaseName(fName);
        FileObject parent = primary.getParent();
        int index = fName.indexOf(95);
        while (index != -1) {
            FileObject candidate = parent.getFileObject(fName.substring(0, index), primary.getExt());
            if (candidate != null && Util.isValidLocaleSuffix(fName.substring(index))) {
                return (PropertiesDataObject)DataObject.find((FileObject)candidate);
            }
            if (candidate == null) {
                for (FileObject file : parent.getChildren()) {
                    if (!file.hasExt("properties") || file.getName().indexOf(baseName) == -1 || !Util.isValidLocaleSuffix(file.getName().substring(index))) continue;
                    return (PropertiesDataObject)DataObject.find((FileObject)file);
                }
            }
            index = fName.indexOf(95, index + 1);
        }
        return obj;
    }

    static BundleStructure findBundleStructure(FileObject f, FileObject parent, String baseName) throws DataObjectNotFoundException {
        PropertiesDataObject dataObject = null;
        String extension = "properties";
        if (!f.hasExt(extension) && f.getMIMEType().equalsIgnoreCase("text/x-properties")) {
            extension = f.getExt();
        }
        for (FileObject file : parent.getChildren()) {
            BundleStructure structure;
            if (!file.hasExt(extension) || file.equals(f)) continue;
            String fName = file.getName();
            if (fName.equals(baseName) && file.isValid()) {
                dataObject = (PropertiesDataObject)DataObject.find((FileObject)file);
                if (dataObject == null || (structure = dataObject.getBundleStructureOrNull()) == null) continue;
                return structure;
            }
            if (fName.indexOf(baseName) == -1) continue;
            int index = fName.indexOf(95);
            if (baseName.length() != index) continue;
            while (index != -1) {
                FileObject candidate = file;
                if (candidate != null && Util.isValidLocaleSuffix(fName.substring(index)) && file.isValid()) {
                    DataObject defaultDataObject = DataObject.find((FileObject)candidate);
                    if (defaultDataObject instanceof PropertiesDataObject) {
                        dataObject = (PropertiesDataObject)DataObject.find((FileObject)candidate);
                    } else {
                        index = -1;
                    }
                    if (dataObject == null) continue;
                    structure = dataObject.getBundleStructureOrNull();
                    if (structure != null) {
                        return structure;
                    }
                }
                index = fName.indexOf(95, index + 1);
            }
        }
        return null;
    }

    static String getBaseName(String name) {
        String baseName = null;
        int index = name.indexOf(95);
        while (index != -1) {
            baseName = name.substring(0, index);
            if (baseName != null && Util.isValidLocaleSuffix(name.substring(index))) {
                return baseName;
            }
            index = name.indexOf(95, index + 1);
        }
        return name;
    }
}

