/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.nativeexecution.ConnectionManagerAccessor;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.PasswordManager;
import org.netbeans.modules.nativeexecution.api.util.ValidateablePanel;
import org.netbeans.modules.nativeexecution.support.Authentication;
import org.netbeans.modules.nativeexecution.support.SSHKeyFileChooser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AuthenticationSettingsPanel
extends ValidateablePanel {
    private final ExecutionEnvironment env;
    private final RequestProcessor.Task validationTask;
    private String problem;
    private final Authentication auth;
    private JPanel authPanel;
    private ButtonGroup buttonGroup1;
    private JButton keyBrowseButton;
    private JTextField keyFld;
    private JRadioButton keyRadioButton;
    private JLabel loginLabel;
    private JPanel loginPanel;
    private JButton pwdClearButton;
    private JRadioButton pwdRadioButton;
    private JLabel pwdStoredLbl;

    public AuthenticationSettingsPanel(Authentication auth, boolean showClearPwdButton) {
        this.env = auth.getEnv();
        this.auth = auth;
        this.initComponents();
        this.pwdClearButton.setVisible(showClearPwdButton);
        this.pwdStoredLbl.setVisible(showClearPwdButton);
        if (this.env != null) {
            this.loginLabel.setText(this.env.getUser() + "@" + this.env.getHost() + (this.env.getSSHPort() == 22 ? "" : Integer.valueOf(this.env.getSSHPort())));
        } else {
            this.loginPanel.setVisible(false);
        }
        if (auth.getType() == Authentication.Type.SSH_KEY) {
            this.keyRadioButton.setSelected(true);
            this.pwdRadioButton.setSelected(false);
        } else {
            this.keyRadioButton.setSelected(false);
            this.pwdRadioButton.setSelected(true);
        }
        this.keyFld.setText(auth.getKey());
        if (this.env != null) {
            boolean stored = PasswordManager.getInstance().isRememberPassword(this.env);
            this.pwdClearButton.setEnabled(stored);
            this.pwdStoredLbl.setVisible(stored);
        }
        this.validationTask = new RequestProcessor("", 1).create((Runnable)new ValidationTask(), true);
        this.keyFld.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AuthenticationSettingsPanel.this.validationTask.schedule(0);
            }
        });
        this.enableControls();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.pwdRadioButton.setEnabled(enabled);
        this.keyRadioButton.setEnabled(enabled);
        if (this.keyRadioButton.isSelected()) {
            this.keyFld.setEnabled(enabled);
            this.keyBrowseButton.setEnabled(enabled);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.loginPanel = new JPanel();
        this.loginLabel = new JLabel();
        this.authPanel = new JPanel();
        this.pwdRadioButton = new JRadioButton();
        this.pwdStoredLbl = new JLabel();
        this.pwdClearButton = new JButton();
        this.keyRadioButton = new JRadioButton();
        this.keyFld = new JTextField();
        this.keyBrowseButton = new JButton();
        this.loginPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.loginPanel.border.title")));
        this.loginLabel.setText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.loginLabel.text"));
        GroupLayout loginPanelLayout = new GroupLayout(this.loginPanel);
        this.loginPanel.setLayout(loginPanelLayout);
        loginPanelLayout.setHorizontalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.loginLabel).addContainerGap(285, Short.MAX_VALUE)));
        loginPanelLayout.setVerticalGroup(loginPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(loginPanelLayout.createSequentialGroup().addComponent(this.loginLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.authPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.authPanel.border.title")));
        this.buttonGroup1.add(this.pwdRadioButton);
        this.pwdRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.pwdRadioButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdRadioButton.text"));
        this.pwdRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.pwdRadioButtonActionPerformed(evt);
            }
        });
        this.pwdStoredLbl.setText(NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdStoredLbl.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.pwdClearButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.pwdClearButton.text_1"));
        this.pwdClearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.pwdClearButtonActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.keyRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.keyRadioButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.keyRadioButton.text"));
        this.keyRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.keyRadioButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.keyBrowseButton, (String)NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.keyBrowseButton.text_1"));
        this.keyBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AuthenticationSettingsPanel.this.keyBrowseButtonActionPerformed(evt);
            }
        });
        GroupLayout authPanelLayout = new GroupLayout(this.authPanel);
        this.authPanel.setLayout(authPanelLayout);
        authPanelLayout.setHorizontalGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addContainerGap().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.pwdRadioButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.keyRadioButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pwdStoredLbl, -1, 199, Short.MAX_VALUE).addComponent(this.keyFld, -1, 199, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.pwdClearButton, -1, -1, Short.MAX_VALUE).addComponent(this.keyBrowseButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        authPanelLayout.setVerticalGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(authPanelLayout.createSequentialGroup().addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pwdRadioButton).addComponent(this.pwdClearButton).addComponent(this.pwdStoredLbl)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(authPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.keyRadioButton).addComponent(this.keyFld, -2, -1, -2).addComponent(this.keyBrowseButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.loginPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.authPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.loginPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.authPanel, -2, -1, -2)));
    }

    private void keyRadioButtonActionPerformed(ActionEvent evt) {
        this.enableControls();
        this.keyFld.requestFocus();
    }

    private void pwdClearButtonActionPerformed(ActionEvent evt) {
        PasswordManager.getInstance().forceClearPassword(this.env);
        this.pwdStoredLbl.setVisible(false);
        this.pwdClearButton.setEnabled(false);
    }

    private void keyBrowseButtonActionPerformed(ActionEvent evt) {
        SSHKeyFileChooser chooser = new SSHKeyFileChooser(this.keyFld.getText());
        int result = chooser.showOpenDialog(this);
        if (0 == result) {
            this.keyFld.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void pwdRadioButtonActionPerformed(ActionEvent evt) {
        this.enableControls();
    }

    private void enableControls() {
        this.keyBrowseButton.setEnabled(this.keyRadioButton.isSelected());
        this.keyFld.setEnabled(this.keyRadioButton.isSelected());
        this.validationTask.schedule(0);
    }

    @Override
    public boolean hasProblem() {
        return this.problem != null;
    }

    @Override
    public String getProblem() {
        return this.problem;
    }

    @Override
    public void applyChanges(Object customData) {
        ConnectionManagerAccessor access = ConnectionManagerAccessor.getDefault();
        if (customData instanceof ExecutionEnvironment) {
            ExecutionEnvironment e = (ExecutionEnvironment)customData;
            Authentication a = Authentication.getFor(e);
            if (this.auth.getType() == Authentication.Type.SSH_KEY) {
                a.setSSHKey(this.auth.getKey());
            } else {
                a.setPassword();
            }
            a.store();
            access.changeAuth(e, a);
        } else if (this.env != null) {
            this.auth.store();
            access.changeAuth(this.env, this.auth);
        }
    }

    private class ValidationTask
    implements Runnable {
        private ValidationTask() {
        }

        @Override
        public void run() {
            this.validate();
            AuthenticationSettingsPanel.this.fireChange();
        }

        private boolean validate() {
            if (AuthenticationSettingsPanel.this.pwdRadioButton.isSelected()) {
                AuthenticationSettingsPanel.this.problem = null;
                AuthenticationSettingsPanel.this.auth.setPassword();
                return true;
            }
            String key = AuthenticationSettingsPanel.this.keyFld.getText();
            if (key.length() == 0) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.emptyKey.text");
                return false;
            }
            if (!Authentication.isValidKey(key)) {
                AuthenticationSettingsPanel.this.problem = NbBundle.getMessage(AuthenticationSettingsPanel.class, (String)"AuthenticationSettingsPanel.validationError.invalidKey.text", (Object)key);
                return false;
            }
            AuthenticationSettingsPanel.this.auth.setSSHKey(key);
            AuthenticationSettingsPanel.this.problem = null;
            return true;
        }
    }
}

