/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.swing.outline;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.modules.websvc.manager.swing.outline.Outline;
import org.netbeans.modules.websvc.manager.swing.outline.RenderDataProvider;

public class DefaultOutlineCellRenderer
extends DefaultTableCellRenderer {
    private boolean expanded = false;
    private boolean leaf = true;
    private boolean showHandle = true;
    private int nestingDepth = 0;
    private static final Border expansionBorder = new ExpansionHandleBorder();

    @Override
    public final void setBorder(Border b) {
        if (b == expansionBorder) {
            super.setBorder(b);
        } else {
            super.setBorder(BorderFactory.createCompoundBorder(b, expansionBorder));
        }
    }

    private static Icon getDefaultOpenIcon() {
        return UIManager.getIcon("Tree.openIcon");
    }

    private static Icon getDefaultClosedIcon() {
        return UIManager.getIcon("Tree.closedIcon");
    }

    private static Icon getDefaultLeafIcon() {
        return UIManager.getIcon("Tree.leafIcon");
    }

    private static Icon getExpandedIcon() {
        return UIManager.getIcon("Tree.collapsedIcon");
    }

    private static Icon getCollapsedIcon() {
        return UIManager.getIcon("Tree.expandedIcon");
    }

    static int getNestingWidth() {
        return DefaultOutlineCellRenderer.getExpansionHandleWidth();
    }

    static int getExpansionHandleWidth() {
        return DefaultOutlineCellRenderer.getExpandedIcon().getIconWidth();
    }

    static int getExpansionHandleHeight() {
        return DefaultOutlineCellRenderer.getExpandedIcon().getIconHeight();
    }

    private void setNestingDepth(int i) {
        this.nestingDepth = i;
    }

    private void setExpanded(boolean val) {
        this.expanded = val;
    }

    private void setLeaf(boolean val) {
        this.leaf = val;
    }

    private void setShowHandle(boolean val) {
        this.showHandle = val;
    }

    private boolean isLeaf() {
        return this.leaf;
    }

    private boolean isExpanded() {
        return this.expanded;
    }

    private boolean isShowHandle() {
        return this.showHandle;
    }

    private int getNestingDepth() {
        return this.nestingDepth;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        DefaultOutlineCellRenderer c = (DefaultOutlineCellRenderer)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        Outline tbl = (Outline)table;
        if (tbl.isTreeColumnIndex(column)) {
            AbstractLayoutCache layout = tbl.getLayoutCache();
            boolean leaf = tbl.getOutlineModel().isLeaf(value);
            this.setLeaf(leaf);
            this.setShowHandle(true);
            TreePath path = layout.getPathForRow(row);
            boolean expanded = !layout.isExpanded(path);
            this.setExpanded(expanded);
            this.setNestingDepth(path.getPathCount() - 1);
            RenderDataProvider rendata = tbl.getRenderDataProvider();
            Icon icon = null;
            if (rendata != null) {
                String displayName = rendata.getDisplayName(value);
                if (displayName != null) {
                    this.setText(displayName);
                }
                this.setToolTipText(rendata.getTooltipText(value));
                Color bg = rendata.getBackground(value);
                Color fg = rendata.getForeground(value);
                if (bg != null && !isSelected) {
                    this.setBackground(bg);
                } else {
                    this.setBackground(isSelected ? tbl.getSelectionBackground() : tbl.getBackground());
                }
                if (fg != null && !isSelected) {
                    this.setForeground(fg);
                } else {
                    this.setForeground(isSelected ? tbl.getSelectionForeground() : tbl.getForeground());
                }
                icon = rendata.getIcon(value);
            }
            if (icon == null) {
                if (!leaf) {
                    if (expanded) {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultClosedIcon());
                    } else {
                        this.setIcon(DefaultOutlineCellRenderer.getDefaultOpenIcon());
                    }
                } else {
                    this.setIcon(DefaultOutlineCellRenderer.getDefaultLeafIcon());
                }
            }
        } else {
            this.setIcon(null);
            this.setShowHandle(false);
        }
        return this;
    }

    private static class ExpansionHandleBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);

        private ExpansionHandleBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            DefaultOutlineCellRenderer ren = (DefaultOutlineCellRenderer)c;
            if (ren.isShowHandle()) {
                this.insets.left = DefaultOutlineCellRenderer.getExpansionHandleWidth() + ren.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            } else {
                this.insets.left = 1;
                this.insets.top = 1;
                this.insets.right = 1;
                this.insets.bottom = 1;
            }
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            DefaultOutlineCellRenderer ren = (DefaultOutlineCellRenderer)c;
            if (ren.isShowHandle() && !ren.isLeaf()) {
                Icon icon = ren.isExpanded() ? DefaultOutlineCellRenderer.getExpandedIcon() : DefaultOutlineCellRenderer.getCollapsedIcon();
                int iconX = ren.getNestingDepth() * DefaultOutlineCellRenderer.getNestingWidth();
                int iconY = icon.getIconHeight() < height ? height / 2 - icon.getIconHeight() / 2 : 0;
                icon.paintIcon(c, g, iconX, iconY);
            }
        }
    }
}

